/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.io.serialization;

import com.evermind.io.IOUtils;
import com.evermind.io.serialization.MoldedSerializationContext;
import com.evermind.io.serialization.MoldedSerializer;
import com.evermind.util.ByteString;
import com.evermind.util.ObjectUtils;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;

public class MoldedObjectInputStream
extends ObjectInputStream {
    private InputStream in;
    private MoldedSerializationContext context;
    private Object[] readObjects = new Object[4];
    private int readObjectsCount;
    private Object[] argumentArray;
    private MoldedSerializer[] readTypes = new MoldedSerializer[4];
    private int readTypesCount;
    Object currentlyReading;

    public MoldedObjectInputStream(InputStream in) throws SecurityException, IOException {
        this(in, new MoldedSerializationContext());
    }

    public MoldedObjectInputStream(InputStream in, MoldedSerializationContext context) throws IOException, SecurityException {
        this.in = in;
        this.context = context;
    }

    protected final Object readObjectOverride() throws IOException, ClassNotFoundException {
        int command = this.in.read();
        if (command < 0) {
            throw new EOFException();
        }
        if (command == 114) {
            this.resetGraph();
            command = this.in.read();
        }
        if (command == 82) {
            this.readTypesCount = 0;
            command = this.in.read();
        }
        if (command == 112) {
            int id = this.readInt();
            System.out.println("Previous object: " + id);
            return this.readObjects[id];
        }
        Object object = this.readSimpleObject(command);
        if (object != null) {
            int count = this.readObjectsCount;
            Object[] objects = this.readObjects;
            if (count == objects.length) {
                Object[] newObjects = new Object[objects.length * 2];
                System.arraycopy(objects, 0, newObjects, 0, objects.length);
                this.readObjects = newObjects;
            }
            this.readObjects[count] = object;
            this.readObjectsCount = count + 1;
        }
        return object;
    }

    public int readInt() throws IOException {
        return IOUtils.readCompressedInt(this.in);
    }

    public int readUncompressedInt() throws IOException {
        int first = this.in.read();
        if (first < 0) {
            throw new EOFException();
        }
        int second = this.in.read();
        if (second < 0) {
            throw new EOFException();
        }
        int third = this.in.read();
        if (third < 0) {
            throw new EOFException();
        }
        int fourth = this.in.read();
        if (fourth < 0) {
            throw new EOFException();
        }
        System.out.println("Read uncompressed int: " + ((first << 24) + (second << 16) + (third << 8) + fourth));
        return (first << 24) + (second << 16) + (third << 8) + fourth;
    }

    public long readLong() throws IOException {
        return ((long)this.readInt() & 0xFFFFFFFFL) + (long)this.readInt() << 32;
    }

    public ByteString readByteString() throws IOException {
        int size = this.readInt();
        System.out.println("ByteString size: " + size + " " + (char)size);
        ByteString string = new ByteString(size);
        this.readFully(string.data, 0, size);
        string.length = size;
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readSimpleObject(int type) throws IOException, ClassNotFoundException {
        switch (type) {
            case 73: {
                return ObjectUtils.getInteger(IOUtils.readCompressedInt(this.in));
            }
            case 70: {
                return new Float(this.readFloat());
            }
            case 74: {
                return new Long(this.readLong());
            }
            case 68: {
                return new Double(this.readDouble());
            }
            case 66: {
                return new Byte(this.readByte());
            }
            case 90: {
                return this.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 83: {
                return new Short(this.readShort());
            }
            case 67: {
                return new Character(this.readChar());
            }
            case 115: {
                return this.readUTF();
            }
            case 76: {
                ByteString name = this.readByteString();
                System.out.println("Object type: " + name);
                MoldedSerializer serializer = this.context.getSerializer(Class.forName(name.toString()));
                this.addReadType(serializer);
                Object previouslyReading = this.currentlyReading;
                try {
                    Object object = serializer.read(this);
                    return object;
                }
                finally {
                    this.currentlyReading = previouslyReading;
                }
            }
            case 108: {
                Object previouslyReading = this.currentlyReading;
                try {
                    Object serializer = this.getSerializer(this.readInt()).read(this);
                    return serializer;
                }
                finally {
                    this.currentlyReading = previouslyReading;
                }
            }
            case 78: {
                return null;
            }
            case 98: {
                int length = IOUtils.readCompressedInt(this.in);
                byte[] data = new byte[length];
                this.readFully(data);
                return data;
            }
        }
        throw new IOException("Expected a type signal, got '" + (char)type + "'");
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readUncompressedInt());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public byte readByte() throws IOException {
        int i = this.read();
        if (i < 0) {
            throw new EOFException();
        }
        return (byte)i;
    }

    public boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    public short readShort() throws IOException {
        int lower = this.read();
        if (lower < 0) {
            throw new EOFException();
        }
        int higher = this.read();
        if (higher < 0) {
            throw new EOFException();
        }
        return (short)(lower + higher << 8);
    }

    public char readChar() throws IOException {
        int lower = this.read();
        if (lower < 0) {
            throw new EOFException();
        }
        int higher = this.read();
        if (higher < 0) {
            throw new EOFException();
        }
        return (char)(lower + higher << 8);
    }

    public String readUTF() throws IOException {
        char size = this.readChar();
        char[] body = new char[size];
        IOUtils.readUTFBody(this.in, body, 0, size);
        return new String(body);
    }

    public void readFully(byte[] data) throws IOException {
        this.readFully(data, 0, data.length);
    }

    public void readFully(byte[] data, int start, int length) throws IOException {
        int read;
        for (int pos = start; pos < start + length; pos += read) {
            read = this.read(data, pos, length - (pos - start));
            System.out.println("read: " + read);
            if (read >= 0) continue;
            throw new EOFException();
        }
    }

    protected Object[] getArgumentArray() {
        if (this.argumentArray == null) {
            this.argumentArray = new Object[]{this};
        }
        return this.argumentArray;
    }

    public int read() throws IOException {
        return this.in.read();
    }

    public int read(byte[] data) throws IOException {
        return this.in.read(data);
    }

    public int read(byte[] data, int start, int length) throws IOException {
        return this.in.read(data, start, length);
    }

    public void addReadType(MoldedSerializer serializer) {
        int count = this.readTypesCount;
        MoldedSerializer[] types = this.readTypes;
        if (count == types.length) {
            MoldedSerializer[] newTypes = new MoldedSerializer[types.length * 2];
            System.arraycopy(types, 0, newTypes, 0, types.length);
            this.readTypes = newTypes;
        }
        this.readTypes[count] = serializer;
        this.readTypesCount = count + 1;
    }

    public MoldedSerializer getSerializer(int index) throws IOException {
        if (index < 0 || index >= this.readTypesCount) {
            throw new IOException("Invalid class definition index");
        }
        return this.readTypes[index];
    }

    public void resetGraph() {
        int count = this.readObjectsCount;
        Object[] graph = this.readObjects;
        for (int i = 0; i < count; ++i) {
            graph[i] = null;
        }
        this.readObjectsCount = 0;
    }

    public void defaultReadObject() throws IOException, ClassNotFoundException {
        Object object = this.currentlyReading;
        this.context.getSerializer(object.getClass()).readDefault(this, object);
    }
}

