/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.io.serialization;

import com.evermind.io.IOUtils;
import com.evermind.io.serialization.MoldedObjectInputStream;
import com.evermind.io.serialization.MoldedObjectOutputStream;
import com.evermind.io.serialization.MoldedSerializationContext;
import com.evermind.io.serialization.MoldedSerializationField;
import com.evermind.io.serialization.MoldedSerializer;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;

public class ArrayMoldedSerializer
extends MoldedSerializer {
    private MoldedSerializationContext context;
    private Class classType;
    private byte type;

    public ArrayMoldedSerializer(MoldedSerializationContext context, Class classType) {
        this.context = context;
        this.classType = classType;
        this.type = MoldedSerializationField.getType(classType);
    }

    public void writeDefault(MoldedObjectOutputStream out, Object object) throws IOException {
        this.write(out, object);
    }

    public void write(MoldedObjectOutputStream out, Object object) throws IOException {
        if (object == null) {
            out.write(78);
        } else {
            block0 : switch (this.type) {
                case 66: {
                    byte[] data = (byte[])object;
                    out.writeInt(data.length);
                    out.write(data);
                    break;
                }
                case 73: {
                    int[] data = (int[])object;
                    out.writeInt(data.length);
                    for (int i = 0; i < data.length; ++i) {
                        out.writeInt(data[i]);
                    }
                    break;
                }
                case 83: {
                    short[] data = (short[])object;
                    out.writeInt(data.length);
                    for (int i = 0; i < data.length; i = (int)((short)(i + 1))) {
                        out.writeShort(data[i]);
                    }
                    break;
                }
                case 70: {
                    float[] data = (float[])object;
                    out.writeInt(data.length);
                    for (int i = 0; i < data.length; i = (int)((short)(i + 1))) {
                        out.writeFloat(data[i]);
                    }
                    break;
                }
                case 74: {
                    long[] data = (long[])object;
                    out.writeInt(data.length);
                    for (int i = 0; i < data.length; i = (int)((short)(i + 1))) {
                        out.writeLong(data[i]);
                    }
                    break;
                }
                case 68: {
                    double[] data = (double[])object;
                    out.writeInt(data.length);
                    for (int i = 0; i < data.length; i = (int)((short)(i + 1))) {
                        out.writeDouble(data[i]);
                    }
                    break;
                }
                case 67: {
                    char[] data = (char[])object;
                    out.writeInt(data.length);
                    IOUtils.writeUTFBody((OutputStream)out, data);
                    break;
                }
                case 90: {
                    boolean[] data = (boolean[])object;
                    out.writeInt(data.length);
                    int pos = 0;
                    int value = 0;
                    int qualifier = 1;
                    while (pos < data.length) {
                        if (data[pos]) {
                            value |= qualifier;
                        }
                        qualifier <<= 1;
                        if (++pos == data.length) {
                            out.write(value);
                            break block0;
                        }
                        if ((pos & 7) != 0) continue;
                        out.write(value);
                        value = 0;
                        qualifier = 1;
                    }
                    break;
                }
                default: {
                    Object[] array = (Object[])object;
                    out.writeInt(array.length);
                    for (int i = 0; i < array.length; ++i) {
                        out.writeObject(array[i]);
                    }
                }
            }
        }
    }

    public Object read(MoldedObjectInputStream in) throws IOException, ClassNotFoundException {
        int length = in.readInt();
        switch (this.type) {
            case 66: {
                byte[] data = new byte[length];
                in.readFully(data);
                return data;
            }
            case 73: {
                int[] data = new int[length];
                for (int i = 0; i < length; ++i) {
                    data[i] = in.readInt();
                }
                return data;
            }
            case 90: {
                boolean[] data = new boolean[length];
                int qualifier = 1;
                int value = in.read();
                for (int i = 0; i < length; ++i) {
                    if ((value & qualifier) != 0) {
                        data[i] = true;
                    }
                    qualifier <<= 2;
                    if ((i + 1 & 7) != 0) continue;
                    value = in.read();
                    qualifier = 1;
                }
                return data;
            }
            case 70: {
                float[] data = new float[length];
                for (int i = 0; i < length; ++i) {
                    data[i] = in.readFloat();
                }
                return data;
            }
            case 74: {
                long[] data = new long[length];
                for (int i = 0; i < length; ++i) {
                    data[i] = in.readLong();
                }
                return data;
            }
            case 68: {
                double[] data = new double[length];
                for (int i = 0; i < length; ++i) {
                    data[i] = in.readDouble();
                }
                return data;
            }
            case 83: {
                short[] data = new short[length];
                for (int i = 0; i < length; ++i) {
                    data[i] = in.readShort();
                }
                return data;
            }
            case 76: {
                Object[] data = (Object[])Array.newInstance(this.classType, length);
                for (int i = 0; i < data.length; ++i) {
                    data[i] = in.readObject();
                }
                return data;
            }
        }
        throw new InternalError("Unsupported type: " + this.type);
    }

    public void read(MoldedObjectInputStream in, Object instance) throws IOException, ClassNotFoundException {
    }

    public void readDefault(MoldedObjectInputStream in, Object instance) throws IOException, ClassNotFoundException {
        this.read(in, instance);
    }
}

