/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.io;

import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TimestampedPrintStream
extends PrintStream {
    private Date date = new Date();
    private DateFormat dateFormat = new SimpleDateFormat("yy/MM/dd HH:mm:ss ");
    private String dateFormatted = this.dateFormat.format(this.date);
    private boolean isNewLine = true;

    public TimestampedPrintStream(OutputStream out) {
        this(out, false);
    }

    public TimestampedPrintStream(OutputStream out, boolean autoFlush) {
        super(out, autoFlush);
    }

    private void addTimeStamp() {
        if (this.isNewLine) {
            this.date.setTime(System.currentTimeMillis());
            this.dateFormatted = this.dateFormat.format(this.date);
            super.print(this.dateFormatted);
            this.isNewLine = false;
        }
    }

    public void print(boolean boolean0) {
        this.addTimeStamp();
        super.print(boolean0);
    }

    public void print(char char0) {
        this.addTimeStamp();
        super.print(char0);
    }

    public void print(int int0) {
        this.addTimeStamp();
        super.print(int0);
    }

    public void print(long long0) {
        this.addTimeStamp();
        super.print(long0);
    }

    public void print(float float0) {
        this.addTimeStamp();
        super.print(float0);
    }

    public void print(double double0) {
        this.addTimeStamp();
        super.print(double0);
    }

    public void print(char[] charArray) {
        this.addTimeStamp();
        super.print(charArray);
    }

    public void print(String string) {
        this.addTimeStamp();
        super.print(string);
    }

    public void print(Object object) {
        this.addTimeStamp();
        super.print(object);
    }

    public void println() {
        this.isNewLine = true;
        super.println();
    }

    public void println(boolean boolean0) {
        super.println(boolean0);
        this.isNewLine = true;
    }

    public void println(char char0) {
        super.println(char0);
        this.isNewLine = true;
    }

    public void println(int int0) {
        super.println(int0);
        this.isNewLine = true;
    }

    public void println(long long0) {
        super.println(long0);
        this.isNewLine = true;
    }

    public void println(float float0) {
        super.println(float0);
        this.isNewLine = true;
    }

    public void println(double double0) {
        super.println(double0);
        this.isNewLine = true;
    }

    public void println(char[] charArray) {
        super.println(charArray);
        this.isNewLine = true;
    }

    public void println(String string) {
        super.println(string);
        this.isNewLine = true;
    }

    public void println(Object object) {
        super.println(object);
        this.isNewLine = true;
    }
}

