/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.io;

import com.evermind.util.ByteString;
import java.io.IOException;
import java.io.OutputStream;

public class InteractiveByteArrayOutputStream
extends OutputStream {
    private byte[] data = new byte[1000];
    private int pos;

    public byte[] getData() {
        return this.data;
    }

    public void write(int i) throws IOException {
        if (this.pos >= this.data.length - 1) {
            this.expand(1);
        }
        this.data[this.pos++] = (byte)i;
    }

    public void write(byte[] data, int start, int length) throws IOException {
        while (this.pos + length > this.data.length) {
            this.expand(length);
        }
        System.arraycopy(data, start, this.data, this.pos, length);
        this.pos += length;
    }

    public void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public void expand(int roomNeeded) {
        int newSize;
        for (newSize = this.data.length * 2; newSize < this.pos + roomNeeded; newSize *= 2) {
        }
        byte[] newData = new byte[newSize];
        System.arraycopy(this.data, 0, newData, 0, this.data.length);
        this.data = newData;
    }

    public void setPos(int pos) {
        this.pos = pos;
    }

    public int getPos() {
        return this.pos;
    }

    public void writeInt(int i) throws IOException {
        if (this.pos >= this.data.length - 4) {
            this.expand(4);
        }
        this.data[this.pos++] = (byte)(i >>> 24 & 0xFF);
        this.data[this.pos++] = (byte)(i >>> 16 & 0xFF);
        this.data[this.pos++] = (byte)(i >>> 8 & 0xFF);
        this.data[this.pos++] = (byte)(i >>> 0 & 0xFF);
    }

    public void writeShort(int i) throws IOException {
        if (this.pos >= this.data.length - 2) {
            this.expand(2);
        }
        this.data[this.pos++] = (byte)(i >>> 8 & 0xFF);
        this.data[this.pos++] = (byte)(i >>> 0 & 0xFF);
    }

    public ByteString toByteString() {
        return new ByteString(this.data, 0, this.pos);
    }
}

