/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.io;

import com.evermind.util.ObjectUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UTFDataFormatException;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class IOUtils {
    public static final byte[] CRLF = "\r\n".getBytes();

    public static byte[] getContent(URL url) throws IOException {
        if (url.getProtocol().equals("file")) {
            return IOUtils.getContent(new File(url.getFile()));
        }
        int contentLength = url.openConnection().getContentLength();
        InputStream in = url.openStream();
        if (contentLength >= 0) {
            int readThisTurn;
            byte[] data = new byte[contentLength];
            for (int readSoFar = 0; readSoFar < contentLength; readSoFar += readThisTurn) {
                readThisTurn = in.read(data, readSoFar, contentLength - readSoFar);
                if (readThisTurn >= 0) continue;
                throw new IOException();
            }
            return data;
        }
        return IOUtils.getContent(in);
    }

    public static byte[] getContent(String path) throws IOException {
        if (path.indexOf(":/") >= 0) {
            return IOUtils.getContent(new URL(path));
        }
        return IOUtils.getContent(new File(path));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getContent(File file) throws IOException {
        byte[] data = new byte[]{};
        if (file == null) {
            throw new IOException("Invalid file (null)");
        }
        if ((int)file.length() == 0 && file.isDirectory()) {
            throw new IOException("The file was a directory");
        }
        FileInputStream in = new FileInputStream(file);
        try {
            try {
                if (in != null) {
                    int bytesRead;
                    int BUFFER_SIZE = 1024;
                    int index = 0;
                    int bytesToRead = BUFFER_SIZE;
                    data = new byte[(int)file.length()];
                    if (bytesToRead > data.length) {
                        bytesToRead = data.length;
                    }
                    while ((bytesRead = ((InputStream)in).read(data, index, bytesToRead)) > 0) {
                        if (bytesToRead <= data.length - (index += bytesRead)) continue;
                        bytesToRead = data.length - index;
                    }
                }
                Object var8_8 = null;
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                ((InputStream)in).close();
                throw throwable;
            }
            catch (IOException e) {
                throw new IOException(e.getMessage());
            }
        }
        try {}
        catch (IOException e) {
            throw new IOException(e.getMessage());
        }
        ((InputStream)in).close();
        return data;
    }

    public static void writeContent(URL url, byte[] data) throws IOException {
        if (url.getProtocol().equals("file")) {
            IOUtils.writeContent(new File(url.getFile().replace('/', File.separatorChar)).getAbsolutePath(), data);
        } else {
            URLConnection connection = url.openConnection();
            OutputStream out = connection.getOutputStream();
            out.write(data);
            out.close();
        }
    }

    public static void writeContent(String path, byte[] data) throws IOException {
        if (path.indexOf(":/") >= 0) {
            URL url = new URL(path);
            OutputStream out = url.openConnection().getOutputStream();
            out.write(data);
            out.close();
        } else {
            IOUtils.writeContent(new File(path), data);
        }
    }

    public static void makePath(File file) {
        if (!file.getParentFile().exists()) {
            ArrayList<File> files = new ArrayList<File>();
            for (File currentFile = file.getParentFile(); currentFile != null && !currentFile.exists(); currentFile = currentFile.getParentFile()) {
                files.add(currentFile);
            }
            for (int i = files.size() - 1; i >= 0; --i) {
                ((File)files.get(i)).mkdir();
            }
        }
    }

    public static void writeContent(File file, byte[] data) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        ((OutputStream)out).write(data);
        ((OutputStream)out).close();
    }

    public static byte[] getSerialized(Object object) throws IOException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(byteOut);
        out.writeObject(object);
        out.flush();
        out.close();
        return byteOut.toByteArray();
    }

    public static Object deSerialize(byte[] data) throws IOException, ClassNotFoundException {
        return IOUtils.deSerialize(new ByteArrayInputStream(data));
    }

    public static Object deSerialize(InputStream basicIn) throws IOException, ClassNotFoundException {
        ObjectInputStream in = new ObjectInputStream(basicIn);
        return in.readObject();
    }

    public static void pipe(InputStream in, OutputStream out) throws IOException {
        IOUtils.pipe(in, out, new byte[10240]);
    }

    public static void pipe(InputStream in, OutputStream out, byte[] buffer) throws IOException {
        int lengthRead;
        while ((lengthRead = in.read(buffer)) >= 0) {
            out.write(buffer, 0, lengthRead);
        }
    }

    public static void pipe(Reader in, Writer out) throws IOException {
        IOUtils.pipe(in, out, new char[64000]);
    }

    public static void pipe(Reader in, Writer out, char[] buffer) throws IOException {
        int lengthRead;
        while ((lengthRead = in.read(buffer)) >= 0) {
            out.write(buffer, 0, lengthRead);
        }
    }

    public static List readStringList(ObjectInputStream in) throws IOException {
        ArrayList<String> strings = new ArrayList<String>();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            strings.add(in.readUTF());
        }
        return strings;
    }

    public static void writeStringList(List strings, ObjectOutputStream out) throws IOException {
        out.writeInt(strings.size());
        Iterator iterator = strings.iterator();
        while (iterator.hasNext()) {
            out.writeUTF(iterator.next().toString());
        }
    }

    public static byte[] getContent(InputStream in) throws IOException {
        int byteReadThisTurn;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int bytesRead = 0;
        while ((byteReadThisTurn = in.read(buffer, bytesRead, buffer.length - bytesRead)) >= 0) {
            if ((bytesRead += byteReadThisTurn) < buffer.length - 256) continue;
            byte[] newBuffer = new byte[buffer.length * 2];
            System.arraycopy(buffer, 0, newBuffer, 0, bytesRead);
            buffer = newBuffer;
        }
        if (buffer.length == bytesRead) {
            return buffer;
        }
        byte[] response = new byte[bytesRead];
        System.arraycopy(buffer, 0, response, 0, bytesRead);
        return response;
    }

    public static char[] getContent(Reader in) throws IOException {
        int charsRead;
        CharArrayWriter out = new CharArrayWriter();
        char[] buffer = new char[10240];
        while ((charsRead = in.read(buffer)) >= 0) {
            out.write(buffer, 0, charsRead);
        }
        return out.toCharArray();
    }

    public static void readFully(InputStream in, byte[] data) throws IOException {
        IOUtils.readFully(in, data, 0, data.length);
    }

    public static void readFully(InputStream in, byte[] data, int offset, int length) throws IOException {
        int pos = 0;
        while (pos < length) {
            if ((pos += in.read(data, pos + offset, length - pos)) >= 0) continue;
            throw new IOException("Unexpected EOS");
        }
    }

    public static void writeCompressedInt(OutputStream out, int command) throws IOException {
        if (command >= 0 && command < 128) {
            out.write(command);
        } else if (command >= 0 && command < 16384) {
            out.write(command | 0x80);
            out.write(command >>> 7);
        } else if (command >= 0 && command < 0x200000) {
            out.write(command | 0x80);
            out.write(command >>> 7 | 0x80);
            out.write(command >>> 14);
        } else if (command >= 0 && command < 0x10000000) {
            out.write(command | 0x80);
            out.write(command >>> 7 | 0x80);
            out.write(command >>> 14 | 0x80);
            out.write(command >>> 21);
        } else {
            out.write(command | 0x80);
            out.write(command >>> 7 | 0x80);
            out.write(command >>> 14 | 0x80);
            out.write(command >>> 21 | 0x80);
            out.write(command >>> 28);
        }
    }

    public static int readCompressedInt(InputStream in) throws IOException {
        int command = in.read();
        if (command < 0) {
            throw new EOFException();
        }
        if (command < 128) {
            return command;
        }
        int lower = command & 0x7F;
        int highOne = in.read();
        if (highOne < 0) {
            throw new EOFException();
        }
        if (highOne < 128) {
            return (highOne << 7) + lower;
        }
        int highTwo = in.read();
        if (highTwo < 0) {
            throw new EOFException();
        }
        if (highTwo < 128) {
            return (highTwo << 14) + ((highOne & 0x7F) << 7) + lower;
        }
        int highThree = in.read();
        if (highThree < 0) {
            throw new EOFException();
        }
        if (highThree < 128) {
            return (highThree << 21) + ((highTwo & 0x7F) << 14) + ((highOne & 0x7F) << 7) + lower;
        }
        int highFour = in.read();
        if (highFour < 0) {
            throw new EOFException();
        }
        return (highFour << 28) + ((highThree & 0x7F) << 21) + ((highTwo & 0x7F) << 14) + ((highOne & 0x7F) << 7) + lower;
    }

    public static long readCompressedInt(byte[] data, int pos) throws IOException {
        int highThree;
        int highTwo;
        int highOne;
        int command;
        if (pos >= data.length) {
            throw new EOFException();
        }
        if ((command = (char)data[pos++] & 0xFF) < 128) {
            return ((long)pos << 32) + (long)command;
        }
        int lower = command & 0x7F;
        if (pos >= data.length) {
            throw new EOFException();
        }
        if ((highOne = (char)data[pos++] & 0xFF) < 128) {
            return ((long)pos << 32) + (long)(highOne << 7) + (long)lower;
        }
        if (pos >= data.length) {
            throw new EOFException();
        }
        if ((highTwo = (char)data[pos++] & 0xFF) < 128) {
            return ((long)pos << 32) + (long)(highTwo << 14) + (long)((highOne & 0x7F) << 7) + (long)lower;
        }
        if (pos >= data.length) {
            throw new EOFException();
        }
        if ((highThree = (char)data[pos++] & 0xFF) < 128) {
            return ((long)pos << 32) + (long)(highThree << 21) + (long)((highTwo & 0x7F) << 14) + (long)((highOne & 0x7F) << 7) + (long)lower;
        }
        if (pos >= data.length) {
            throw new EOFException();
        }
        int highFour = (char)data[pos++] & 0xFF;
        return ((long)pos << 32) + (long)(highFour << 28) + (long)((highThree & 0x7F) << 21) + (long)((highTwo & 0x7F) << 14) + (long)((highOne & 0x7F) << 7) + (long)lower;
    }

    public static void writeUTFBody(OutputStream out, String string) throws IOException {
        int stringLength = string.length();
        for (int i = 0; i < stringLength; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                out.write((byte)c);
                continue;
            }
            if (c > '\u07ff') {
                out.write((byte)(0xE0 | c >> 12 & 0xF));
                out.write((byte)(0x80 | c >> 6 & 0x3F));
                out.write((byte)(0x80 | c >> 0 & 0x3F));
                continue;
            }
            out.write((byte)(0xC0 | c >> 6 & 0x1F));
            out.write((byte)(0x80 | c >> 0 & 0x3F));
        }
    }

    public static void writeUTFBody(OutputStream out, char[] array) throws IOException {
        int stringLength = array.length;
        for (int i = 0; i < stringLength; ++i) {
            char c = array[i];
            if (c >= '\u0001' && c <= '\u007f') {
                out.write((byte)c);
                continue;
            }
            if (c > '\u07ff') {
                out.write((byte)(0xE0 | c >> 12 & 0xF));
                out.write((byte)(0x80 | c >> 6 & 0x3F));
                out.write((byte)(0x80 | c >> 0 & 0x3F));
                continue;
            }
            out.write((byte)(0xC0 | c >> 6 & 0x1F));
            out.write((byte)(0x80 | c >> 0 & 0x3F));
        }
    }

    public static String readLongUTF(InputStream in) throws IOException {
        return IOUtils.readLongUTF(in, false);
    }

    public static String readLongUTF(InputStream in, boolean allowNull) throws IOException {
        int size = IOUtils.readCompressedInt(in);
        if (size < 0) {
            if (!allowNull) {
                throw new IOException("Read null string");
            }
            return null;
        }
        char[] data = new char[size];
        IOUtils.readUTFBody(in, data, 0, size);
        return new String(data);
    }

    public static void writeLongUTF(OutputStream out, String string) throws IOException {
        IOUtils.writeLongUTF(out, string, false);
    }

    public static void writeLongUTF(OutputStream out, String string, boolean allowNull) throws IOException {
        if (string == null) {
            if (!allowNull) {
                throw new NullPointerException("string was null");
            }
            IOUtils.writeCompressedInt(out, -1);
        } else {
            IOUtils.writeCompressedInt(out, string.length());
            IOUtils.writeUTFBody(out, string);
        }
    }

    public static void readUTFBody(InputStream in, char[] body, int offset, int length) throws IOException {
        block5: for (int i = 0; i < length; ++i) {
            int c = in.read() & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    body[offset + i] = (char)c;
                    continue block5;
                }
                case 12: 
                case 13: {
                    byte second = (byte)in.read();
                    if ((second & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    body[offset + i] = (char)((c & 0x1F) << 6 | second & 0x3F);
                    continue block5;
                }
                case 14: {
                    byte second = (byte)in.read();
                    byte third = (byte)in.read();
                    if ((second & 0xC0) != 128 || (third & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    body[offset + i] = (char)((c & 0xF) << 12 | (second & 0x3F) << 6 | (third & 0x3F) << 0);
                    continue block5;
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
        }
    }

    public static void writeShort(OutputStream out, short s) throws IOException {
        out.write(s >>> 8);
        out.write((byte)s);
    }

    public static int readShort(InputStream in) throws IOException {
        int higher = in.read();
        if (higher < 0) {
            throw new EOFException();
        }
        int lower = in.read();
        if (lower < 0) {
            throw new EOFException();
        }
        return (short)(lower + (higher << 8));
    }

    public static void writeUTF(OutputStream out, String string) throws IOException {
        IOUtils.writeShort(out, (short)string.length());
        IOUtils.writeUTFBody(out, string);
    }

    public static String readUTF(InputStream in) throws IOException {
        int length = IOUtils.readShort(in);
        if (length < 0) {
            throw new IOException("Invalid UTF length");
        }
        char[] chars = new char[length];
        IOUtils.readUTFBody(in, chars, 0, chars.length);
        return new String(chars);
    }

    public static void writeBoolean(OutputStream out, boolean b) throws IOException {
        out.write(b ? 1 : 0);
    }

    public static boolean readBoolean(InputStream in) throws IOException {
        int sign = in.read();
        if (sign < 0) {
            throw new EOFException();
        }
        return sign != 0;
    }

    public static void writeCompressedLong(OutputStream out, long l) throws IOException {
        IOUtils.writeCompressedInt(out, (int)l);
        IOUtils.writeCompressedInt(out, (int)(l >> 32));
    }

    public static long readCompressedLong(InputStream in) throws IOException {
        return IOUtils.readCompressedInt(in) + (IOUtils.readCompressedInt(in) << 32);
    }

    public static int writeCompressedInt(byte[] data, int pos, int command) {
        if (command >= 0 && command < 128) {
            data[pos++] = (byte)command;
        } else if (command >= 0 && command < 16384) {
            data[pos++] = (byte)(command | 0x80);
            data[pos++] = (byte)(command >>> 7);
        } else if (command >= 0 && command < 0x200000) {
            data[pos++] = (byte)(command | 0x80);
            data[pos++] = (byte)(command >>> 7 | 0x80);
            data[pos++] = (byte)(command >>> 14);
        } else if (command >= 0 && command < 0x10000000) {
            data[pos++] = (byte)(command | 0x80);
            data[pos++] = (byte)(command >>> 7 | 0x80);
            data[pos++] = (byte)(command >>> 14 | 0x80);
            data[pos++] = (byte)(command >>> 21);
        } else {
            data[pos++] = (byte)(command | 0x80);
            data[pos++] = (byte)(command >>> 7 | 0x80);
            data[pos++] = (byte)(command >>> 14 | 0x80);
            data[pos++] = (byte)(command >>> 21 | 0x80);
            data[pos++] = (byte)(command >>> 28);
        }
        return pos;
    }

    public static String getInstancePath(String path, String instanceId, boolean makePath) {
        if (instanceId == null || path.indexOf(instanceId) != -1) {
            return path;
        }
        File origFile = new File(path);
        String dir = origFile.getParent();
        dir = dir == null ? instanceId : dir + File.separator + instanceId;
        File newFile = new File(dir, origFile.getName());
        if (makePath && !newFile.exists()) {
            IOUtils.makePath(newFile);
        }
        return newFile.getPath();
    }

    public static String getInstanceDir(String path, String instanceId, boolean makePath) {
        File newFile;
        if (instanceId == null || path.indexOf(instanceId) != -1) {
            return path;
        }
        String newPath = null;
        newPath = path.endsWith(File.separator) ? path + instanceId + File.separator : (path.endsWith("/") ? path + instanceId + "/" : path + File.separator + instanceId);
        if (makePath && !(newFile = new File(newPath)).exists()) {
            newFile.mkdirs();
        }
        return newPath;
    }

    public static void writeSimpleObject(ObjectOutputStream out, Object object) throws IOException {
        if (object instanceof Number) {
            Class<?> type = object.getClass();
            if (type == Integer.class) {
                out.write(73);
                IOUtils.writeCompressedInt(out, (Integer)object);
                return;
            }
            if (type == Float.class) {
                out.write(70);
                out.writeFloat(((Float)object).floatValue());
                return;
            }
            if (type == Long.class) {
                out.write(74);
                out.writeLong((Long)object);
                return;
            }
            if (type == Double.class) {
                out.write(68);
                out.writeDouble((Double)object);
                return;
            }
            if (type == Byte.class) {
                out.write(66);
                out.writeByte(((Byte)object).byteValue());
                return;
            }
            if (type == Short.class) {
                out.write(83);
                out.writeShort(((Short)object).shortValue());
                return;
            }
        }
        if (object instanceof Character && object.getClass() == Character.class) {
            out.write(67);
            out.writeChar(((Character)object).charValue());
            return;
        }
        if (object instanceof Boolean && object.getClass() == Boolean.class) {
            out.write((Boolean)object != false ? 90 : 122);
            return;
        }
        if (object instanceof String) {
            out.write(115);
            out.writeUTF((String)object);
            return;
        }
        if (object == null) {
            out.write(78);
            return;
        }
        if (object instanceof byte[]) {
            out.write(98);
            IOUtils.writeCompressedInt(out, ((byte[])object).length);
            out.write((byte[])object);
            return;
        }
        out.write(76);
        out.writeObject(object);
    }

    public static Object readSimpleObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int type = in.read();
        switch (type) {
            case 73: {
                return ObjectUtils.getInteger(IOUtils.readCompressedInt(in));
            }
            case 70: {
                return new Float(in.readFloat());
            }
            case 74: {
                return new Long(in.readLong());
            }
            case 68: {
                return new Double(in.readDouble());
            }
            case 66: {
                return new Byte(in.readByte());
            }
            case 90: {
                return Boolean.TRUE;
            }
            case 122: {
                return Boolean.FALSE;
            }
            case 83: {
                return new Short(in.readShort());
            }
            case 67: {
                return new Character(in.readChar());
            }
            case 115: {
                return in.readUTF();
            }
            case 76: {
                return in.readObject();
            }
            case 78: {
                return null;
            }
            case 98: {
                int length = IOUtils.readCompressedInt(in);
                byte[] data = new byte[length];
                in.readFully(data);
                return data;
            }
        }
        throw new IOException("Expected a type signal, got '" + (char)type + "'");
    }
}

