/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ChunkedInputStream
extends FilterInputStream {
    private int available = 0;
    private byte[] buf = new byte[8];

    public ChunkedInputStream(InputStream in) {
        super(in);
    }

    public int available() {
        return this.available;
    }

    public int read() throws IOException {
        return 0;
    }

    public int read(byte[] buf, int offset, int len) throws IOException {
        block0 : switch (this.available) {
            case -1: {
                return -1;
            }
            case 0: {
                this.available = this.readChunkLength();
                if (this.available != 0) break;
                while (true) {
                    int ch;
                    if ((ch = this.in.read()) == 13) {
                        ch = this.in.read();
                        break block0;
                    }
                    ch = this.in.read();
                    while (ch > 0 && ch != 13) {
                        ch = this.in.read();
                    }
                    if (ch != 13) continue;
                    ch = this.in.read();
                }
            }
        }
        if (this.available <= 0) {
            this.available = -1;
            return -1;
        }
        if (this.available < len) {
            len = this.available;
        }
        if ((len = this.in.read(buf, offset, len)) > 0) {
            this.available -= len;
        }
        return len;
    }

    private int readChunkLength() throws IOException {
        int length = 0;
        int ch = this.in.read();
        while (ch == 13 || ch == 32 || ch == 10) {
            ch = this.in.read();
        }
        while (ch > 0 && ch != 13 && ch != 10 && ch != 59) {
            length <<= 4;
            switch (ch) {
                case 48: {
                    break;
                }
                case 49: {
                    ++length;
                    break;
                }
                case 50: {
                    length += 2;
                    break;
                }
                case 51: {
                    length += 3;
                    break;
                }
                case 52: {
                    length += 4;
                    break;
                }
                case 53: {
                    length += 5;
                    break;
                }
                case 54: {
                    length += 6;
                    break;
                }
                case 55: {
                    length += 7;
                    break;
                }
                case 56: {
                    length += 8;
                    break;
                }
                case 57: {
                    length += 9;
                    break;
                }
                case 65: 
                case 97: {
                    length += 10;
                    break;
                }
                case 66: 
                case 98: {
                    length += 11;
                    break;
                }
                case 67: 
                case 99: {
                    length += 12;
                    break;
                }
                case 68: 
                case 100: {
                    length += 13;
                    break;
                }
                case 69: 
                case 101: {
                    length += 14;
                    break;
                }
                case 70: 
                case 102: {
                    length += 15;
                    break;
                }
                case 9: 
                case 32: {
                    break;
                }
                default: {
                    throw new IOException("HTTP/1.1 protocol error: bad chunk");
                }
            }
            ch = this.in.read();
        }
        if (ch == 13) {
            ch = this.in.read();
        } else {
            ch = this.in.read();
            while (ch > 0 && ch != 13) {
                ch = this.in.read();
            }
            if (ch == 13) {
                ch = this.in.read();
            }
        }
        return length;
    }
}

