/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Base64OutputStream
extends FilterOutputStream {
    public static final byte[] CHAR_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final int BUFFER_SIZE = 76;
    private boolean closed;
    private int byte0;
    private int byte1;
    private int bufferPos;
    private int linePos;

    public Base64OutputStream(OutputStream out) {
        super(out);
    }

    public void write(int i) throws IOException {
        if (this.closed) {
            throw new IOException("Stream was closed");
        }
        if (this.bufferPos == 2) {
            if (this.linePos >= 76) {
                this.out.write(13);
                this.out.write(10);
            }
            this.out.write(CHAR_TABLE[this.byte0 >> 2]);
            this.out.write(CHAR_TABLE[(this.byte0 << 4) + (this.byte1 >> 4) & 0x3F]);
            this.out.write(CHAR_TABLE[(this.byte1 << 2) + (i >> 6) & 0x3F]);
            this.out.write(CHAR_TABLE[i & 0x3F]);
            this.linePos += 4;
            this.bufferPos = 0;
        } else {
            if (this.bufferPos == 1) {
                this.byte1 = i;
            } else {
                this.byte0 = i;
            }
            ++this.bufferPos;
        }
    }

    public void write(byte[] data, int offset, int length) throws IOException {
        if (this.closed) {
            throw new IOException("Stream was closed");
        }
        if (offset < 0 || length < 0 || data.length < (offset + length & Integer.MAX_VALUE)) {
            throw new IndexOutOfBoundsException();
        }
        while (this.bufferPos != 0) {
            this.out.write(data[offset++]);
        }
        int evenLength = length - length % 3;
        this.outputEncoded(data, offset, evenLength);
        while (evenLength != length) {
            this.write(data[offset + evenLength++]);
        }
    }

    private void outputEncoded(byte[] data, int offset, int length) throws IOException {
        byte[] ascii = new byte[78];
        int i = 0;
        while (offset < length) {
            if (this.linePos >= 76) {
                ascii[i] = 13;
                ascii[i + 1] = 10;
                this.out.write(ascii, 0, i + 2);
                this.linePos = 0;
                i = 0;
            }
            ascii[i] = CHAR_TABLE[data[offset] >> 2];
            ascii[i + 1] = CHAR_TABLE[(data[offset] << 4) + (data[offset + 1] >> 4) & 0x3F];
            ascii[i + 2] = CHAR_TABLE[(data[offset + 1] << 2) + (data[offset + 2] >> 6) & 0x3F];
            ascii[i + 3] = CHAR_TABLE[data[offset + 2] & 0x3F];
            this.linePos += 4;
            i += 4;
            offset += 3;
        }
        this.out.write(ascii, 0, i);
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.bufferPos == 1) {
            this.out.write(CHAR_TABLE[this.byte0 >> 2]);
            this.out.write(CHAR_TABLE[this.byte0 << 4 & 0x3F]);
            this.out.write(61);
            this.out.write(61);
        } else if (this.bufferPos == 2) {
            this.out.write(CHAR_TABLE[this.byte0 >> 2]);
            this.out.write(CHAR_TABLE[(this.byte0 << 4) + (this.byte1 >> 4) & 0x3F]);
            this.out.write(CHAR_TABLE[this.byte1 << 2 & 0x3F]);
            this.out.write(61);
        }
        this.closed = true;
    }
}

