/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.compiler;

import com.evermind.compiler.CompilationException;
import com.evermind.compiler.FileLinkedCompiler;
import com.evermind.io.IOUtils;
import com.evermind.util.CompilerProperties;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class NativeFileLinkedCompiler
extends FileLinkedCompiler {
    private String executable;
    private String corePath;

    public NativeFileLinkedCompiler(String executable, String corePath) {
        this.executable = executable;
        this.corePath = corePath;
    }

    protected String[] getCompilerArgs(String sourceDirectory, String targetDirectory, String classpath, String encoding) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this.executable);
        try {
            if (new File("..\\emd-ejb.jar").exists()) {
                commands.add("-g");
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (sourceDirectory != null) {
            commands.add("-depend");
        }
        if (targetDirectory != null) {
            commands.add("-d");
            commands.add(targetDirectory);
        }
        if (CompilerProperties.getKeepWrapperCode()) {
            commands.add("-g");
        } else {
            commands.add("-O");
        }
        commands.add("-classpath");
        commands.add((this.corePath == null ? "" : this.corePath + File.pathSeparatorChar) + classpath + File.pathSeparatorChar + '.');
        if (encoding != null) {
            commands.add("-encoding");
            commands.add(encoding);
        }
        String[] args = new String[commands.size()];
        commands.toArray(args);
        return args;
    }

    protected void compile(String[] compilerArgs, String firstFileName) throws InstantiationException, CompilationException {
        try {
            Process process = Runtime.getRuntime().exec(compilerArgs);
            process.getOutputStream().close();
            IOUtils.pipe(process.getErrorStream(), System.out);
            IOUtils.pipe(process.getInputStream(), System.out);
            if (process.waitFor() != 0) {
                throw new CompilationException("Error in source");
            }
            process.destroy();
            System.out.flush();
        }
        catch (InterruptedException e) {
            throw new CompilationException("Interrupted: " + e.getMessage());
        }
        catch (IOException e) {
            throw new CompilationException("Interrupted: " + e.getMessage());
        }
    }

    public boolean needsSecurityManager() {
        return false;
    }

    public void checkIfValid() throws InstantiationException {
    }

    public void setOutputStream(OutputStream out) {
    }
}

