/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.compiler;

import com.evermind.compiler.CompilationException;

public class CompilerUtils {
    public static final String NO_BATCH_COMPILE = "no_batch_compile";

    public static int getTokenPosition(String code, int pos, String delimeter) throws CompilationException {
        while (pos < code.length()) {
            char c = code.charAt(pos);
            if (!(c != delimeter.charAt(0) || pos != 0 && (Character.isJavaIdentifierPart(code.charAt(pos - 1)) || code.charAt(pos - 1) == '.') || pos + delimeter.length() > code.length() || pos + delimeter.length() != code.length() && Character.isJavaIdentifierPart(code.charAt(pos + delimeter.length())) || code.indexOf(delimeter, pos) != pos)) {
                return pos;
            }
            ++pos;
            if (c == '(') {
                pos = CompilerUtils.getEndOfParamBlock(code, pos);
            }
            if (c == '\"') {
                pos = CompilerUtils.getEndOfQuoteBlock(code, pos, false);
            }
            if (c != '\'') continue;
            pos = CompilerUtils.getEndOfQuoteBlock(code, pos, true);
        }
        return pos;
    }

    public static int getEndOfParamBlock(String code, int pos) throws CompilationException {
        while (pos < code.length()) {
            char c;
            if ((c = code.charAt(pos++)) == ')') {
                return pos;
            }
            if (c == '(') {
                pos = CompilerUtils.getEndOfParamBlock(code, pos);
            }
            if (c == '\"') {
                pos = CompilerUtils.getEndOfQuoteBlock(code, pos, false);
            }
            if (c != '\'') continue;
            pos = CompilerUtils.getEndOfQuoteBlock(code, pos, true);
        }
        throw new CompilationException("')' expected");
    }

    public static int getEndOfQuoteBlock(String code, int pos, boolean singleQuote) throws CompilationException {
        while (pos < code.length()) {
            char c;
            if ((c = code.charAt(pos++)) == (singleQuote ? (char)'\'' : '\"') && (pos >= code.length() || code.charAt(pos) != (singleQuote ? (char)'\'' : '\"'))) {
                return pos;
            }
            if (c != '\\') continue;
            ++pos;
        }
        throw new CompilationException((singleQuote ? "'" : "\"") + " expected");
    }
}

