/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.compiler;

import com.evermind.compiler.SyntaxError;
import java.util.StringTokenizer;

public class CodeStringTokenizer
extends StringTokenizer {
    int pos;
    String source;

    public CodeStringTokenizer(String source) {
        super("");
        source = this.removeMultiLineRemarks(source);
        source = this.removeRemarks(source);
        if (source.indexOf(10) >= 0) {
            source = source.replace('\n', ' ');
        }
        if (source.indexOf(13) >= 0) {
            source = source.replace('\r', ' ');
        }
        if (source.indexOf(9) >= 0) {
            source = source.replace('\t', ' ');
        }
        this.source = source;
    }

    public boolean nextCommandIsSingleLine() {
        return this.source.indexOf(59, this.pos) < this.source.indexOf(123, this.pos);
    }

    public String readSingleLine() {
        int oldPos = this.pos;
        while (this.source.charAt(oldPos) == ' ') {
            ++oldPos;
        }
        this.pos = this.source.indexOf(59, oldPos) + 1;
        return this.source.substring(oldPos, this.pos - 1);
    }

    public String readComplicatedLine() throws SyntaxError {
        int bracketDepth = 0;
        int paranthesisDepth = 0;
        try {
            while (this.source.charAt(this.pos) == ' ') {
                ++this.pos;
            }
            int oldPos = this.pos;
            block10: while (true) {
                switch (this.source.charAt(this.pos++)) {
                    case ';': {
                        if (bracketDepth != 0 || paranthesisDepth != 0) continue block10;
                        return this.source.substring(oldPos, this.pos - 1);
                    }
                    case '(': {
                        ++paranthesisDepth;
                        break;
                    }
                    case ')': {
                        --paranthesisDepth;
                        break;
                    }
                    case '{': {
                        ++bracketDepth;
                        break;
                    }
                    case '}': {
                        if (--bracketDepth != 0 || paranthesisDepth != 0) continue block10;
                        System.out.println("Found matching region");
                        return this.source.substring(oldPos, this.pos);
                    }
                }
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            if (paranthesisDepth == 0 && bracketDepth == 0) {
                return null;
            }
            throw new SyntaxError("Excpected '}'");
        }
    }

    public String readBracketRegion() {
        int bracketDepth = 0;
        while (this.source.charAt(this.pos) == ' ') {
            ++this.pos;
        }
        int oldPos = this.pos;
        while (true) {
            switch (this.source.charAt(this.pos++)) {
                case '{': {
                    ++bracketDepth;
                    break;
                }
                case '}': {
                    if (--bracketDepth != 0) break;
                    return this.source.substring(oldPos + 1, this.pos - 1);
                }
            }
        }
    }

    public String readSingleWord() {
        while (this.source.charAt(this.pos) == ' ' || this.source.charAt(this.pos) == ',') {
            ++this.pos;
        }
        if (this.source.charAt(this.pos) == '{') {
            return null;
        }
        int startPos = this.pos;
        while (Character.isLetterOrDigit(this.source.charAt(this.pos++))) {
        }
        return this.source.substring(startPos, this.pos - 1);
    }

    private String removeRemarks(String source) {
        int end;
        StringBuffer cleanCode = new StringBuffer(source.length());
        int start = 0;
        while ((end = source.indexOf("//", start)) >= 0) {
            cleanCode.append(source.substring(start, end));
            start = source.indexOf(10, end + 2);
        }
        cleanCode.append(source.substring(start, source.length()));
        return cleanCode.toString();
    }

    private String removeMultiLineRemarks(String source) {
        int end;
        StringBuffer cleanCode = new StringBuffer(source.length());
        int start = 0;
        while ((end = source.indexOf("/*", start)) >= 0) {
            cleanCode.append(source.substring(start, end));
            start = source.indexOf("*/", end + 2) + 2;
        }
        cleanCode.append(source.substring(start, source.length()));
        return cleanCode.toString();
    }
}

