/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.client.orion;

import com.evermind.client.orion.AdminCommandException;
import com.evermind.client.orion.ApplicationAdminCommandBase;
import java.util.List;
import oracle.oc4j.sql.config.ConnectionPoolConfig;
import oracle.oc4j.sql.config.ManagedDataSourceConfig;
import oracle.oc4j.sql.config.NativeDataSourceConfig;

public class ListDataSourceCommand
extends ApplicationAdminCommandBase {
    public ListDataSourceCommand(List args) throws AdminCommandException {
        super(args);
    }

    protected void doIt() throws AdminCommandException {
        List dsList = null;
        try {
            dsList = this._appAdmin.listDataSourceInfo();
        }
        catch (Exception e) {
            throw new AdminCommandException((Throwable)e, "Unable to listDataSourceInfo: " + e.getMessage());
        }
        if (dsList == null || dsList.size() == 0) {
            System.out.println("There are no data sources nor connection pools.");
            return;
        }
        int managedDataSourceCount = 0;
        int connectionPoolCount = 0;
        System.out.println("Native Data Sources:");
        for (int i = 0; i < dsList.size(); ++i) {
            Object config = dsList.get(i);
            if (config instanceof NativeDataSourceConfig) {
                NativeDataSourceConfig ndsc = (NativeDataSourceConfig)config;
                System.out.println("Name: " + ndsc.getName());
                System.out.println("JNDI Location: " + ndsc.getJndiName());
                System.out.println("Native Data Source Class: " + ndsc.getDataSourceClass());
                System.out.println("URL: " + ndsc.getUrl());
                System.out.println("");
                continue;
            }
            if (config instanceof ManagedDataSourceConfig) {
                if (managedDataSourceCount == 0) {
                    System.out.println("Managed Data Sources:");
                }
                ManagedDataSourceConfig mdsc = (ManagedDataSourceConfig)config;
                System.out.println("Name: " + mdsc.getName());
                System.out.println("JNDI Location: " + mdsc.getJndiName());
                System.out.println("Connection Pool Name: " + mdsc.getConnectionPoolName());
                System.out.println("Transaction Level: " + mdsc.getTxLevel());
                System.out.println("");
                ++managedDataSourceCount;
                continue;
            }
            if (!(config instanceof ConnectionPoolConfig)) continue;
            if (connectionPoolCount == 0) {
                System.out.println("Connection Pools:");
            }
            ConnectionPoolConfig cpc = (ConnectionPoolConfig)config;
            System.out.println("Pool Name: " + cpc.getName());
            System.out.println("Connection Factory Class: " + cpc.getConnectionFactoryConfig().getFactoryClass());
            System.out.println("Connection Factory URL: " + cpc.getConnectionFactoryConfig().getUrl());
            System.out.println("");
            ++connectionPoolCount;
        }
    }
}

