/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.client.orion;

import com.evermind.client.orion.AdminCommandBase;
import com.evermind.client.orion.AdminCommandConstants;
import com.evermind.client.orion.AdminCommandException;
import com.evermind.server.administration.ApplicationAdministrator;
import com.evermind.server.administration.ApplicationServerAdministrator;
import java.util.List;

public abstract class ApplicationAdminCommandBase
extends AdminCommandBase
implements AdminCommandConstants {
    protected String _appName = this.getNextArgument("application name");
    protected ApplicationServerAdministrator _admin;
    protected ApplicationAdministrator _appAdmin;

    public ApplicationAdminCommandBase(List args) throws AdminCommandException {
        super(args);
    }

    public void execute(ApplicationServerAdministrator admin) throws AdminCommandException {
        try {
            this._admin = admin;
            this._appAdmin = "default".equals(this._appName) ? admin.getDefaultApplication() : admin.getApplication(this._appName);
        }
        catch (Exception e) {
            throw new AdminCommandException(e, "Unable to find the administrator for application " + this._appName, 15);
        }
        if (this._appAdmin == null) {
            throw new AdminCommandException("Unable to find the administrator for application " + this._appName, 15);
        }
        this.doIt();
    }

    protected abstract void doIt() throws AdminCommandException;
}

