/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.client.orion;

import com.evermind.client.orion.AdminCommandConstants;
import com.evermind.client.orion.AdminCommandException;
import com.evermind.client.orion.UploadFileIterator;
import com.evermind.io.IOUtils;
import com.evermind.server.administration.ApplicationServerAdministrator;
import com.evermind.server.rmi.RMILocation;
import com.evermind.util.ConsoleObfuscator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PushbackInputStream;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;

public class AdminCommandUtils
implements AdminCommandConstants {
    public static String getNextArgument(List args, String description) throws AdminCommandException {
        return AdminCommandUtils.getNextArgument(args, description, false);
    }

    public static String getNextArgument(List args, String description, boolean optional) throws AdminCommandException {
        if (args == null || args.isEmpty()) {
            if (optional) {
                return null;
            }
            throw new AdminCommandException("miss argument: " + description, 11);
        }
        return (String)args.remove(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map parseInput(List args) throws AdminCommandException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        while (!args.isEmpty()) {
            Object value;
            String param;
            String command = AdminCommandUtils.getNextArgument(args, "command");
            String varName = command.substring(1);
            if (!command.equals("-host") && !command.equals("-port") && !command.equals("-display-name") && !command.equals("-virtual-hosts") && !command.equals("-oldHost") && !command.equals("-oldPort") && !command.equals("-newHost") && !command.equals("-newPort") && !command.equals("-secure") && !command.equals("-factory") && !command.equals("-keystore") && !command.equals("-storepass") && !command.equals("-provider") && !command.equals("-needs-client-auth") && !command.equals("-location") && !command.equals("-oldLocation") && !command.equals("-newLocation") && !command.equals("-pooledLocation") && !command.equals("-url") && !command.equals("-jar") && !command.equals("-xaLocation") && !command.equals("-ejbLocation") && !command.equals("-username") && !command.equals("-password") && !command.equals("-connectionDriver") && !command.equals("-sourceLocation") && !command.equals("-xaSourceLocation") && !command.equals("-className")) throw new AdminCommandException("Unknown switch: " + command, 10);
            if (varName.equals("port") || varName.equals("oldPort") || varName.equals("newPort")) {
                param = AdminCommandUtils.getNextArgument(args, "argument following " + command);
                int port = AdminCommandUtils.parsePort(param);
                if (port < 0) {
                    throw new AdminCommandException("invalid port format :" + param, 12);
                }
                value = new Integer(port);
                paramMap.put(varName, value);
                continue;
            }
            if (varName.equals("host") || varName.equals("oldHost") || varName.equals("newHost")) {
                param = AdminCommandUtils.getNextArgument(args, "argument following " + command);
                value = AdminCommandUtils.parseHostName(param);
                paramMap.put(varName, value);
                continue;
            }
            if (varName.equals("jar")) {
                byte[] data;
                File jarFile = new File(AdminCommandUtils.getNextArgument(args, "filename for -jar"));
                try {
                    data = IOUtils.getContent(jarFile);
                }
                catch (Exception e) {
                    throw new AdminCommandException(e, "Unable to read file " + jarFile.getPath(), 13);
                }
                paramMap.put("jar", data);
                paramMap.put("jarName", jarFile.getName());
                continue;
            }
            if (varName.equals("secure") || varName.equals("needs-client-auth")) {
                param = AdminCommandUtils.getNextArgument(args, "argument following " + command);
                if (param == null) {
                    value = "true";
                } else {
                    if (!"true".equalsIgnoreCase(param) && !"false".equalsIgnoreCase(param)) throw new AdminCommandException("Invalid " + varName + " value (true/false only)", 14);
                    value = param;
                }
            } else {
                value = AdminCommandUtils.getNextArgument(args, "argument following " + command);
            }
            paramMap.put(varName, value);
        }
        return paramMap;
    }

    public static String parseHostName(String hostName) {
        if (hostName == null || hostName.trim().length() == 0) {
            hostName = "[ALL]";
        }
        if (hostName.equalsIgnoreCase("[ALL]")) {
            return "0.0.0.0";
        }
        return hostName;
    }

    public static int parsePort(String port) {
        try {
            return Integer.parseInt(port);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static boolean isValidOrmiUrl(String ormiUrl) {
        try {
            RMILocation location = RMILocation.createRMILocation(ormiUrl);
            return !location.isLookupURL(true);
        }
        catch (NamingException e) {
            return false;
        }
    }

    public static boolean isLocalHost(String ormiUrl) {
        try {
            RMILocation location = RMILocation.createRMILocation(ormiUrl);
            return !location.isLookupURL(true) && location.isLocal();
        }
        catch (NamingException e) {
            return false;
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    public static Integer uploadFile(ApplicationServerAdministrator admin, File uploadFile, String uploadName) throws AdminCommandException {
        try {
            System.out.println("Uploading file " + uploadFile.getAbsolutePath() + " to oc4j server side");
            UploadFileIterator iterator = new UploadFileIterator(uploadFile);
            if (!iterator.hasMoreBytes()) {
                throw new AdminCommandException("Uploaded file should not be empty!");
            }
            Integer id = admin.beginUpload(uploadName);
            while (iterator.hasMoreBytes()) {
                admin.upload(id, iterator.getBytes());
            }
            admin.endUpload(id);
            return id;
        }
        catch (Exception e) {
            throw new AdminCommandException(e);
        }
    }

    public static String queryPasswordFromUser() throws AdminCommandException, IOException {
        String pwdPrompt = "Enter password: ";
        char[] password = AdminCommandUtils.readPassword(System.out, System.in, pwdPrompt);
        if (password == null) {
            throw new AdminCommandException("Empty password.");
        }
        if (!AdminCommandUtils.isValidPwd(password)) {
            throw new AdminCommandException("Should not contain special characters in the password.");
        }
        return new String(password);
    }

    static char[] testReadPassword(PrintStream out, InputStream in) throws IOException {
        return AdminCommandUtils.readPassword(out, in, "Enter password:");
    }

    /*
     * WARNING - void declaration
     */
    private static char[] readPassword(PrintStream outs, InputStream ins, String prompt) throws IOException {
        char[] lineBuffer;
        ConsoleObfuscator obfuscator = new ConsoleObfuscator(outs, prompt);
        obfuscator.start();
        InputStream in = ins;
        char[] buf = lineBuffer = new char[128];
        int room = buf.length;
        int offset = 0;
        block4: while (true) {
            int c = in.read();
            switch (c) {
                case -1: 
                case 10: {
                    break block4;
                }
                case 13: {
                    int c2 = in.read();
                    if (c2 == 10 || c2 == -1) break block4;
                    if (!(in instanceof PushbackInputStream)) {
                        in = new PushbackInputStream(in);
                    }
                    ((PushbackInputStream)in).unread(c2);
                }
                default: {
                    void var10_9;
                    if (--room < 0) {
                        buf = new char[offset + 128];
                        room = buf.length - offset - 1;
                        System.arraycopy(lineBuffer, 0, buf, 0, offset);
                        Arrays.fill(lineBuffer, ' ');
                        lineBuffer = buf;
                    }
                    buf[offset++] = (char)var10_9;
                    continue block4;
                }
            }
            break;
        }
        obfuscator.finishObfuscate();
        if (offset == 0) {
            return null;
        }
        char[] ret = new char[offset];
        System.arraycopy(buf, 0, ret, 0, offset);
        Arrays.fill(buf, ' ');
        return ret;
    }

    private static boolean isValidPwd(char[] c) {
        char[] specialPwd = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '_', '-'};
        boolean found = false;
        for (int i = 0; i < c.length; ++i) {
            found = false;
            for (int j = 0; j < specialPwd.length; ++j) {
                if (c[i] != specialPwd[j]) continue;
                found = true;
                break;
            }
            if (!found) break;
        }
        return found;
    }
}

