/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.bytecode;

import com.evermind.bytecode.CodeAttribute;
import com.evermind.bytecode.CodeOutputStream;
import com.evermind.bytecode.ExceptionRegion;
import com.evermind.util.ByteString;
import java.io.IOException;
import java.lang.reflect.Method;

public class ProxyCodeAttribute
extends CodeAttribute {
    protected Method method;
    protected int methodID;

    public ProxyCodeAttribute(Method method, int methodID) {
        this.method = method;
        this.methodID = methodID;
    }

    protected void writeCode(CodeOutputStream out) throws IOException {
        out.writeLoadObject(0);
        out.setMaxLocals(this.method.getParameterTypes().length * 2 + 6);
        out.writeGetField2(new ByteString("com/evermind/reflect/Proxy"), new ByteString("handler"), new ByteString("Lcom/evermind/reflect/InvocationHandler;"), false);
        out.writeLoadObject(0);
        out.writeGetStatic2(out.getSerialization().getType().getName(), new ByteString("METHOD_" + this.methodID), new ByteString("Ljava/lang/reflect/Method;"), false);
        Class<?>[] arguments = this.method.getParameterTypes();
        if (arguments.length == 0) {
            out.writeLoadNull();
        } else {
            out.writeIntegerConstant(arguments.length);
            out.writeNewObjectArray(CodeOutputStream.JAVA_LANG_OBJECT);
        }
        int pos = 1;
        for (int i = 0; i < arguments.length; ++i) {
            out.writeDuplicate();
            out.writeIntegerConstant(i);
            out.writeLoadObject(pos++, arguments[i]);
            if (arguments[i] == Long.TYPE || arguments[i] == Double.TYPE) {
                ++pos;
            }
            out.writeObjectArrayStore();
        }
        out.writeInvokeInterfaceMethod(new ByteString("com/evermind/reflect/InvocationHandler"), new ByteString("invoke"), new ByteString("(Ljava/lang/Object;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;"), 4, 2);
        Class<?> returnType = this.method.getReturnType();
        out.writeConvertToType(returnType);
        if (returnType == Void.TYPE) {
            out.writeReturn();
        } else if (returnType == Integer.TYPE) {
            out.writeReturnInteger();
        } else if (returnType == Byte.TYPE) {
            out.writeReturnInteger();
        } else if (returnType == Character.TYPE) {
            out.writeReturnInteger();
        } else if (returnType == Boolean.TYPE) {
            out.writeReturnInteger();
        } else if (returnType == Short.TYPE) {
            out.writeReturnInteger();
        } else if (returnType == Long.TYPE) {
            out.writeReturnLong();
        } else if (returnType == Double.TYPE) {
            out.writeReturnDouble();
        } else if (returnType == Float.TYPE) {
            out.writeReturnFloat();
        } else {
            out.writeReturnObject();
        }
        int endPos = out.getPosition() - 1;
        Class<?>[] exceptions = this.method.getExceptionTypes();
        for (int i = 0; i < exceptions.length; ++i) {
            out.setCurrentStackDepth(1);
            out.addException(new ExceptionRegion(0, endPos, out.getPosition(), new ByteString(exceptions[i].getName().replace('.', '/'))));
            out.writeThrow();
        }
        out.setCurrentStackDepth(1);
        out.addException(new ExceptionRegion(0, endPos, out.getPosition(), new ByteString("java/lang/RuntimeException")));
        out.writeThrow();
        out.setCurrentStackDepth(1);
        out.addException(new ExceptionRegion(0, endPos, out.getPosition(), new ByteString("java/lang/Error")));
        out.writeThrow();
        out.setCurrentStackDepth(1);
        out.addException(new ExceptionRegion(0, endPos, out.getPosition(), null));
        out.writeStoreObject(arguments.length + 1);
        out.writeNew(new ByteString("com/evermind/reflect/UndeclaredExceptionTypeException"));
        out.writeDuplicate();
        out.writeLoadObject(arguments.length + 1);
        out.writeInvokeMethod(CodeOutputStream.JAVA_LANG_OBJECT, new ByteString("getClass"), new ByteString("()Ljava/lang/Class;"), -1);
        out.writeInvokeMethod(CodeOutputStream.JAVA_LANG_CLASS, CodeOutputStream.GETNAME, CodeOutputStream.JAVA_LANG_STRING_RETURN, -1);
        out.writeLoadObject(arguments.length + 1);
        out.writeInvokeSpecialMethod(new ByteString("com/evermind/reflect/UndeclaredExceptionTypeException"), CodeOutputStream.INIT, new ByteString("(Ljava/lang/String;Ljava/lang/Throwable;)V"), 2);
        out.writeThrow();
    }
}

