/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.bytecode;

import com.evermind.bytecode.ClassFormatException;
import com.evermind.bytecode.ClassSerialization;
import com.evermind.bytecode.PoolEntry;
import com.evermind.bytecode.Verifier;
import com.evermind.io.InteractiveByteArrayOutputStream;
import com.evermind.util.ByteString;
import java.io.IOException;

public class NameAndTypePoolEntry
extends PoolEntry {
    public short nameIndex;
    public short typeIndex;

    public NameAndTypePoolEntry() {
    }

    public NameAndTypePoolEntry(short nameIndex, short typeIndex) {
        this.nameIndex = nameIndex;
        this.typeIndex = typeIndex;
    }

    public void write(InteractiveByteArrayOutputStream out) throws IOException {
        out.write(12);
        out.writeShort(this.nameIndex);
        out.writeShort(this.typeIndex);
    }

    public String toString() {
        return "nameAndType " + this.nameIndex + " " + this.typeIndex;
    }

    public void verify(ClassSerialization serialization) throws ClassFormatException {
        ByteString name = serialization.getUTF8Entry(this.nameIndex);
        ByteString type = serialization.getUTF8Entry(this.typeIndex);
        for (int i = 0; i < name.length(); ++i) {
            if (Verifier.isValidEncodedIdentifier(name.charAt(i), i == 0) || name.equals(new ByteString("<init>")) || name.equals(new ByteString("<clinit>"))) continue;
            throw new ClassFormatException("Invalid java identifier name: " + name);
        }
        if (type.length() == 0) {
            throw new ClassFormatException("type length was zero");
        }
        if (type.charAt(0) == '(') {
            int pos = 1;
            while (pos < type.length()) {
                if (type.charAt(pos) == ')') {
                    int endPos;
                    if ((endPos = NameAndTypePoolEntry.verifySignaturePart(type, ++pos, true)) != type.length()) {
                        throw new ClassFormatException("Invalid signature, trash at end of signature: '" + type + "' ('" + type.substring(endPos) + "')");
                    }
                    break;
                }
                pos = NameAndTypePoolEntry.verifySignaturePart(type, pos, false);
            }
        } else {
            int endPos = NameAndTypePoolEntry.verifySignaturePart(type, 0, true);
            if (endPos != type.length()) {
                throw new ClassFormatException("Invalid identifier, trash at end of identifier: " + type + " (" + type.substring(endPos) + ")");
            }
        }
    }

    public static int verifySignaturePart(ByteString type, int pos, boolean end) throws ClassFormatException {
        while (type.charAt(pos) == '[') {
            if (++pos != type.length()) continue;
            throw new ClassFormatException("Invalid identifier: " + type + ", ends with [");
        }
        block0 : switch (type.charAt(pos)) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                ++pos;
                break;
            }
            case 'V': {
                ++pos;
                if (end) break;
                throw new ClassFormatException("Invalid signature: " + type + ", V was part of the argument signature");
            }
            case 'L': {
                char c;
                int start = ++pos;
                do {
                    if (pos >= type.length()) {
                        throw new ClassFormatException("Invalid identifier: " + type + ", unexpected end of identifier");
                    }
                    if ((c = type.charAt(pos++)) == ';') break block0;
                } while (Verifier.isValidEncodedIdentifier(c, pos == start + 1));
                throw new ClassFormatException("Invalid identifier: " + type + ", unexpected token: " + c);
            }
            default: {
                throw new ClassFormatException("Invalid identifier: " + type + ", illegal type: " + type.charAt(pos));
            }
        }
        return pos;
    }
}

