/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.bytecode;

import com.evermind.bytecode.Attribute;
import com.evermind.bytecode.ClassSerialization;
import com.evermind.io.InteractiveByteArrayOutputStream;
import com.evermind.util.ByteString;
import java.io.DataInputStream;
import java.io.IOException;

public class LineNumberTableAttribute
implements Attribute {
    int[] lineData;
    int count;

    public LineNumberTableAttribute(DataInputStream in) throws IOException {
        this.count = in.readShort();
        this.lineData = new int[this.count];
        for (int i = 0; i < this.count; ++i) {
            this.lineData[i] = in.readInt();
        }
    }

    public int getLineNumber(int pos) {
        for (int i = 0; i < this.count; ++i) {
            if (this.lineData[i] >>> 16 <= pos) continue;
            return this.lineData[i - 1] & 0xFFFF;
        }
        return this.lineData[this.count - 1] & 0xFFFF;
    }

    public ByteString getName() {
        return new ByteString("LineNumberTable");
    }

    public void write(ClassSerialization type, InteractiveByteArrayOutputStream out) throws IOException {
        out.writeShort(type.getPoolIndex(this.getName()));
        out.writeInt(2 + this.count * 4);
        out.writeShort(this.count);
        for (int i = 0; i < this.count; ++i) {
            out.writeInt(this.lineData[i]);
        }
    }
}

