/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.bytecode;

import com.evermind.bytecode.CodeAttribute;
import com.evermind.bytecode.CodeOutputStream;
import com.evermind.util.ByteString;
import com.evermind.util.ClassUtils;
import java.io.IOException;
import java.lang.reflect.Constructor;

public class ConstructorCodeAttribute
extends CodeAttribute {
    protected Constructor constructor;

    public ConstructorCodeAttribute(Constructor constructor) {
        this.constructor = constructor;
    }

    protected void writeCode(CodeOutputStream out) throws IOException {
        Class[] args = this.constructor.getParameterTypes();
        out.setMaxLocals(args.length * 2 + 2);
        out.writeLoadObject(0);
        int argsSize = 0;
        for (int i = 0; i < args.length; ++i) {
            argsSize = args[i] == Long.TYPE || args[i] == Double.TYPE ? (argsSize += 2) : ++argsSize;
            out.writeLoadObject(i + 1);
        }
        out.writeInvokeSpecialMethod(new ByteString(this.constructor.getDeclaringClass().getName().replace('.', '/')), CodeOutputStream.INIT, new ByteString(ClassUtils.getCodedArguments(args, Void.TYPE)), argsSize);
        out.writeReturn();
    }
}

