/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.bytecode;

import com.evermind.bytecode.Attribute;
import com.evermind.bytecode.ClassSerialization;
import com.evermind.io.InteractiveByteArrayOutputStream;
import com.evermind.util.ByteString;
import java.io.IOException;

public class ConstantAttribute
implements Attribute {
    public ByteString name;
    public Object value;

    public ConstantAttribute(ByteString name, Object value) {
        this.name = name;
        this.value = value;
    }

    public ByteString getName() {
        return this.name;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(ClassSerialization type, InteractiveByteArrayOutputStream out) throws IOException {
        out.writeShort(type.getPoolIndex(this.name));
        if (this.value != null) {
            out.writeInt(2);
            if (this.value instanceof Integer) {
                out.writeShort(type.getPoolIndex(((Number)this.value).intValue()));
                return;
            } else if (this.value instanceof ByteString) {
                out.writeShort(type.getStringPoolIndex((ByteString)this.value));
                return;
            } else if (this.value instanceof Boolean) {
                out.writeShort(type.getPoolIndex((Boolean)this.value != false ? 1 : 0));
                return;
            } else if (this.value instanceof Float) {
                out.writeShort(type.getPoolIndex(((Float)this.value).floatValue()));
                return;
            } else if (this.value instanceof Long) {
                out.writeShort(type.getPoolIndex((Long)this.value));
                return;
            } else if (this.value instanceof Double) {
                out.writeShort(type.getPoolIndex((Double)this.value));
                return;
            } else if (this.value instanceof Character) {
                out.writeShort(type.getPoolIndex(((Character)this.value).charValue()));
                return;
            } else {
                if (!(this.value instanceof String)) throw new IOException("Bad constant type: " + this.value.getClass());
                out.writeShort(type.getStringPoolIndex(new ByteString(this.value.toString())));
            }
            return;
        } else {
            out.writeInt(0);
        }
    }
}

