/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.bytecode;

import com.evermind.bytecode.ClassSerialization;
import com.evermind.bytecode.ExceptionRegion;
import com.evermind.io.InteractiveByteArrayOutputStream;
import com.evermind.util.ByteString;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CodeOutputStream
extends OutputStream {
    static final ByteString JAVA_LANG_CLASS = new ByteString("java/lang/Class");
    static final ByteString GETNAME = new ByteString("getName");
    static final ByteString JAVA_LANG_STRING_RETURN = new ByteString("()Ljava/lang/String;");
    static final ByteString INIT = new ByteString("<init>");
    public static final ByteString JAVA_LANG_OBJECT = new ByteString("java/lang/Object");
    static final ByteString JAVA_LANG_NUMBER = new ByteString("java/lang/Number");
    protected InteractiveByteArrayOutputStream out;
    protected ClassSerialization type;
    protected int maxLocals;
    protected int maxStack;
    protected int offset;
    protected int currentStackDepth;
    protected List exceptions;
    protected int[] lineNumbers;
    protected int lineNumberLength;

    public CodeOutputStream(InteractiveByteArrayOutputStream out, ClassSerialization type) {
        this.out = out;
        this.type = type;
        this.offset = out.getPos();
    }

    public void addException(ExceptionRegion region) {
        if (this.exceptions == null) {
            this.exceptions = new ArrayList();
        }
        this.exceptions.add(region);
    }

    public List getExceptions() {
        if (this.exceptions == null) {
            return Collections.EMPTY_LIST;
        }
        return this.exceptions;
    }

    public ClassSerialization getSerialization() {
        return this.type;
    }

    public void writeLoadObject(int index) throws IOException {
        if (this.maxLocals <= index) {
            this.setMaxLocals(index + 1);
        }
        if (index == 0) {
            this.out.write(42);
        } else if (index == 1) {
            this.out.write(43);
        } else if (index == 2) {
            this.out.write(44);
        } else if (index == 3) {
            this.out.write(45);
        } else {
            if (index >= 256) {
                this.out.write(196);
            }
            this.out.write(25);
            if (index >= 256) {
                this.out.writeShort(index);
            } else {
                this.out.write((byte)index);
            }
        }
        this.addCurrentStackDepth(1);
    }

    public void writeStoreObject(int index) throws IOException {
        if (this.maxLocals <= index) {
            this.setMaxLocals(index + 1);
        }
        if (index == 0) {
            this.out.write(75);
        } else if (index == 1) {
            this.out.write(76);
        } else if (index == 2) {
            this.out.write(77);
        } else if (index == 3) {
            this.out.write(78);
        } else {
            if (index >= 256) {
                this.out.write(196);
            }
            this.out.write(58);
            if (index >= 256) {
                this.out.writeShort(index);
            } else {
                this.out.write((byte)index);
            }
        }
        this.decreaseStackDepth(1);
    }

    public void writeThrow() throws IOException {
        this.out.write(191);
        this.decreaseStackDepth(1);
    }

    public void writeLoadInteger(int index) throws IOException {
        if (this.maxLocals <= index) {
            this.setMaxLocals(index + 1);
        }
        if (index == 0) {
            this.out.write(26);
        } else if (index == 1) {
            this.out.write(27);
        } else if (index == 2) {
            this.out.write(28);
        } else if (index == 3) {
            this.out.write(29);
        } else {
            if (index >= 256) {
                this.out.write(196);
            }
            this.out.write(21);
            if (index >= 256) {
                this.out.writeShort(index);
            } else {
                this.out.write((byte)index);
            }
        }
        this.addCurrentStackDepth(1);
    }

    public void writeStoreInteger(int index) throws IOException {
        if (this.maxLocals <= index) {
            this.setMaxLocals(index + 1);
        }
        if (index == 0) {
            this.out.write(59);
        } else if (index == 1) {
            this.out.write(60);
        } else if (index == 2) {
            this.out.write(61);
        } else if (index == 3) {
            this.out.write(62);
        } else {
            if (index >= 256) {
                this.out.write(196);
            }
            this.out.write(54);
            if (index >= 256) {
                this.out.writeShort(index);
            } else {
                this.out.write((byte)index);
            }
        }
        this.decreaseStackDepth(1);
    }

    public void writeStoreFloat(int index) throws IOException {
        if (this.maxLocals <= index) {
            this.setMaxLocals(index + 1);
        }
        if (index == 0) {
            this.out.write(67);
        } else if (index == 1) {
            this.out.write(68);
        } else if (index == 2) {
            this.out.write(69);
        } else if (index == 3) {
            this.out.write(70);
        } else {
            if (index >= 256) {
                this.out.write(196);
            }
            this.out.write(56);
            if (index >= 256) {
                this.out.writeShort(index);
            } else {
                this.out.write((byte)index);
            }
        }
        this.decreaseStackDepth(1);
    }

    public void writeStoreLong(int index) throws IOException {
        if (this.maxLocals <= index + 1) {
            this.setMaxLocals(index + 2);
        }
        if (index == 0) {
            this.out.write(63);
        } else if (index == 1) {
            this.out.write(64);
        } else if (index == 2) {
            this.out.write(65);
        } else if (index == 3) {
            this.out.write(66);
        } else {
            if (index >= 256) {
                this.out.write(196);
            }
            this.out.write(55);
            if (index >= 256) {
                this.out.writeShort(index);
            } else {
                this.out.write((byte)index);
            }
        }
        this.decreaseStackDepth(2);
    }

    public void writeStoreDouble(int index) throws IOException {
        if (this.maxLocals <= index + 1) {
            this.setMaxLocals(index + 2);
        }
        if (index == 0) {
            this.out.write(71);
        } else if (index == 1) {
            this.out.write(72);
        } else if (index == 2) {
            this.out.write(73);
        } else if (index == 3) {
            this.out.write(74);
        } else {
            if (index >= 256) {
                this.out.write(196);
            }
            this.out.write(57);
            if (index >= 256) {
                this.out.writeShort(index);
            } else {
                this.out.write((byte)index);
            }
        }
        this.decreaseStackDepth(2);
    }

    public void writeLoadLong(int index) throws IOException {
        if (this.maxLocals <= index + 1) {
            this.setMaxLocals(index + 2);
        }
        if (index == 0) {
            this.out.write(30);
        } else if (index == 1) {
            this.out.write(31);
        } else if (index == 2) {
            this.out.write(32);
        } else if (index == 3) {
            this.out.write(33);
        } else {
            if (index >= 256) {
                this.out.write(196);
            }
            this.out.write(22);
            if (index >= 256) {
                this.out.writeShort(index);
            } else {
                this.out.write((byte)index);
            }
        }
        this.addCurrentStackDepth(2);
    }

    public void writeLoadDouble(int index) throws IOException {
        if (this.maxLocals <= index + 1) {
            this.setMaxLocals(index + 2);
        }
        if (index == 0) {
            this.out.write(38);
        } else if (index == 1) {
            this.out.write(39);
        } else if (index == 2) {
            this.out.write(40);
        } else if (index == 3) {
            this.out.write(41);
        } else {
            if (index >= 256) {
                this.out.write(196);
            }
            this.out.write(24);
            if (index >= 256) {
                this.out.writeShort(index);
            } else {
                this.out.write((byte)index);
            }
        }
        this.addCurrentStackDepth(2);
    }

    public void writeLoadFloat(int index) throws IOException {
        if (this.maxLocals <= index) {
            this.setMaxLocals(index);
        }
        if (index == 0) {
            this.out.write(34);
        } else if (index == 1) {
            this.out.write(35);
        } else if (index == 2) {
            this.out.write(36);
        } else if (index == 3) {
            this.out.write(37);
        } else {
            if (index >= 256) {
                this.out.write(196);
            }
            this.out.write(23);
            if (index >= 256) {
                this.out.writeShort(index);
            } else {
                this.out.write((byte)index);
            }
        }
        this.addCurrentStackDepth(1);
    }

    public void writeLoadObject(int index, Class type) throws IOException {
        if (!type.isPrimitive()) {
            this.writeLoadObject(index);
        } else {
            if (type == Integer.TYPE) {
                this.writeNew(new ByteString("java/lang/Integer"));
                this.writeDuplicate();
                this.writeLoadInteger(index);
                this.writeInvokeSpecialMethod(new ByteString("java/lang/Integer"), INIT, new ByteString("(I)V"), 1);
            } else if (type == Byte.TYPE) {
                this.writeNew(new ByteString("java/lang/Byte"));
                this.writeDuplicate();
                this.writeLoadInteger(index);
                this.write(145);
                this.writeInvokeSpecialMethod(new ByteString("java/lang/Byte"), INIT, new ByteString("(B)V"), 1);
            } else if (type == Short.TYPE) {
                this.writeNew(new ByteString("java/lang/Short"));
                this.writeDuplicate();
                this.writeLoadInteger(index);
                this.write(147);
                this.writeInvokeSpecialMethod(new ByteString("java/lang/Short"), INIT, new ByteString("(S)V"), 1);
            } else if (type == Character.TYPE) {
                this.writeNew(new ByteString("java/lang/Character"));
                this.writeDuplicate();
                this.writeLoadInteger(index);
                this.write(146);
                this.writeInvokeSpecialMethod(new ByteString("java/lang/Character"), INIT, new ByteString("(C)V"), 1);
            } else if (type == Long.TYPE) {
                this.writeNew(new ByteString("java/lang/Long"));
                this.writeDuplicate();
                this.writeLoadLong(index);
                this.writeInvokeSpecialMethod(new ByteString("java/lang/Long"), INIT, new ByteString("(J)V"), 2);
                if (this.maxLocals <= index + 1) {
                    this.setMaxLocals(index + 2);
                }
            } else if (type == Double.TYPE) {
                this.writeNew(new ByteString("java/lang/Double"));
                this.writeDuplicate();
                this.writeLoadDouble(index);
                this.writeInvokeSpecialMethod(new ByteString("java/lang/Double"), INIT, new ByteString("(D)V"), 2);
                if (this.maxLocals <= index + 1) {
                    this.setMaxLocals(index + 2);
                }
            } else if (type == Float.TYPE) {
                this.writeNew(new ByteString("java/lang/Float"));
                this.writeDuplicate();
                this.writeLoadFloat(index);
                this.writeInvokeSpecialMethod(new ByteString("java/lang/Float"), INIT, new ByteString("(F)V"), 1);
            } else if (type == Long.TYPE) {
                this.writeNew(new ByteString("java/lang/Short"));
                this.writeDuplicate();
                this.writeLoadInteger(index);
                this.write(147);
                this.writeInvokeSpecialMethod(new ByteString("java/lang/Short"), INIT, new ByteString("(S)V"), 1);
            } else if (type == Boolean.TYPE) {
                this.writeLoadInteger(index);
                this.writeIf(153, 9, false);
                this.writeGetStatic2(new ByteString("java/lang/Boolean"), new ByteString("TRUE"), new ByteString("Ljava/lang/Boolean;"), false);
                this.writeGoto(6);
                this.writeGetStatic2(new ByteString("java/lang/Boolean"), new ByteString("FALSE"), new ByteString("Ljava/lang/Boolean;"), false);
            } else {
                throw new RuntimeException("Unsupported conversion: " + type);
            }
            if (this.maxLocals <= index) {
                this.setMaxLocals(index + 1);
            }
        }
        this.addCurrentStackDepth(1);
    }

    public void writeConvertToType(Class type) throws IOException {
        if (type == Void.TYPE) {
            this.writePop();
        } else if (!type.isPrimitive()) {
            this.writeCastCheck(new ByteString(type.getName()).replace('.', '/'));
        } else if (type == Integer.TYPE) {
            this.writeCastCheck(JAVA_LANG_NUMBER);
            this.writeInvokeMethod(JAVA_LANG_NUMBER, new ByteString("intValue"), new ByteString("()I"), -1);
        } else if (type == Byte.TYPE) {
            this.writeCastCheck(JAVA_LANG_NUMBER);
            this.writeInvokeMethod(JAVA_LANG_NUMBER, new ByteString("byteValue"), new ByteString("()B"), -1);
        } else if (type == Short.TYPE) {
            this.writeCastCheck(JAVA_LANG_NUMBER);
            this.writeInvokeMethod(JAVA_LANG_NUMBER, new ByteString("shortValue"), new ByteString("()S"), -1);
        } else if (type == Character.TYPE) {
            this.writeCastCheck(new ByteString("java/lang/Character"));
            this.writeInvokeMethod(new ByteString("java/lang/Character"), new ByteString("charValue"), new ByteString("()C"), -1);
        } else if (type == Long.TYPE) {
            this.writeCastCheck(JAVA_LANG_NUMBER);
            this.writeInvokeMethod(JAVA_LANG_NUMBER, new ByteString("longValue"), new ByteString("()J"), -2);
        } else if (type == Float.TYPE) {
            this.writeCastCheck(JAVA_LANG_NUMBER);
            this.writeInvokeMethod(JAVA_LANG_NUMBER, new ByteString("floatValue"), new ByteString("()F"), -1);
        } else if (type == Double.TYPE) {
            this.writeCastCheck(JAVA_LANG_NUMBER);
            this.writeInvokeMethod(JAVA_LANG_NUMBER, new ByteString("doubleValue"), new ByteString("()D"), -2);
        } else if (type == Boolean.TYPE) {
            this.writeCastCheck(new ByteString("java/lang/Boolean"));
            this.writeInvokeMethod(new ByteString("java/lang/Boolean"), new ByteString("booleanValue"), new ByteString("()Z"), -1);
        } else {
            throw new RuntimeException("Unsupported type: " + type);
        }
    }

    public void writeLoadNull() throws IOException {
        this.out.write(1);
        this.addCurrentStackDepth(1);
    }

    public void writePop() throws IOException {
        this.out.write(87);
        this.decreaseStackDepth(1);
    }

    public void addCurrentStackDepth(int length) {
        this.currentStackDepth += length;
        if (this.currentStackDepth > this.maxStack) {
            this.maxStack = (short)this.currentStackDepth;
        }
    }

    public void decreaseStackDepth(int amount) {
        this.currentStackDepth -= amount;
        if (this.currentStackDepth < 0) {
            throw new InternalError("Stack depth was below zero (" + this.currentStackDepth + ")");
        }
    }

    public void writeDoublePop() throws IOException {
        this.out.write(88);
        this.decreaseStackDepth(2);
    }

    public void writeObjectArrayStore() throws IOException {
        this.out.write(83);
        this.currentStackDepth -= 3;
    }

    public void writeDuplicate() throws IOException {
        this.out.write(89);
        this.addCurrentStackDepth(1);
    }

    public void writeDuplicate2() throws IOException {
        this.out.write(89);
        this.addCurrentStackDepth(2);
    }

    public void writeInvokeSpecialMethod(ByteString className, ByteString methodName, ByteString args, int stackSize) throws IOException {
        short methodIndex = this.type.getMethodPoolIndex(className, methodName, args);
        this.out.write(183);
        this.out.writeShort(methodIndex);
        if (++stackSize < 0) {
            this.addCurrentStackDepth(-stackSize);
        } else {
            this.decreaseStackDepth(stackSize);
        }
    }

    public int writeGoto(int offset) throws IOException {
        this.out.write(167);
        this.out.writeShort(offset);
        return this.getPosition() - 2;
    }

    public int writeJSR(int offset) throws IOException {
        this.out.write(168);
        this.out.writeShort(offset);
        return this.getPosition() - 2;
    }

    public void writeInvokeStaticMethod(ByteString className, ByteString methodName, ByteString args, int stackSize) throws IOException {
        short methodIndex = this.type.getMethodPoolIndex(className, methodName, args);
        this.out.write(184);
        this.out.writeShort(methodIndex);
        this.currentStackDepth -= stackSize;
    }

    public void writeInvokeMethod(ByteString className, ByteString methodName, ByteString args, int stackSize) throws IOException {
        short methodIndex = this.type.getMethodPoolIndex(className, methodName, args);
        this.out.write(182);
        this.out.writeShort(methodIndex);
        if (++stackSize < 0) {
            this.addCurrentStackDepth(-stackSize);
        } else {
            this.decreaseStackDepth(stackSize);
        }
    }

    public void writeInvokeInterfaceMethod(ByteString className, ByteString methodName, ByteString args, int argsCount, int stackSize) throws IOException {
        short methodIndex = this.type.getInterfaceMethodPoolIndex(className, methodName, args);
        this.out.write(185);
        this.out.writeShort(methodIndex);
        this.out.write((byte)argsCount);
        this.out.write(0);
        this.currentStackDepth -= stackSize + 1;
    }

    public void writeCastCheck(ByteString className) throws IOException {
        short classIndex = this.type.getClassPoolIndex(className);
        this.out.write(192);
        this.out.writeShort(classIndex);
    }

    public void writeArrayGet(int type) throws IOException {
        this.out.write(type);
        if (type != 49 && type != 47) {
            this.decreaseStackDepth(1);
        }
    }

    public void writeArraySet(int type) throws IOException {
        this.out.write(type);
        if (type != 82 && type != 80) {
            this.decreaseStackDepth(3);
        } else {
            this.decreaseStackDepth(4);
        }
    }

    public void writeNew(ByteString className) throws IOException {
        short classIndex = this.type.getClassPoolIndex(className);
        this.out.write(187);
        this.out.writeShort(classIndex);
        this.addCurrentStackDepth(1);
    }

    public void writeNewMultiArray(ByteString className, int dimensions) throws IOException {
        short classIndex = this.type.getClassPoolIndex(className);
        this.out.write(197);
        this.out.writeShort(classIndex);
        this.out.write(dimensions);
        this.decreaseStackDepth(dimensions - 1);
    }

    public void writeNewArray(int type) throws IOException {
        this.out.write(188);
        this.out.write(type);
    }

    public void writeNewObjectArray(ByteString className) throws IOException {
        short classIndex = this.type.getClassPoolIndex(className);
        this.out.write(189);
        this.out.writeShort(classIndex);
    }

    public void writePutStatic2(ByteString className, ByteString fieldName, ByteString typeName, boolean doubleType) throws IOException {
        short fieldID = this.type.getFieldPoolIndex(className, fieldName, typeName);
        this.out.write(179);
        this.out.writeShort(fieldID);
        this.decreaseStackDepth(doubleType ? 2 : 1);
    }

    public void writeGetField2(ByteString className, ByteString fieldName, ByteString typeName, boolean doubleType) throws IOException {
        short fieldID = this.type.getFieldPoolIndex(className, fieldName, typeName);
        this.out.write(180);
        this.out.writeShort(fieldID);
        if (doubleType) {
            this.addCurrentStackDepth(1);
        }
    }

    public void writePutField2(ByteString className, ByteString fieldName, ByteString typeName, boolean doubleType) throws IOException {
        short fieldID = this.type.getFieldPoolIndex(className, fieldName, typeName);
        this.out.write(181);
        this.out.writeShort(fieldID);
        if (doubleType) {
            this.decreaseStackDepth(3);
        } else {
            this.decreaseStackDepth(2);
        }
    }

    public void writeGetStatic2(ByteString className, ByteString fieldName, ByteString typeName, boolean doubleType) throws IOException {
        short fieldID = this.type.getFieldPoolIndex(className, fieldName, typeName);
        this.out.write(178);
        this.out.writeShort(fieldID);
        this.addCurrentStackDepth(doubleType ? 2 : 1);
    }

    public void writeIntegerConstant(int value) throws IOException {
        this.addCurrentStackDepth(1);
        if (value <= 5 && value >= -1) {
            if (value == 0) {
                this.out.write(3);
            } else if (value == 1) {
                this.out.write(4);
            } else if (value == 2) {
                this.out.write(5);
            } else if (value == 3) {
                this.out.write(6);
            } else if (value == 4) {
                this.out.write(7);
            } else if (value == 5) {
                this.out.write(8);
            } else if (value == -1) {
                this.out.write(2);
            }
        } else if (value < 128 && value >= -128) {
            this.out.write(16);
            this.out.write(value);
        } else if (value < 32768 && value > -32767) {
            this.out.write(17);
            this.out.writeShort(value);
        } else {
            short integerID = this.type.getPoolIndex(value);
            if (integerID <= 255) {
                this.out.write(18);
                this.out.write(integerID);
            } else {
                this.out.write(19);
                this.out.writeShort(integerID);
            }
        }
    }

    public void writeLongConstant(long value) throws IOException {
        this.addCurrentStackDepth(2);
        if (value == 0L) {
            this.out.write(9);
        } else if (value == 1L) {
            this.out.write(10);
        } else {
            short integerID = this.type.getPoolIndex(value);
            this.out.write(20);
            this.out.writeShort(integerID);
        }
    }

    public void writeIntegerIncrement(short offset, int amount) throws IOException {
        if (offset > 255) {
            this.out.write(196);
        }
        this.out.write(132);
        if (offset > 255) {
            this.out.writeShort(offset);
        } else {
            this.out.write(offset);
        }
        this.out.write(amount);
    }

    public void writeShortAtPos(int pos, short value) throws IOException {
        int currentPos = this.getPosition();
        this.setPosition(pos);
        this.out.writeShort(value);
        this.setPosition(currentPos);
    }

    public void writeFloatConstant(float value) throws IOException {
        this.addCurrentStackDepth(1);
        if (value == 0.0f) {
            this.out.write(11);
        } else if (value == 1.0f) {
            this.out.write(12);
        } else if (value == 2.0f) {
            this.out.write(13);
        } else {
            short integerID = this.type.getPoolIndex(value);
            if (integerID <= 255) {
                this.out.write(18);
                this.out.write(integerID);
            } else {
                this.out.write(19);
                this.out.writeShort(integerID);
            }
        }
    }

    public void writeDoubleConstant(double value) throws IOException {
        this.addCurrentStackDepth(2);
        if (value == 0.0) {
            this.out.write(14);
        } else if (value == 1.0) {
            this.out.write(15);
        } else {
            short integerID = this.type.getPoolIndex(value);
            this.out.write(20);
            this.out.writeShort(integerID);
        }
    }

    public void writeArithmeticExpression(int code, boolean isDouble) throws IOException {
        this.out.write(code);
        this.currentStackDepth -= isDouble ? 2 : 1;
    }

    public void writeLoadString(ByteString string) throws IOException {
        this.addCurrentStackDepth(1);
        short integerID = this.type.getStringPoolIndex(string);
        if (integerID > 255) {
            this.out.write(19);
            this.out.writeShort(integerID);
        } else {
            this.out.write(18);
            this.out.write(integerID);
        }
    }

    public void write(int i) throws IOException {
        this.out.write(i);
    }

    public void write(byte[] data) throws IOException {
        this.out.write(data);
    }

    public void write(byte[] data, int offset, int length) throws IOException {
        this.out.write(data, offset, length);
    }

    public void writeReturnObject() throws IOException {
        this.out.write(176);
        this.decreaseStackDepth(1);
    }

    public void writeReturn() throws IOException {
        this.out.write(177);
    }

    public void writeReturnInteger() throws IOException {
        this.out.write(172);
        this.decreaseStackDepth(1);
    }

    public void writeReturnLong() throws IOException {
        this.out.write(173);
        this.decreaseStackDepth(2);
    }

    public void writeReturnFloat() throws IOException {
        this.out.write(174);
        this.decreaseStackDepth(1);
    }

    public void writeReturnDouble() throws IOException {
        this.out.write(175);
        this.decreaseStackDepth(2);
    }

    public void ensureMaxLocals(int minimum) {
        if (this.maxLocals < minimum) {
            this.maxLocals = minimum;
        }
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    public void setMaxStack(short maxStack) {
        this.maxStack = maxStack;
    }

    public int getPosition() {
        return this.out.getPos() - this.offset;
    }

    public void setPosition(int pos) {
        this.out.setPos(this.offset + pos);
    }

    public void setCurrentStackDepth(int currentStack) {
        this.currentStackDepth = currentStack;
    }

    public int getCurrentStackDepth() {
        return this.currentStackDepth;
    }

    public int writeIf(int code, int startoffset, boolean wide) throws IOException {
        if (wide) {
            this.out.write(196);
        }
        this.out.write(code);
        this.decreaseStackDepth(1);
        int pos = this.getPosition();
        this.out.writeShort(startoffset);
        return pos;
    }

    public void writeArrayLength() throws IOException {
        this.out.write(190);
    }

    public void writeShort(int value) throws IOException {
        this.out.writeShort(value);
    }

    public void writeMonitorEnter() throws IOException {
        this.out.write(194);
        this.decreaseStackDepth(1);
    }

    public void setMaxLocals(int max) {
        if (this.maxLocals > max) {
            throw new IllegalArgumentException("Attempted to set max locals to lower than previous value: " + max + " vs " + this.maxLocals);
        }
        this.maxLocals = (short)max;
    }

    public void writeMonitorExit() throws IOException {
        this.out.write(195);
        this.decreaseStackDepth(1);
    }

    public void writeInt(int i) throws IOException {
        this.out.writeInt(i);
    }

    public void writeInstanceOf(ByteString type) throws IOException {
        this.out.write(193);
        this.out.writeShort(this.type.getClassPoolIndex(type));
    }

    public byte[] getData() {
        return this.out.getData();
    }

    public int getRawOffset() {
        return this.offset;
    }

    public void addLineNumber(int lineNumber) {
        if (this.lineNumbers == null) {
            this.lineNumbers = new int[40];
        }
        if (this.lineNumberLength >= this.lineNumbers.length) {
            int[] newLines = new int[this.lineNumbers.length * 2];
            System.arraycopy(this.lineNumbers, 0, newLines, 0, this.lineNumberLength);
            this.lineNumbers = newLines;
        }
        this.lineNumbers[this.lineNumberLength++] = (this.out.getPos() - this.offset << 16) + (lineNumber & 0xFFFF);
    }

    public int getLastLineNumber() {
        if (this.lineNumberLength == 0) {
            return 0;
        }
        return this.lineNumbers[this.lineNumberLength - 1] & 0xFFFF;
    }

    public int getLineNumberCount() {
        return this.lineNumberLength;
    }

    public int[] getLineNumbers() {
        return this.lineNumbers;
    }
}

