/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.bytecode;

import com.evermind.bytecode.Attribute;
import com.evermind.bytecode.ClassSerialization;
import com.evermind.bytecode.FieldData;
import com.evermind.bytecode.MethodData;
import com.evermind.compiler.CompilationException;
import com.evermind.io.InteractiveByteArrayOutputStream;
import com.evermind.util.ByteString;
import java.io.IOException;

public class ClassData {
    public static final byte FLAG_DEPRECATED = 1;
    public static final byte FLAG_SYNTHETIC = 2;
    public static final int ACC_PUBLIC = 1;
    public static final int ACC_FINAL = 16;
    public static final int ACC_SUPER = 32;
    public static final int ACC_INTERFACE = 512;
    public static final int ACC_ABSTRACT = 1024;
    private static final ByteString OBJECT_NAME = new ByteString("java/lang/Object");
    public ByteString name;
    public ByteString superClassName = OBJECT_NAME;
    public short modifiers = (short)33;
    public FieldData[] fields;
    public int fieldCount;
    public MethodData[] methods;
    public int methodCount;
    public ByteString[] interfaces;
    public int interfaceCount;
    public Attribute[] attributes;
    public int attributeCount;
    public ByteString sourceFile;
    public short flags;

    public ClassData() {
    }

    public ClassData(ByteString className) {
        this.name = className;
    }

    public ClassData(ByteString className, ByteString superName) {
        this.name = className;
        this.superClassName = superName;
    }

    public void init(ByteString className, ByteString superName) {
        this.name = className;
        this.superClassName = superName;
        this.modifiers = (short)33;
        this.fieldCount = 0;
        this.methodCount = 0;
        this.attributeCount = 0;
        this.interfaceCount = 0;
        this.sourceFile = null;
    }

    public void addInterface(ByteString name) {
        if (this.interfaces == null) {
            this.interfaces = new ByteString[4];
        }
        if (this.interfaceCount >= this.interfaces.length) {
            ByteString[] newArray = new ByteString[this.interfaces.length * 2];
            System.arraycopy(this.interfaces, 0, newArray, 0, this.interfaceCount);
            this.interfaces = newArray;
        }
        this.interfaces[this.interfaceCount++] = name;
    }

    public void addField(FieldData definition) {
        if (this.fields == null) {
            this.fields = new FieldData[4];
        }
        if (this.fieldCount >= this.fields.length) {
            FieldData[] newArray = new FieldData[this.fields.length * 2];
            System.arraycopy(this.fields, 0, newArray, 0, this.fieldCount);
            this.fields = newArray;
        }
        this.fields[this.fieldCount++] = definition;
    }

    public ByteString getName() {
        return this.name;
    }

    public ByteString getBinary(ClassSerialization serialization) throws CompilationException {
        return this.getBinary(serialization, true);
    }

    public ByteString getBinary(ClassSerialization serialization, boolean init) throws CompilationException {
        try {
            InteractiveByteArrayOutputStream out = new InteractiveByteArrayOutputStream();
            if (init) {
                serialization.init(this);
            } else {
                serialization.initUTF8EntryTable();
            }
            serialization.write(out);
            return out.toByteString();
        }
        catch (IOException e) {
            throw new RuntimeException("IOException: " + e.getMessage());
        }
    }

    public void addMethod(MethodData data) {
        if (this.methods == null) {
            this.methods = new MethodData[4];
        }
        if (this.methodCount >= this.methods.length) {
            MethodData[] newArray = new MethodData[this.methods.length * 2];
            System.arraycopy(this.methods, 0, newArray, 0, this.methodCount);
            this.methods = newArray;
        }
        this.methods[this.methodCount++] = data;
    }

    public void add(Attribute attribute) {
        if (this.attributes == null) {
            this.attributes = new Attribute[4];
        }
        if (this.attributeCount >= this.attributes.length) {
            Attribute[] newAttributes = new Attribute[this.attributes.length * 2];
            System.arraycopy(this.attributes, 0, newAttributes, 0, this.attributes.length);
            this.attributes = newAttributes;
        }
        this.attributes[this.attributeCount++] = attribute;
    }

    public static void writeAttributes(ClassSerialization type, Attribute[] attributes, int attributeCount, InteractiveByteArrayOutputStream out) throws IOException, CompilationException {
        out.writeShort(attributeCount);
        for (int i = 0; i < attributeCount; ++i) {
            attributes[i].write(type, out);
        }
    }

    public String toString() {
        return String.valueOf(this.name).replace('/', '.');
    }
}

