/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util.CharConvBuilder;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.i18n.text.converter.CharacterConverter12Byte;
import oracle.i18n.util.CharConvBuilder.MappingSetter;
import oracle.sql.converter.CharacterConverters;

public class MultiByte12MapSetter
extends MappingSetter {
    static final int ENTRYWIDTH = 18;
    static final int MAXCHARVALUE = 65535;
    int m_ucsReplacement;
    Vector mapStore;
    CharacterConverter12Byte m_charConv;

    MultiByte12MapSetter(CharacterConverters characterConverters, CharacterConverter12Byte characterConverter12Byte, int n, int n2) throws IOException {
        super(n);
        this.m_ucsReplacement = n2;
        this.mapStore = new Vector();
        this.m_charConv = characterConverter12Byte;
        if (characterConverters != null) {
            Vector vector = new Vector(65535, 28671);
            characterConverters.extractCodepoints(vector);
            for (int i = 0; i < vector.size(); ++i) {
                int[] nArray = (int[])vector.elementAt(i);
                this.set(nArray[0], nArray[1]);
            }
        }
    }

    MultiByte12MapSetter(int n, int n2, int n3) {
        super(n);
        this.mapStore = new Vector();
    }

    boolean set(int n, int n2) throws IOException {
        if (n > 65535) {
            this.printErrorMsg("***** Error: source code point " + MultiByte12MapSetter.intToHex8(n) + " is too big for 1-2 byte converter");
            return false;
        }
        n2 = (int)MultiByte12MapSetter.convertUTF32toUTF16((long)n2 & 0xFFFFFFFFL);
        int[] nArray = new int[]{n, n2};
        this.mapStore.addElement(nArray);
        return true;
    }

    void finish() {
        this.buildMapping();
    }

    void buildMapping() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int[] nArray;
        int n6;
        int n7 = 8;
        int n8 = 8;
        int n9 = (1 << n7) - 1;
        int n10 = (1 << n8) - 1;
        int n11 = 1 << n7;
        char[] cArray = new char[n11];
        char[][] cArray2 = new char[n11][2];
        for (n6 = 0; n6 < n11; ++n6) {
            cArray[n6] = 65535;
            cArray2[n6][0] = (char)n10;
            cArray2[n6][1] = '\u0000';
        }
        int n12 = this.mapStore.size();
        Hashtable<Integer, Integer> hashtable = new Hashtable<Integer, Integer>();
        Hashtable hashtable2 = new Hashtable();
        for (n6 = 0; n6 < n12; ++n6) {
            nArray = (int[])this.mapStore.elementAt(n6);
            n5 = nArray[1];
            if (n5 == -1) continue;
            n4 = nArray[0];
            if (hashtable.get(new Integer(n5)) == null) {
                hashtable.put(new Integer(n5), new Integer(n4));
            } else {
                hashtable2.put(new Integer(n5), hashtable.get(new Integer(n5)));
            }
            n3 = n4 >> n8 & n9;
            cArray[n3] = '\u0001';
            n2 = n4 & n10;
            if (n2 < cArray2[n3][0]) {
                cArray2[n3][0] = (char)n2;
            }
            if (n2 <= cArray2[n3][1]) continue;
            cArray2[n3][1] = (char)n2;
        }
        int n13 = n = n10 + 1;
        int n14 = 0;
        for (n6 = 0; n6 < n11; ++n6) {
            if (cArray[n6] == '\uffff') continue;
            int n15 = cArray2[n6][0];
            cArray[n6] = (char)(n13 - (n14 < n15 ? n14 : n15));
            n13 = cArray[n6] + n;
            n14 = n - cArray2[n6][1] - 1;
        }
        int[] nArray2 = new int[n13];
        for (n6 = 0; n6 < n13; ++n6) {
            nArray2[n6] = -1;
        }
        n12 = this.mapStore.size();
        for (n6 = 0; n6 < n12; ++n6) {
            nArray = (int[])this.mapStore.elementAt(n6);
            n5 = nArray[1];
            if (n5 == -1) continue;
            n4 = nArray[0];
            n3 = n4 >> n8 & n9;
            n2 = n4 & n10;
            int n16 = cArray[n3] + n2;
            nArray2[n16] = n5;
        }
        this.setArray2(nArray2);
        this.setArray(cArray);
        this.setDuplicateMapping(hashtable2);
    }

    void setArray2(int[] nArray) {
        int n = nArray.length;
        this.m_charConv.m_ucsCharLevel2 = new int[n];
        for (int i = 0; i < n; ++i) {
            this.m_charConv.m_ucsCharLevel2[i] = nArray[i];
        }
    }

    void setArray(char[] cArray) {
        int n = cArray.length;
        this.m_charConv.m_ucsCharLevel1 = new char[n];
        for (int i = 0; i < n; ++i) {
            this.m_charConv.m_ucsCharLevel1[i] = cArray[i];
        }
    }

    void setDuplicateMapping(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        this.m_charConv.extraUnicodeToOracleMapping = new int[hashtable.size()][2];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            this.m_charConv.extraUnicodeToOracleMapping[n][0] = (Integer)k;
            this.m_charConv.extraUnicodeToOracleMapping[n++][1] = (Integer)hashtable.get(k);
        }
    }
}

