/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.servlet.taglib.rt;

import java.text.ParseException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import oracle.i18n.servlet.localesource.LocaleSource;
import oracle.i18n.servlet.taglib.rt.TagUtility;
import oracle.i18n.text.OraDecimalFormat;
import oracle.i18n.text.OraNumberFormat;
import oracle.i18n.util.GDKMessage;

public class ParseNumberTag
extends BodyTagSupport {
    private String m_value = null;
    private String m_type = "";
    private String m_pattern = null;
    private String m_var = null;
    private int m_scope = -1;

    public void setValue(String string) {
        this.m_value = string;
    }

    public void setType(String string) {
        this.m_type = string;
    }

    public void setPattern(String string) {
        this.m_pattern = string;
    }

    public void setVar(String string) {
        this.m_var = string;
    }

    public void setScope(String string) {
        this.m_scope = TagUtility.getScope(string);
    }

    public int doStartTag() throws JspException {
        if (this.m_scope != -1 && this.m_var == null) {
            throw new JspException(GDKMessage.getMessage(5216));
        }
        if (this.m_value != null) {
            if (!this.m_value.equals("")) {
                try {
                    TagUtility.output(this.m_var, this.m_scope, this.pageContext, this.getNumberFormat().parse(this.m_value));
                }
                catch (ParseException parseException) {
                    throw new JspException(parseException.getMessage());
                }
            } else {
                TagUtility.removeValue(this.m_var, this.m_scope, this.pageContext);
            }
            return 0;
        }
        return 2;
    }

    public int doAfterBody() throws JspException {
        this.m_value = this.getBodyContent().getString();
        if (this.m_value != null && !this.m_value.equals("")) {
            try {
                TagUtility.output(this.m_var, this.m_scope, this.pageContext, this.getNumberFormat().parse(this.m_value));
            }
            catch (ParseException parseException) {
                throw new JspException(parseException.getMessage());
            }
        } else {
            TagUtility.removeValue(this.m_var, this.m_scope, this.pageContext);
        }
        return 0;
    }

    private OraNumberFormat getNumberFormat() throws JspException {
        LocaleSource localeSource = (LocaleSource)this.pageContext.findAttribute("oracle.i18n.servlet.localesource.LocaleSource.sessionkey");
        try {
            if (this.m_pattern != null && !this.m_pattern.equals("")) {
                return new OraDecimalFormat(this.m_pattern);
            }
            if (this.m_type.equals("currency")) {
                return localeSource.getCurrencyFormat();
            }
            return localeSource.getNumberFormat();
        }
        catch (ParseException parseException) {
            throw new JspException(parseException.getMessage());
        }
    }
}

