/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.controls;

import com.sun.media.Reparentable;
import com.sun.media.ui.TextComp;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.media.control.FrameRateControl;

public class FrameRateAdapter
implements FrameRateControl,
ActionListener,
Reparentable {
    protected float value = 0.0f;
    protected float min = 0.0f;
    protected float max = 0.0f;
    protected TextComp textComp = null;
    protected boolean settable;
    protected Object owner = null;

    public FrameRateAdapter(float f2, float f3, float f4, boolean bl) {
        this.value = f2;
        this.min = f3;
        this.max = f4;
        this.settable = bl;
    }

    public FrameRateAdapter(Object object, float f2, float f3, float f4, boolean bl) {
        this(f2, f3, f4, bl);
        this.owner = object;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        System.out.println("fra:");
        float f2 = this.textComp.getFloatValue();
        this.setFrameRate(f2);
    }

    public Component getControlComponent() {
        if (this.textComp == null) {
            this.textComp = new TextComp(this.getName(), String.valueOf(this.value), 2, this.settable);
            this.textComp.setActionListener(this);
        }
        return this.textComp;
    }

    public float getFrameRate() {
        return this.value;
    }

    public float getMaxSupportedFrameRate() {
        return this.max;
    }

    protected String getName() {
        return "Frame Rate";
    }

    public Object getOwner() {
        if (this.owner == null) {
            return this;
        }
        return this.owner;
    }

    public float getPreferredFrameRate() {
        return this.min;
    }

    public void setEnabled(boolean bl) {
        if (this.textComp != null) {
            this.textComp.setEnabled(bl);
        }
    }

    public float setFrameRate(float f2) {
        if (this.settable) {
            if (f2 < this.min) {
                f2 = this.min;
            } else if (f2 > this.max) {
                f2 = this.max;
            }
            this.value = f2;
            if (this.textComp != null) {
                this.textComp.setValue(Float.toString(this.value));
            }
            return this.value;
        }
        return -1.0f;
    }

    public void setOwner(Object object) {
        this.owner = object;
    }
}

