/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.model.generic.toplink;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.adf.model.BindingContext;
import oracle.adf.model.OperationBinding;
import oracle.adf.model.binding.DCDataControl;
import oracle.adf.model.binding.DCInvokeMethod;
import oracle.adf.model.binding.DCIteratorBinding;
import oracle.adf.model.binding.DCUtil;
import oracle.adf.model.generic.DCGenericDataControl;
import oracle.adf.model.generic.DCRowContext;
import oracle.adf.model.generic.DCRowSetIteratorImpl;
import oracle.adf.model.generic.StructureDefImpl;
import oracle.adf.model.generic.toplink.TransactionBroker;
import oracle.jbo.JboException;
import oracle.jbo.common.JBOClass;
import oracle.toplink.sessions.Session;
import oracle.toplink.sessions.UnitOfWork;

public class TopLinkDataControl
extends DCGenericDataControl {
    public static final String DOT_STR = ".";
    public static final String QUERY_SPEL_IDENTIFIER = "query";
    public static final String READ_ALL_QUERY_SPEL_IDENTIFIER = "query.all";
    private TransactionBroker transactionBroker;
    private Class beanClass;
    private String beanClassName;
    private boolean sequenceOnCreate;

    public TopLinkDataControl(String string, Map map, String string2, boolean bl, TransactionBroker transactionBroker) {
        super(string, string2, null, bl);
        this.initialize(map, string2, transactionBroker);
    }

    protected void initialize(Map map, String string, TransactionBroker transactionBroker) {
        this.sequenceOnCreate = Boolean.valueOf((String)map.get("TopLinkSequenceOnCreate"));
        this.beanClassName = string;
        this.transactionBroker = transactionBroker;
    }

    public boolean isOperationSupported(DCIteratorBinding dCIteratorBinding, byte by) {
        switch (by) {
            case 0: 
            case 1: 
            case 2: 
            case 5: {
                return true;
            }
        }
        return super.isOperationSupported(dCIteratorBinding, by);
    }

    public Object invokeMethod(DCInvokeMethod dCInvokeMethod, OperationBinding operationBinding, Map map) {
        if (this.isFindAllQuery(dCInvokeMethod) || this.isFindQuery(dCInvokeMethod)) {
            return this.executeQuery(dCInvokeMethod, map);
        }
        return super.invokeMethod(dCInvokeMethod, operationBinding, map);
    }

    public boolean removeRowData(DCRowContext dCRowContext) {
        DCRowSetIteratorImpl dCRowSetIteratorImpl;
        this.setTransactionModified();
        DCRowSetIteratorImpl dCRowSetIteratorImpl2 = dCRowSetIteratorImpl = dCRowContext.getRowSetIterator() instanceof DCRowSetIteratorImpl ? (DCRowSetIteratorImpl)dCRowContext.getRowSetIterator() : null;
        if (dCRowSetIteratorImpl != null) {
            Object object = dCRowSetIteratorImpl.getDataProvider();
            Object object2 = dCRowContext.getRowDataProvider();
            if (object != null && object2 != null) {
                if (object instanceof Collection) {
                    ((Collection)object).remove(object2);
                } else if (object instanceof Iterator) {
                    ((Iterator)object).remove();
                }
            }
            Object object3 = this.getTransactionBroker().deleteObject(object2);
            dCRowSetIteratorImpl.rebuildIteratorUpto(dCRowSetIteratorImpl.getCurrentRowIndex());
            return true;
        }
        return false;
    }

    public Object createRowData(DCRowContext dCRowContext) {
        this.setTransactionModified();
        String string = ((StructureDefImpl)dCRowContext.getStructureDef()).getBeanClassName();
        try {
            DCRowSetIteratorImpl dCRowSetIteratorImpl;
            Object object = this.getTransactionBroker().createNewInstance(JBOClass.forName((String)string), this.sequenceOnCreate);
            DCRowSetIteratorImpl dCRowSetIteratorImpl2 = dCRowSetIteratorImpl = dCRowContext.getRowSetIterator() instanceof DCRowSetIteratorImpl ? (DCRowSetIteratorImpl)dCRowContext.getRowSetIterator() : null;
            if (dCRowSetIteratorImpl != null) {
                Object object2 = dCRowSetIteratorImpl.getDataProvider();
                if (object2 != null) {
                    if (object2 instanceof List) {
                        int n = dCRowSetIteratorImpl.getCurrentRowIndex();
                        n = n == -1 ? 0 : n;
                        ((List)object2).add(n, object);
                    } else if (object2 instanceof Collection) {
                        ((Collection)object2).add(object);
                    }
                }
                dCRowSetIteratorImpl.rebuildIteratorUpto(dCRowSetIteratorImpl.getCurrentRowIndex());
            }
            Object object3 = object;
            return object3;
        }
        catch (JboException jboException) {
            throw jboException;
        }
        catch (Exception exception) {
            throw new JboException((Throwable)exception);
        }
    }

    public void release(int n) {
        super.release(n);
        if ((n & DCDataControl.REL_DATA_REFS) > 0 && this.getTransactionBroker().isDataControlRegistered(this)) {
            this.getTransactionBroker().release(this);
        }
    }

    public void commitTransaction() {
        this.getTransactionBroker().commitTransaction();
    }

    public void rollbackTransaction() {
        this.getTransactionBroker().rollbackTransaction();
    }

    public boolean resetState() {
        boolean bl = super.resetState();
        if (bl) {
            this.getTransactionBroker().resetState();
        }
        return bl;
    }

    private Object executeQuery(DCInvokeMethod dCInvokeMethod, Map map) {
        String string = dCInvokeMethod.getMethodName();
        Object object = null;
        if (this.isFindAllQuery(dCInvokeMethod)) {
            object = this.getTransactionBroker().executeReadAllQuery(this.getBeanClass());
        } else {
            Object[] objectArray = dCInvokeMethod.fetchParameterValues(this.getBindingContext(), map);
            Vector<Object> vector = new Vector<Object>(Arrays.asList(objectArray));
            object = this.getTransactionBroker().executeQuery(this.getBeanClass(), string, vector);
        }
        String string2 = dCInvokeMethod.getReturnName();
        if (string2 != null) {
            DCUtil.putValueInPath((BindingContext)this.getBindingContext(), (String)string2, (Object)object);
        }
        return object;
    }

    private boolean isFindAllQuery(DCInvokeMethod dCInvokeMethod) {
        return dCInvokeMethod.getInstanceName().endsWith(READ_ALL_QUERY_SPEL_IDENTIFIER);
    }

    private boolean isFindQuery(DCInvokeMethod dCInvokeMethod) {
        return dCInvokeMethod.getInstanceName().endsWith(QUERY_SPEL_IDENTIFIER);
    }

    private Class getBeanClass() {
        if (this.beanClass == null) {
            try {
                this.beanClass = JBOClass.forName((String)this.beanClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JboException((Throwable)classNotFoundException);
            }
        }
        return this.beanClass;
    }

    protected void commitPerformed() {
        this.resetTransactionalState();
    }

    protected void rollbackPerformed() {
        this.transactionalResourcesReset();
    }

    protected void resetStatePerformed() {
        this.resetTransactionalState();
        this.closeRowSetIterators(true);
        this.getMethodResults().clear();
    }

    protected void transactionalResourcesReset() {
        this.resetTransactionalState();
        this.restoreRSIs();
    }

    protected void resetTransactionalState() {
        this.transactionStateChanged(false);
    }

    public void resetTransaction() {
        this.getTransactionBroker().resetTransactionalResources();
    }

    protected TransactionBroker getTransactionBroker() {
        return this.transactionBroker;
    }

    public UnitOfWork getAssociatedUnitOfWork() {
        return this.getTransactionBroker().getUnitOfWork();
    }

    public Session getAssociatedSession() {
        return this.getTransactionBroker().getSession();
    }
}

