/*
 * Decompiled with CFR 0.152.
 */
package oracle.ord.im;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.ord.im.OrdAudio;
import oracle.ord.im.OrdDoc;
import oracle.ord.im.OrdHttpMessage;
import oracle.ord.im.OrdHttpResponseException;
import oracle.ord.im.OrdImage;
import oracle.ord.im.OrdVideo;
import oracle.sql.BFILE;
import oracle.sql.BLOB;

public class OrdHttpResponseHandler {
    public static final int DEFAULT_BUFFER_SIZE = 32768;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private int bufferSize;
    private boolean multiBuffering;
    private Object mediaObject;
    private String responseContentType;
    private boolean doEncode = false;
    private String encoderCharSet = "!\"%&'();<>";
    private String encoderEncoding = "ISO-8859-1";
    private static final String HTTP_IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final String HTTP_LAST_MODIFIED = "Last-Modified";
    private static final String SOURCE_TYPE_FILE = "FILE";
    private static final String SOURCE_TYPE_HTTP = "HTTP";
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";

    public OrdHttpResponseHandler() {
        this(null, null);
    }

    public OrdHttpResponseHandler(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.request = httpServletRequest;
        this.response = httpServletResponse;
        this.bufferSize = 32768;
        this.multiBuffering = false;
    }

    private boolean cacheIsUpToDate(Timestamp timestamp) throws OrdHttpResponseException {
        if (this.request == null) {
            throw new IllegalStateException(OrdHttpMessage.getMessage(1));
        }
        long l = this.request.getDateHeader(HTTP_IF_MODIFIED_SINCE);
        if (l != -1L && l >= ((Date)timestamp).getTime()) {
            this.response.setStatus(304);
            return true;
        }
        this.response.setDateHeader(HTTP_LAST_MODIFIED, ((Date)timestamp).getTime());
        return false;
    }

    private byte[] encodeHtml(byte[] byArray, int n, int n2, String string, String string2) throws IOException {
        String string3 = new String(byArray, n, n2, string2);
        StringBuffer stringBuffer = new StringBuffer(string3);
        int n3 = 0;
        while (n3 < stringBuffer.length()) {
            char c = stringBuffer.charAt(n3);
            if (string.indexOf(c) >= 0) {
                switch (c) {
                    case '!': {
                        stringBuffer.replace(n3, n3 + 1, "&#33;");
                        break;
                    }
                    case '\"': {
                        stringBuffer.replace(n3, n3 + 1, "&#34;");
                        break;
                    }
                    case '%': {
                        stringBuffer.replace(n3, n3 + 1, "&#37;");
                        break;
                    }
                    case '&': {
                        stringBuffer.replace(n3, n3 + 1, "&#38;");
                        break;
                    }
                    case '\'': {
                        stringBuffer.replace(n3, n3 + 1, "&#39;");
                        break;
                    }
                    case '(': {
                        stringBuffer.replace(n3, n3 + 1, "&#40;");
                        break;
                    }
                    case ')': {
                        stringBuffer.replace(n3, n3 + 1, "&#41;");
                        break;
                    }
                    case ';': {
                        stringBuffer.replace(n3, n3 + 1, "&#59;");
                        break;
                    }
                    case '<': {
                        stringBuffer.replace(n3, n3 + 1, "&#60;");
                        break;
                    }
                    case '>': {
                        stringBuffer.replace(n3, n3 + 1, "&#62;");
                        break;
                    }
                    default: {
                        stringBuffer.deleteCharAt(n3);
                        n3 -= 5;
                    }
                }
                n3 += 5;
                continue;
            }
            ++n3;
        }
        byte[] byArray2 = stringBuffer.toString().getBytes(string2);
        return byArray2;
    }

    public void sendAudio(OrdAudio ordAudio) throws ServletException, SQLException, IOException {
        if (ordAudio == null) {
            throw new NullPointerException(OrdHttpMessage.getMessage(9));
        }
        if (ordAudio.conn == null) {
            throw new OrdHttpResponseException(10);
        }
        if (ordAudio.isLocal()) {
            this.sendResponse(ordAudio.getMimeType(), 0, ordAudio.getContentReadOnly(), ordAudio.getUpdateTime());
        } else {
            String string = ordAudio.getSourceType();
            if (string.equalsIgnoreCase(SOURCE_TYPE_FILE)) {
                this.sendResponse(ordAudio.getMimeType(), 0, ordAudio.getBFILE(), ordAudio.getUpdateTime());
            } else if (string.equalsIgnoreCase(SOURCE_TYPE_HTTP)) {
                this.response.sendRedirect("http://" + ordAudio.getSourceLocation() + "/" + ordAudio.getSourceName());
            } else {
                throw new OrdHttpResponseException(4, string);
            }
        }
    }

    public void sendDoc(OrdDoc ordDoc) throws ServletException, SQLException, IOException {
        if (ordDoc == null) {
            throw new NullPointerException(OrdHttpMessage.getMessage(9));
        }
        if (ordDoc.conn == null) {
            throw new OrdHttpResponseException(10);
        }
        if (ordDoc.isLocal()) {
            this.sendResponse(ordDoc.getMimeType(), ordDoc.getContentLength(), ordDoc.getContentReadOnly(), ordDoc.getUpdateTime());
        } else {
            String string = ordDoc.getSourceType();
            if (string.equalsIgnoreCase(SOURCE_TYPE_FILE)) {
                this.sendResponse(ordDoc.getMimeType(), ordDoc.getContentLength(), ordDoc.getBFILE(), ordDoc.getUpdateTime());
            } else if (string.equalsIgnoreCase(SOURCE_TYPE_HTTP)) {
                this.response.sendRedirect("http://" + ordDoc.getSourceLocation() + "/" + ordDoc.getSourceName());
            } else {
                throw new OrdHttpResponseException(4, string);
            }
        }
    }

    public void sendImage(OrdImage ordImage) throws ServletException, SQLException, IOException {
        if (ordImage == null) {
            throw new NullPointerException(OrdHttpMessage.getMessage(9));
        }
        if (ordImage.conn == null) {
            throw new OrdHttpResponseException(10);
        }
        if (ordImage.isLocal()) {
            this.sendResponse(ordImage.getMimeType(), ordImage.getContentLength(), ordImage.getContentReadOnly(), ordImage.getUpdateTime());
        } else {
            String string = ordImage.getSourceType();
            if (string.equalsIgnoreCase(SOURCE_TYPE_FILE)) {
                this.sendResponse(ordImage.getMimeType(), ordImage.getContentLength(), ordImage.getBFILE(), ordImage.getUpdateTime());
            } else if (string.equalsIgnoreCase(SOURCE_TYPE_HTTP)) {
                this.response.sendRedirect("http://" + ordImage.getSourceLocation() + "/" + ordImage.getSourceName());
            } else {
                throw new OrdHttpResponseException(4, string);
            }
        }
    }

    public void sendResponse() throws ServletException, SQLException, IOException {
        if (this.mediaObject == null) {
            throw new NullPointerException(OrdHttpMessage.getMessage(9));
        }
        if (this.mediaObject instanceof OrdImage) {
            this.sendImage((OrdImage)this.mediaObject);
        } else if (this.mediaObject instanceof OrdAudio) {
            this.sendAudio((OrdAudio)this.mediaObject);
        } else if (this.mediaObject instanceof OrdVideo) {
            this.sendVideo((OrdVideo)this.mediaObject);
        } else if (this.mediaObject instanceof OrdDoc) {
            this.sendDoc((OrdDoc)this.mediaObject);
        }
    }

    public void sendResponse(String string, int n, InputStream inputStream, Timestamp timestamp) throws ServletException, IOException {
        if (inputStream == null) {
            throw new NullPointerException(OrdHttpMessage.getMessage(13));
        }
        if (this.response == null) {
            throw new IllegalStateException(OrdHttpMessage.getMessage(2));
        }
        if (timestamp != null && this.cacheIsUpToDate(timestamp)) {
            return;
        }
        this.setTypeLengthHeaders(string, n);
        this.sendResponseBody(n, inputStream);
    }

    public void sendResponse(String string, int n, BFILE bFILE, Timestamp timestamp) throws ServletException, SQLException, IOException {
        if (bFILE == null) {
            throw new NullPointerException(OrdHttpMessage.getMessage(12));
        }
        if (this.response == null) {
            throw new IllegalStateException(OrdHttpMessage.getMessage(2));
        }
        if (timestamp != null && this.cacheIsUpToDate(timestamp)) {
            return;
        }
        if (n == 0) {
            n = (int)bFILE.length();
        }
        this.setTypeLengthHeaders(string, n);
        this.sendResponseBody(n, bFILE);
    }

    public void sendResponse(String string, int n, BLOB bLOB, Timestamp timestamp) throws ServletException, SQLException, IOException {
        if (bLOB == null) {
            throw new NullPointerException(OrdHttpMessage.getMessage(11));
        }
        if (this.response == null) {
            throw new IllegalStateException(OrdHttpMessage.getMessage(2));
        }
        if (timestamp != null && this.cacheIsUpToDate(timestamp)) {
            return;
        }
        if (n == 0) {
            n = (int)bLOB.length();
        }
        this.setTypeLengthHeaders(string, n);
        this.sendResponseBody(n, bLOB);
    }

    /*
     * Exception decompiling
     */
    public void sendResponseBody(int var1_1, InputStream var2_2) throws ServletException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[DOLOOP]], but top level block is 10[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void sendResponseBody(int n, BFILE bFILE) throws ServletException, SQLException, IOException {
        if (bFILE == null) {
            throw new NullPointerException(OrdHttpMessage.getMessage(12));
        }
        if (this.response == null) {
            throw new IllegalStateException(OrdHttpMessage.getMessage(2));
        }
        bFILE.openFile();
        try {
            this.sendResponseBody(n, bFILE.getBinaryStream());
        }
        finally {
            Object var4_3 = null;
            bFILE.closeFile();
        }
    }

    public void sendResponseBody(int n, BLOB bLOB) throws ServletException, SQLException, IOException {
        if (bLOB == null) {
            throw new NullPointerException(OrdHttpMessage.getMessage(11));
        }
        if (this.response == null) {
            throw new IllegalStateException(OrdHttpMessage.getMessage(2));
        }
        this.sendResponseBody(n, bLOB.getBinaryStream());
    }

    public void sendVideo(OrdVideo ordVideo) throws ServletException, SQLException, IOException {
        if (ordVideo == null) {
            throw new NullPointerException(OrdHttpMessage.getMessage(9));
        }
        if (ordVideo.conn == null) {
            throw new OrdHttpResponseException(10);
        }
        if (ordVideo.isLocal()) {
            this.sendResponse(ordVideo.getMimeType(), 0, ordVideo.getContentReadOnly(), ordVideo.getUpdateTime());
        } else {
            String string = ordVideo.getSourceType();
            if (string.equalsIgnoreCase(SOURCE_TYPE_FILE)) {
                this.sendResponse(ordVideo.getMimeType(), 0, ordVideo.getBFILE(), ordVideo.getUpdateTime());
            } else if (string.equalsIgnoreCase(SOURCE_TYPE_HTTP)) {
                this.response.sendRedirect("http://" + ordVideo.getSourceLocation() + "/" + ordVideo.getSourceName());
            } else {
                throw new OrdHttpResponseException(4, string);
            }
        }
    }

    public void setBufferSize(int n) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.bufferSize = n;
    }

    public void setEncodeHtml(boolean bl) {
        this.doEncode = bl;
    }

    public void setEncoderCharSet(String string, String string2) {
        if (string != null) {
            this.encoderCharSet = string;
        }
        if (string2 != null) {
            this.encoderEncoding = string2;
        }
    }

    public void setHeader(String string, int n) {
        this.response.setIntHeader(string, n);
    }

    public void setHeader(String string, long l) {
        this.response.setDateHeader(string, l);
    }

    public void setHeader(String string, String string2) {
        this.response.setHeader(string, string2);
    }

    public void setMedia(OrdAudio ordAudio) {
        this.mediaObject = ordAudio;
    }

    public void setMedia(OrdDoc ordDoc) {
        this.mediaObject = ordDoc;
    }

    public void setMedia(OrdImage ordImage) {
        this.mediaObject = ordImage;
    }

    public void setMedia(OrdVideo ordVideo) {
        this.mediaObject = ordVideo;
    }

    public void setServletRequest(HttpServletRequest httpServletRequest) {
        this.request = httpServletRequest;
    }

    public void setServletResponse(HttpServletResponse httpServletResponse) {
        this.response = httpServletResponse;
    }

    private void setTypeLengthHeaders(String string, int n) {
        if (string == null || string.length() == 0) {
            string = APPLICATION_OCTET_STREAM;
        }
        this.responseContentType = string;
        this.response.setContentType(string);
        if (!(n <= 0 || this.doEncode && string.trim().startsWith("text/html"))) {
            this.response.setContentLength(n);
        } else if (n < 0) {
            throw new IllegalArgumentException();
        }
    }
}

