/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common.ws;

import com.sun.java.util.collections.ArrayList;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import oracle.jbo.ApplicationModule;
import oracle.jbo.Key;
import oracle.jbo.NoObjException;
import oracle.jbo.Row;
import oracle.jbo.RowSet;
import oracle.jbo.RowSetIterator;
import oracle.jbo.common.SvcMsgIteratorState;
import oracle.jbo.common.SvcMsgResponseValues;
import oracle.jbo.common.ws.WSApplicationModuleImpl;
import oracle.jbo.common.ws.WSObject;
import oracle.jbo.common.ws.WSRowSetImpl;
import oracle.jbo.common.ws.WSRowSetIteratorBase;
import oracle.jbo.common.ws.WSRowSetIteratorMarshaller;
import oracle.jbo.common.ws.WSViewObjectImpl;

public class WSRowSetIteratorImpl
extends WSRowSetIteratorBase
implements Serializable,
RowSetIterator {
    private boolean mIsDefault;
    private Object[] mRowFilterValues;
    private SvcMsgIteratorState mIteratorState;
    private Key mCurrentRowKey;
    private ArrayList mDetailRowSets;
    private ArrayList mDetailLinkDefNames;
    private int mRangeSize;
    private int mRangeStart;
    private boolean mRowValidation;
    private int mIterMode;
    private static final int CHANGE_RSI_RANGE_SIZE = 0;
    private static final int CHANGE_RSI_RANGE_START = 1;
    private static final int CHANGE_RSI_ROW_VALIDATION = 2;
    private static final int CHANGE_RSI_ITER_MODE = 3;
    private static final int CHANGE_RSI_END = 4;
    private transient int mReqObjStat;
    private transient int mActivationMode;
    private transient RowSetIterator mRSI;
    private transient WSRowSetImpl mParent;
    private transient HashMap mDataModelMasterRows;

    private /* synthetic */ void $init$() {
        this.mDetailRowSets = new ArrayList(4);
        this.mDetailLinkDefNames = new ArrayList(4);
        this.mRangeSize = 1;
        this.mRangeStart = -1;
        this.mRowValidation = true;
        this.mIterMode = 0;
        this.mActivationMode = 0;
        this.mRSI = null;
        this.mParent = null;
        this.mDataModelMasterRows = null;
    }

    WSRowSetIteratorImpl(String string, int n, boolean bl, WSRowSetImpl wSRowSetImpl) {
        super(string);
        this.$init$();
        this.mIsDefault = bl;
        this.mParent = wSRowSetImpl;
        this.mId = wSRowSetImpl.registerObject(this);
        this.mReqObjStat = n;
        this.mObjStat = n == 0 ? n : (this.isClient() ? 3 : n);
        this.afterCreate();
    }

    int getNumChangeFlags() {
        return 4;
    }

    public boolean isOnLine() {
        return this.mParent.isOnLine();
    }

    public WSObject getParent() {
        return this.mParent;
    }

    RowSetIterator getRowSetIterator() {
        return this.getRowSetIteratorImpl();
    }

    public RowSetIterator getRowSetIteratorImpl() {
        RowSet rowSet;
        if (this.mRSI == null && this.mObjStat == 3 && this.mParent != null && this.isClient() && (rowSet = this.mParent.getRowSetImpl()) != null) {
            this.mRSI = rowSet.findRowSetIterator(this.mName);
            this.mObjStat = this.mRSI != null ? 4 : this.mReqObjStat;
        }
        return this.mRSI;
    }

    void setRowSetIteratorImpl(RowSetIterator rowSetIterator) {
        this.mRSI = rowSetIterator;
        this.registerWSListeners();
        ((WSApplicationModuleImpl)this.mParent.getApplicationModule()).registerImplToWSObject(this.mRSI, this);
    }

    public Object getImplObject() {
        return this.getRowSetIteratorImpl();
    }

    public void setImplObject(Object object) {
        this.setRowSetIteratorImpl((RowSetIterator)object);
    }

    int getBatchCommMode() {
        return ((WSApplicationModuleImpl)this.getApplicationModule()).getBatchCommMode();
    }

    public void markForError(Exception exception, boolean bl) {
        if (!bl) {
            this.mObjStat = -1;
            this.mParent.removeRowSetIterator(this);
            this.mParent = null;
        }
    }

    public ApplicationModule getApplicationModule() {
        return this.mParent.getApplicationModule();
    }

    boolean isDefault() {
        return this.mIsDefault;
    }

    boolean needsRefresh() {
        if (this.mParent.willRefresh()) {
            return false;
        }
        return this.getChangeFlag(0) || this.getChangeFlag(1) || this.getChangeFlag(3);
    }

    void beforeSend(List list) {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            Row row;
            this.mRowFilterValues = ((WSRowSetIteratorMarshaller)((Object)rowSetIterator)).getRowFilterValues();
            this.mIteratorState = ((WSRowSetIteratorMarshaller)((Object)rowSetIterator)).getCliIteratorState();
            if (this.mActivationMode != 0 && (row = rowSetIterator.getCurrentRow()) != null) {
                this.mCurrentRowKey = row.getKey();
            }
            if (this.getChangeFlag(0)) {
                rowSetIterator.setRangeSize(this.mRangeSize);
                this.mIteratorState.setRangeSize(this.mRangeSize);
            }
        }
        if (this.mObjStat == 3 || this.mObjStat == 4) {
            this.mObjStat = this.mReqObjStat;
        }
        this.getVariableOpers();
    }

    void afterSend() {
        this.resetVariableOpers();
        if (this.mObjStat == 100) {
            this.mParent.removeRowSetIterator(this);
            return;
        }
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            this.mRangeStart = rowSetIterator.getRangeStart();
        }
        this.mObjStat = 5;
        this.mDetailRowSets.clear();
        this.mDetailLinkDefNames.clear();
        this.mRowFilterValues = null;
        this.mIteratorState = null;
        this.mCurrentRowKey = null;
        this.mActivationMode = 0;
        this.clearChangeFlags();
    }

    void afterActivation(int n) {
        this.mActivationMode = n;
    }

    void doInit() {
        if (this.mObjStat == -1) {
            return;
        }
        try {
            RowSetIterator rowSetIterator;
            RowSet rowSet = this.mParent.getRowSetImpl();
            if (this.mIsDefault) {
                rowSetIterator = rowSet;
            } else if (this.mObjStat == 0) {
                rowSetIterator = rowSet.createRowSetIterator(this.getName());
            } else if (this.mObjStat == 1) {
                rowSetIterator = rowSet.findRowSetIterator(this.getName());
                if (rowSetIterator == null) {
                    throw new NoObjException(113, this.getName());
                }
                if (this.mObjStat == 100) {
                    rowSetIterator.closeRowSetIterator();
                    return;
                }
            } else {
                rowSetIterator = rowSet.findRowSetIterator(this.getName());
                if (this.mObjStat == 100) {
                    if (rowSetIterator != null) {
                        rowSetIterator.closeRowSetIterator();
                    }
                    return;
                }
                if (rowSetIterator == null) {
                    rowSetIterator = rowSet.createRowSetIterator(this.getName());
                }
            }
            this.setRowSetIteratorImpl(rowSetIterator);
            this.applyVariableOpers();
            this.setRowFilterValues();
            if (this.isSyncIteratorState()) {
                this.syncIteratorState();
            }
            if (this.getChangeFlag(0)) {
                int n = rowSetIterator.getRangeStart();
                rowSetIterator.setRangeSize(this.mRangeSize);
                int n2 = rowSetIterator.getRangeStart();
                if (n != n2) {
                    WSApplicationModuleImpl wSApplicationModuleImpl = (WSApplicationModuleImpl)this.getApplicationModule();
                    int n3 = wSApplicationModuleImpl.getRemoteObjectId(rowSetIterator);
                    SvcMsgResponseValues svcMsgResponseValues = new SvcMsgResponseValues(4119, wSApplicationModuleImpl.getResponseName());
                    svcMsgResponseValues.setIntValues(new int[]{n2, n3});
                    wSApplicationModuleImpl.addResponse(svcMsgResponseValues);
                }
            }
            if (!this.mIsDefault && this.getChangeFlag(2)) {
                rowSetIterator.setRowValidation(this.mRowValidation);
            }
            if (this.getChangeFlag(3)) {
                rowSetIterator.setIterMode(this.mIterMode);
            }
            int n = 0;
            while (n < this.mDetailRowSets.size()) {
                String string = (String)this.mDetailRowSets.get(n);
                String string2 = (String)this.mDetailLinkDefNames.get(n);
                rowSetIterator.createDetailRowSet(string, string2);
                ++n;
            }
            if (this.mIteratorState != null) {
                this.mIteratorState.setRangeStart(rowSetIterator.getRangeStart());
            }
        }
        catch (Exception exception) {
            this.processWSException(exception);
        }
    }

    void doWork() {
        if (this.mObjStat == -1 || this.mObjStat == 100) {
            return;
        }
        this.mDataModelMasterRows = null;
    }

    void doWorkPart2() {
        if (this.mObjStat == -1 || this.mObjStat == 100) {
            return;
        }
        try {
            RowSetIterator rowSetIterator = this.getRowSetIterator();
            if (this.getChangeFlag(1)) {
                rowSetIterator.setRangeStart(this.mRangeStart);
            }
        }
        catch (Exception exception) {
            this.processWSException(exception);
        }
    }

    void doFinish(boolean bl) {
        if (bl) {
            this.mDataModelMasterRows = null;
        }
    }

    void addDataModelMasterRows(Row[] rowArray) {
        if (rowArray == null || rowArray.length == 0) {
            return;
        }
        if (this.mDataModelMasterRows == null) {
            int n = rowArray.length > 20 ? rowArray.length : 20;
            this.mDataModelMasterRows = new HashMap(n);
        }
        int n = 0;
        while (n < rowArray.length) {
            this.mDataModelMasterRows.put(rowArray[n], rowArray[n]);
            ++n;
        }
    }

    Row[] getCachedDataModelMasterRows() {
        if (this.mDataModelMasterRows != null) {
            Collection collection = this.mDataModelMasterRows.values();
            Row[] rowArray = new Row[collection.size()];
            collection.toArray(rowArray);
            return rowArray;
        }
        return null;
    }

    Row[] getDataModelMasterRows() {
        if (this.mDataModelMasterRows == null) {
            return this.getRowSetIterator().getAllRowsInRange();
        }
        Row[] rowArray = this.getCachedDataModelMasterRows();
        return rowArray;
    }

    public boolean isSyncIteratorState() {
        return ((WSApplicationModuleImpl)this.mParent.getApplicationModule()).isSyncIteratorState();
    }

    void setRowFilterValues() {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            ((WSRowSetIteratorMarshaller)((Object)rowSetIterator)).setRowFilterValues(this.mRowFilterValues);
        }
    }

    void syncIteratorState() {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null) {
            Row[] rowArray;
            Row row;
            ((WSRowSetIteratorMarshaller)((Object)rowSetIterator)).prepareForBatchMode(this.mIteratorState, true);
            if (!(this.mCurrentRowKey == null || (row = rowSetIterator.getCurrentRow()) != null && this.mCurrentRowKey.equals(row.getKey()) || (rowArray = rowSetIterator.findByKey(this.mCurrentRowKey, 1)) == null || rowArray.length <= 0)) {
                row = rowArray[0];
                rowSetIterator.setCurrentRow(row);
            }
        }
    }

    Object[] getRowFilterValues() {
        return this.mRowFilterValues;
    }

    public RowSet getRowSet() {
        return this.mParent.getRowSet();
    }

    public RowSet[] getDetailRowSets() {
        Object[] objectArray = new RowSet[this.mDetailRowSets.size()];
        this.mDetailRowSets.toArray(objectArray);
        return objectArray;
    }

    public RowSet createDetailRowSet(String string, String string2) {
        WSRowSetImpl wSRowSetImpl = new WSRowSetImpl(string, true, false, (WSViewObjectImpl)this.getRowSet().getViewObject());
        this.mDetailRowSets.add((Object)wSRowSetImpl);
        this.mDetailLinkDefNames.add((Object)string2);
        return wSRowSetImpl;
    }

    public void closeRowSetIterator() {
        if (this.mObjStat == 0) {
            this.mParent.removeRowSetIterator(this);
        }
        this.mObjStat = 100;
    }

    public Object getSyncLock() {
        return this.mParent.getSyncLock();
    }

    public int setRangeSize(int n) {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        int n2 = this.getRangeSize();
        if (n2 != n) {
            this.mRangeSize = n;
            if (!this.isClient()) {
                return rowSetIterator.setRangeSize(n);
            }
            this.setChangeFlag(0, true);
            this.mParent.executeQuery2(false, false);
            this.mParent.setRangeSizeChanged(true);
        }
        return this.mRangeSize;
    }

    public int getRangeSize() {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null && !this.getChangeFlag(0)) {
            this.mRangeSize = rowSetIterator.getRangeSize();
        }
        return this.mRangeSize;
    }

    public int getRangeStart() {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null && !this.getChangeFlag(1)) {
            this.mRangeStart = rowSetIterator.getRangeStart();
        }
        return this.mRangeStart;
    }

    public int setRangeStart(int n) {
        if (this.mRangeStart != n) {
            this.mRangeStart = n;
            if (!this.isClient()) {
                RowSetIterator rowSetIterator = this.getRowSetIterator();
                return rowSetIterator.setRangeStart(n);
            }
            this.setChangeFlag(1, true);
        }
        return this.mRangeStart;
    }

    public int scrollRange(int n) {
        RowSetIterator rowSetIterator = this.getRowSetIterator();
        if (rowSetIterator != null && !this.getChangeFlag(1)) {
            this.mRangeStart = rowSetIterator.getRangeStart();
        }
        if (this.mRangeStart < 0) {
            this.mRangeStart = 0;
        }
        this.mRangeStart += n;
        if (!this.isClient()) {
            rowSetIterator.scrollRange(n);
        } else {
            this.setChangeFlag(1, true);
        }
        return this.mRangeStart;
    }

    public int scrollRangeTo(Row row, int n) {
        if (this.mRSI != null && (this.getBatchCommMode() & 0x100) != 0) {
            return this.mRSI.scrollRangeTo(row, n);
        }
        this.invalidOperation("scrollRangeTo");
        return -1;
    }

    public void setRowValidation(boolean bl) {
        if (!this.isClient()) {
            RowSetIterator rowSetIterator = this.getRowSetIterator();
            rowSetIterator.setRowValidation(bl);
        } else {
            this.mRowValidation = bl;
            this.setChangeFlag(2, true);
        }
    }

    public boolean isRowValidation() {
        return this.mRowValidation;
    }

    public int getIterMode() {
        return this.mIterMode;
    }

    public void setIterMode(int n) {
        this.mIterMode = n;
        if (!this.isClient()) {
            RowSetIterator rowSetIterator = this.getRowSetIterator();
            rowSetIterator.setIterMode(n);
            return;
        }
        this.setChangeFlag(3, true);
    }

    void resolveAfterLoad(WSRowSetImpl wSRowSetImpl) {
        this.mParent = wSRowSetImpl;
    }
}

