/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oracle.jbo.AttrValException;
import oracle.jbo.AttributeDef;
import oracle.jbo.ReadOnlyAttrException;
import oracle.jbo.Variable;
import oracle.jbo.VariableManager;
import oracle.jbo.VariableManagerOwner;
import oracle.jbo.VariableValueManager;
import oracle.jbo.common.Base64;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.VariableImpl;
import oracle.jbo.common.VariableManagerImpl;
import oracle.jbo.domain.NullValue;
import oracle.jbo.rules.JboValidatorContext;
import oracle.jbo.rules.RulesBeanUtils;

public class VariableValueManagerImpl
extends VariableManagerImpl
implements Serializable,
VariableValueManager {
    private HashMap mValues;
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;

    public VariableValueManagerImpl() {
    }

    public VariableValueManagerImpl(VariableManagerOwner variableManagerOwner, VariableManager[] variableManagerArray) {
        super(variableManagerOwner, variableManagerArray);
        this.mValues = new HashMap(4);
    }

    protected Map values() {
        return this.mValues;
    }

    protected Object accessValue(Variable variable) {
        return this.values().get(variable);
    }

    Object getValue(Variable variable, boolean bl) {
        Object object = this.getValueRaw(variable, bl, true);
        if (object instanceof NullValue) {
            object = null;
        }
        return object;
    }

    public Object[] getVariableValues(Variable[] variableArray) {
        Object[] objectArray = null;
        if (variableArray != null && variableArray.length > 0) {
            objectArray = new Object[variableArray.length];
            int n = 0;
            while (n < variableArray.length) {
                objectArray[n] = this.getVariableValue(variableArray[n]);
                ++n;
            }
        }
        return objectArray;
    }

    public Object[] getVariableValuesRaw(Variable[] variableArray, boolean bl) {
        Object[] objectArray = null;
        if (variableArray != null && variableArray.length > 0) {
            objectArray = new Object[variableArray.length];
            int n = 0;
            while (n < variableArray.length) {
                objectArray[n] = this.getVariableValueRaw(variableArray[n], bl);
                ++n;
            }
        }
        return objectArray;
    }

    public Object getVariableValue(Variable variable) {
        return this.getValue(variable, true);
    }

    public Object getVariableValue(String string) {
        return this.getValue(this.findVariable(string), false);
    }

    public Object getVariableValueRaw(Variable variable, boolean bl) {
        return this.getValueRaw(variable, true, bl);
    }

    public Object getVariableValueRaw(String string, boolean bl) {
        return this.getValueRaw(this.findVariable(string), false, bl);
    }

    protected void populateVariableValue(Variable variable, Object object) {
        this.values().put(variable, object);
    }

    void doSetVariableValue(Variable variable, Object object) {
        object = object == null ? new NullValue() : variable.convertToJava(object);
        VariableImpl variableImpl = (VariableImpl)variable;
        ArrayList arrayList = variableImpl.getValidators();
        if (arrayList != null && arrayList.size() > 0) {
            JboValidatorContext jboValidatorContext = new JboValidatorContext(132, (Object)this, this.getName(), (AttributeDef)variableImpl, this.getVariableValue(variable), object);
            AttrValException attrValException = RulesBeanUtils.validateObject(arrayList.iterator(), (JboValidatorContext)jboValidatorContext, (boolean)false);
            if (attrValException != null) {
                throw attrValException;
            }
        }
        this.populateVariableValue(variable, object);
    }

    public void setVariableValue(Variable variable, Object object) {
        if (variable.getUpdateableFlag() == 0) {
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = VariableValueManagerImpl.class$("oracle.jbo.CSMessageBundle");
            }
            throw new ReadOnlyAttrException(132, clazz, "27028", this.getName(), variable.getName());
        }
        this.doSetVariableValue(variable, object);
    }

    public void setVariableValue(String string, Object object) {
        this.setVariableValue(this.findVariable(string), object);
    }

    public void mergeVariableValues(Variable[] variableArray, Object[] objectArray) {
        this.mergeVariables(variableArray);
        if (variableArray != null) {
            int n = 0;
            while (n < variableArray.length) {
                String string = variableArray[n].getName();
                Object object = this.getVariableValue(string);
                if (object == null) {
                    if (objectArray[n] != null) {
                        this.doSetVariableValue(this.findVariable(string), objectArray[n]);
                    }
                } else if (!object.equals(objectArray[n])) {
                    this.doSetVariableValue(this.findVariable(string), objectArray[n]);
                }
                ++n;
            }
        }
    }

    public Variable replaceVariable(Variable variable) {
        Variable variable2 = this.findVariable(variable.getName());
        if (this == variable2.getVariableManager()) {
            super.replaceVariable(variable);
        } else {
            variable2.getVariableManager().replaceVariable(variable);
        }
        Object object = this.clearValue(variable2);
        if (object != null) {
            this.mValues.put(variable, object);
        }
        return variable2;
    }

    public Object clearValue(String string) {
        return this.clearValue(this.findVariable(string));
    }

    public Object clearValue(Variable variable) {
        Object object = this.mValues.remove(variable);
        if (object != null) {
            return object;
        }
        VariableManager[] variableManagerArray = this.getVarMgrParents();
        if (variableManagerArray != null) {
            int n = 0;
            while (n < variableManagerArray.length) {
                if (variableManagerArray[n] instanceof VariableValueManager && (object = ((VariableValueManager)variableManagerArray[n]).clearValue(variable)) != null) {
                    return object;
                }
                ++n;
            }
        }
        return null;
    }

    public String getPassivatableVariables() {
        return this.getPassivatableVariablesInternal(true);
    }

    public String getLocalPassivatableVariables() {
        return this.getPassivatableVariablesInternal(false);
    }

    private String getPassivatableVariablesInternal(boolean bl) {
        Object object = this.doPassivateVariables(bl);
        if (object == null) {
            return null;
        }
        OutputStream outputStream = Base64.getOutputStream(1275);
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(object);
            outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return outputStream.toString();
    }

    public void activatePassivatedVariables(String string) {
        block2: {
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(Base64.getInputStream(string));
                Object object = objectInputStream.readObject();
                objectInputStream.close();
                this.doActivateVariables(object);
            }
            catch (Exception exception) {
                if (!Diagnostic.isOn()) break block2;
                Diagnostic.println("Failed to activate variables: Component=" + this.getName() + " msg:\n" + exception.getMessage() + "\nBase64: " + string);
            }
        }
    }

    private Object doPassivateVariables(boolean bl) {
        Variable[] variableArray = this.getVariables();
        if (variableArray == null || variableArray.length == 0) {
            return null;
        }
        Object[] objectArray = null;
        if (bl) {
            ArrayList<Variable> arrayList = new ArrayList<Variable>();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            Object object = null;
            int n = 0;
            while (n < variableArray.length) {
                object = this.getVariableValueRaw(variableArray[n], false);
                if (object != null) {
                    arrayList.add(variableArray[n]);
                    arrayList2.add(object);
                }
                ++n;
            }
            Object[] objectArray2 = arrayList.toArray(new Object[arrayList.size()]);
            variableArray = new Variable[arrayList.size()];
            System.arraycopy(objectArray2, 0, variableArray, 0, objectArray2.length);
            objectArray = arrayList2.toArray();
        } else {
            objectArray = this.getVariableValuesRaw(variableArray, false);
        }
        ArrayList<Variable> arrayList = new ArrayList<Variable>(variableArray.length);
        ArrayList<String> arrayList3 = new ArrayList<String>(variableArray.length);
        ArrayList<Object> arrayList4 = new ArrayList<Object>(variableArray.length);
        int n = 0;
        while (n < variableArray.length) {
            Variable variable = variableArray[n];
            Object object = objectArray[n];
            if (variable.isPassivationNeeded()) {
                arrayList.add(variable);
            }
            if (!variable.isDefinedDefaultValue()) {
                arrayList3.add(variable.getName());
                arrayList4.add(object);
            } else if (object != null && !object.equals(variable.getDefaultValue())) {
                arrayList3.add(variable.getName());
                arrayList4.add(object);
            }
            ++n;
        }
        if (arrayList.size() == 0 && arrayList3.size() == 0) {
            return null;
        }
        Object[] objectArray3 = new Object[3];
        if (arrayList.size() > 0) {
            objectArray3[0] = arrayList.toArray(new Variable[arrayList.size()]);
        }
        if (arrayList3.size() > 0) {
            objectArray3[1] = arrayList3.toArray(new String[arrayList3.size()]);
            objectArray3[2] = arrayList4.toArray(new Object[arrayList3.size()]);
        }
        return objectArray3;
    }

    private void doActivateVariables(Object object) {
        if (((Object[])object)[0] != null) {
            Variable[] variableArray = (Variable[])((Object[])object)[0];
            int n = 0;
            while (n < variableArray.length) {
                Variable variable = this.lookupVariable(variableArray[n].getName());
                if (variable == null) {
                    this.addVariable(variableArray[n]);
                } else {
                    variable.getVariableManager().replaceVariable(variableArray[n]);
                }
                ++n;
            }
        }
        if (((Object[])object)[1] != null) {
            String[] stringArray = (String[])((Object[])object)[1];
            Object[] objectArray = (Object[])((Object[])object)[2];
            int n = 0;
            while (n < stringArray.length) {
                this.populateVariableValue(this.lookupVariable(stringArray[n]), objectArray[n]);
                ++n;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

