/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.client.remote;

import com.sun.java.util.collections.ArrayList;
import oracle.jbo.client.remote.RowFilterKey;
import oracle.jbo.client.remote.RowImpl;
import oracle.jbo.client.remote.RowSetIteratorImpl;
import oracle.jbo.common.MasterRowHandles;
import oracle.jbo.common.SvcMsgIteratorState;
import oracle.jbo.common.WeakHashtable;

class DetailSet {
    MasterRowHandles mMasterRowHandles;
    Object[] mRowFilterValues;
    ArrayList mRows;
    WeakHashtable mRowHandles;
    int mEventSeqId;
    long mEstimatedRowCount;
    SvcMsgIteratorState mIteratorState;

    DetailSet(MasterRowHandles masterRowHandles, Object[] objectArray, ArrayList arrayList, int n, long l, RowSetIteratorImpl rowSetIteratorImpl, SvcMsgIteratorState svcMsgIteratorState) {
        this.mRowFilterValues = objectArray;
        this.mEventSeqId = n;
        this.mEstimatedRowCount = l;
        this.initialize(masterRowHandles, svcMsgIteratorState);
        this.setRows(arrayList);
    }

    void initialize(MasterRowHandles masterRowHandles, SvcMsgIteratorState svcMsgIteratorState) {
        if (masterRowHandles == null) {
            masterRowHandles = new MasterRowHandles(null);
        }
        this.mMasterRowHandles = masterRowHandles;
        this.setIteratorState(svcMsgIteratorState);
    }

    MasterRowHandles getMasterRowHandles() {
        return this.mMasterRowHandles;
    }

    void setMasterRowHandles(MasterRowHandles masterRowHandles) {
        this.mMasterRowHandles = masterRowHandles;
    }

    boolean isForMasterRows(MasterRowHandles masterRowHandles) {
        if (this.mMasterRowHandles == null) {
            return masterRowHandles == null;
        }
        return this.mMasterRowHandles.equals(masterRowHandles);
    }

    boolean isForRowFilter(Object[] objectArray) {
        if (objectArray == null) {
            if (this.mRowFilterValues == null) {
                return true;
            }
            return new RowFilterKey(this.mRowFilterValues).isNull();
        }
        return new RowFilterKey(objectArray).equals(new RowFilterKey(this.mRowFilterValues));
    }

    Object[] getRowFilterValues() {
        return this.mRowFilterValues;
    }

    void setRowFilterValues(Object[] objectArray) {
        this.mRowFilterValues = objectArray;
    }

    ArrayList getRows() {
        return this.mRows;
    }

    WeakHashtable getRowHandles() {
        return this.mRowHandles;
    }

    void initRows(ArrayList arrayList) {
        if (arrayList != null) {
            int n = 0;
            while (n < arrayList.size()) {
                RowImpl rowImpl = (RowImpl)arrayList.get(n);
                rowImpl.setDetailSet(this);
                ++n;
            }
        }
    }

    void setRows(ArrayList arrayList) {
        this.mRows = arrayList;
        this.initRows(arrayList);
    }

    void setRowHandles(WeakHashtable weakHashtable) {
        this.mRowHandles = weakHashtable;
    }

    RowImpl findRowByHandle(Object object) {
        int n = 0;
        while (n < this.mRows.size()) {
            RowImpl rowImpl = (RowImpl)this.mRows.get(n);
            if (rowImpl.getHandle().equals(object)) {
                return rowImpl;
            }
            ++n;
        }
        return null;
    }

    int getEventSeqId() {
        return this.mEventSeqId;
    }

    SvcMsgIteratorState getCliIteratorState() {
        return this.mIteratorState;
    }

    void setIteratorState(SvcMsgIteratorState svcMsgIteratorState) {
        this.mIteratorState = svcMsgIteratorState;
    }

    void setEstimatedRowCount(long l) {
        this.mEstimatedRowCount = l;
    }

    void adjustEstimatedRowCount(int n) {
        this.mEstimatedRowCount += (long)n;
    }

    void resetForActivation() {
        this.mEventSeqId = 0;
    }
}

