/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server.security.jazn;

import java.lang.reflect.Constructor;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Principal;
import java.util.ArrayList;
import oracle.jbo.JboException;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.server.security.JboJAASContext;
import oracle.jbo.server.security.JboJAASPolicyManager;
import oracle.jbo.server.security.JboPermission;
import oracle.jbo.server.security.jazn.JboJAZNContext;
import oracle.jbo.server.security.jazn.JboJAZNPermission;
import oracle.security.jazn.JAZNContext;
import oracle.security.jazn.policy.GlobalPolicy;
import oracle.security.jazn.policy.Grantee;
import oracle.security.jazn.policy.JAZNPolicy;
import oracle.security.jazn.policy.PermissionClassManager;
import oracle.security.jazn.policy.RealmPolicy;
import oracle.security.jazn.realm.Realm;
import oracle.security.jazn.realm.RealmManager;
import oracle.security.jazn.realm.RealmPrincipal;
import oracle.security.jazn.realm.RealmRole;
import oracle.security.jazn.realm.RoleManager;

public class JboJAZNPolicyManager
implements JboJAASPolicyManager {
    private static JboJAASContext mContext = null;
    private static PermissionClassManager _permClsMgr = null;
    private static RealmManager _realmMgr = null;
    private static boolean isRealmPolicySupported = true;
    public static final String ENTITY_PERMISSION_CLASS = "oracle.jbo.server.security.jazn.JboJAZNEntityPermission";
    public static final String ENTITYATTRIBUTE_PERMISSION_CLASS = "oracle.jbo.server.security.jazn.JboJAZNEntityAttributePermission";
    private static /* synthetic */ Class class$java$lang$String;
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;

    public JboJAZNPolicyManager(JboJAASContext jboJAASContext) {
        mContext = jboJAASContext;
    }

    public JboJAASContext getJAASContext() {
        return mContext;
    }

    public PermissionCollection getPermissions() {
        return null;
    }

    static PermissionClassManager getPermissionClassManager() {
        if (_permClsMgr == null) {
            _permClsMgr = JAZNContext.getPermissionClassManager();
        }
        return _permClsMgr;
    }

    static RealmManager getRealmManager() {
        if (_realmMgr == null) {
            _realmMgr = JAZNContext.getRealmManager();
        }
        return _realmMgr;
    }

    static RealmRole getRealmRole(String string, String string2) {
        try {
            RoleManager roleManager = JboJAZNPolicyManager.getRealmManager().getRealm(string2).getRoleManager();
            RealmRole realmRole = roleManager.getRole(string);
            return realmRole;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    static RoleManager getRoleManager(RealmRole realmRole) {
        try {
            RoleManager roleManager = realmRole.getRealm().getRoleManager();
            return roleManager;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public byte getPermission(String string, String string2, String string3) {
        String string4 = "";
        String string5 = string;
        int n = string.indexOf("/");
        if (n > 0) {
            string4 = string.substring(0, n);
            string5 = string.substring(n + 1);
        }
        if (string4 == null || string4.length() == 0) {
            string4 = ((JboJAZNContext)mContext).getDefaultRealm();
            Diagnostic.println("  Default Realm=" + string4);
        }
        Diagnostic.println("  Role = " + string5 + " Realm=" + string4 + " Target=" + string2);
        return this.getPermission(string5, string4, string2, string3);
    }

    public byte getPermission(String string, String string2, String string3, String string4) {
        RealmRole realmRole = JboJAZNPolicyManager.getRealmRole(string, string2);
        if (realmRole == null) {
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = JboJAZNPolicyManager.class$("oracle.jbo.CSMessageBundle");
            }
            throw new JboException(clazz, "24001", new Object[]{string});
        }
        ArrayList arrayList = this.getRolePermissions(realmRole, string3, string4);
        if (arrayList != null) {
            int n = 0;
            while (n < arrayList.size()) {
                Permission permission = (Permission)arrayList.get(n);
                JboJAZNPermission jboJAZNPermission = (JboJAZNPermission)permission;
                if (jboJAZNPermission.getTargetName().equals(string3)) {
                    Diagnostic.println("getPermission: target = " + string3 + " permission = " + jboJAZNPermission.getPermission());
                    return jboJAZNPermission.getPermission();
                }
                ++n;
            }
        }
        return 4;
    }

    public JAZNPolicy getGlobalPolicy() {
        GlobalPolicy globalPolicy = null;
        try {
            globalPolicy = ((JboJAZNContext)mContext).getJAZNConfig().getPolicyManager().getGlobalPolicy();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return globalPolicy;
    }

    public JAZNPolicy getRealmPolicy(Realm realm) {
        RealmPolicy realmPolicy = null;
        if (!isRealmPolicySupported) {
            return null;
        }
        try {
            realmPolicy = ((JboJAZNContext)mContext).getJAZNConfig().getPolicyManager().getRealmPolicy(realm);
        }
        catch (Exception exception) {
            isRealmPolicySupported = false;
        }
        return realmPolicy;
    }

    public ArrayList getRolePermissions(RealmRole realmRole, String string, String string2) {
        ArrayList<Permission> arrayList = new ArrayList<Permission>();
        try {
            JAZNPolicy jAZNPolicy = this.getRealmPolicy(realmRole.getRealm());
            if (jAZNPolicy == null) {
                jAZNPolicy = this.getGlobalPolicy();
            }
            Grantee grantee = new Grantee((Principal)((RealmPrincipal)realmRole));
            Class<?> clazz = Class.forName(string2);
            int n = 0;
            while (n < JboPermission.ATTR_PERMISSIONS.length) {
                String string3;
                Constructor<?> constructor;
                Permission permission;
                Class[] classArray = new Class[1];
                Class clazz2 = class$java$lang$String;
                if (clazz2 == null) {
                    clazz2 = classArray[0] = JboJAZNPolicyManager.class$("java.lang.String");
                }
                if (jAZNPolicy.hasPermission(grantee, permission = (Permission)(constructor = clazz.getConstructor(classArray)).newInstance(string3 = string + "/" + JboPermission.ATTR_PERMISSIONS[n]))) {
                    this.fixGrantPermission((JboJAZNPermission)permission);
                    if (!arrayList.contains(permission)) {
                        arrayList.add(permission);
                    }
                }
                ++n;
            }
            ArrayList<Permission> arrayList2 = arrayList;
            return arrayList2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    void fixGrantPermission(JboJAZNPermission jboJAZNPermission) {
        String string = jboJAZNPermission.getName();
        int n = string.indexOf("/");
        if (n > 0) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            jboJAZNPermission.setTargetName(string2);
            int n2 = 0;
            while (n2 < JboPermission.ATTR_PERMISSIONS.length) {
                if (JboPermission.ATTR_PERMISSIONS[n2].equals(string3)) {
                    jboJAZNPermission.setPermission((byte)n2);
                }
                ++n2;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

