/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server.rules;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import oracle.jbo.domain.DataCreationException;
import oracle.jbo.domain.DomainInterface;
import oracle.jbo.domain.TypeFactory;
import oracle.jbo.server.rules.JbiValidator;
import oracle.jbo.server.rules.JboBaseValidator;
import oracle.jbo.server.util.Variant;

public class JboCompareValidator
extends JboBaseValidator
implements JbiValidator {
    public static final int EQUALTO = 0;
    public static final int LESSTHAN = 1;
    public static final int GREATERTHAN = 2;
    public static final int LESSTHANEQUALTO = 3;
    public static final int GREATERTHANEQUALTO = 4;
    protected int mOperType;
    protected Object mRValue;

    protected void initialize() {
        super.initialize();
        this.mRValue = this.mValidatingAttr.convertToJava(this.mRValue);
    }

    public JboCompareValidator() {
        this.mbInverse = false;
        this.setType(0);
        this.setDefaultDescription("01302");
    }

    protected JboCompareValidator(boolean bl, int n) {
        this.mbInverse = bl;
        this.setType(n);
        this.setDefaultDescription("01302");
    }

    public JboCompareValidator(boolean bl, int n, Object object) {
        this.setType(n);
        this.mRValue = object;
        this.mbInverse = bl;
        this.setDefaultDescription("01302");
    }

    protected void setNewValue(Object object) throws Exception {
        super.setNewValue(object);
    }

    public boolean validateValue(Object object) {
        if (object == null || object.toString().length() == 0) {
            return true;
        }
        Variant variant = this.getVariant(object);
        Object object2 = this.getRhsValue();
        Object object3 = object;
        if (object2 != null && object3 != null) {
            if (object2.getClass() != object3.getClass()) {
                try {
                    object2 = TypeFactory.getInstance(object3.getClass(), object2);
                }
                catch (DataCreationException dataCreationException) {
                    boolean bl = false;
                    return bl;
                }
            }
            switch (this.mOperType) {
                case 0: {
                    return variant.compareTo(this.getVariant(object2)) == 0;
                }
                case 1: {
                    return variant.compareTo(this.getVariant(object2)) < 0;
                }
                case 2: {
                    return variant.compareTo(this.getVariant(object2)) > 0;
                }
                case 3: {
                    return variant.compareTo(this.getVariant(object2)) <= 0;
                }
                case 4: {
                    return variant.compareTo(this.getVariant(object2)) >= 0;
                }
            }
        }
        return false;
    }

    public void setType(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.mOperType = n;
                break;
            }
        }
    }

    public int getType() {
        return this.mOperType;
    }

    public void setRhsValue(Object object) {
        this.mRValue = object;
    }

    public Object getRhsValue() {
        return this.mRValue;
    }

    Variant getVariant(Object object) {
        Variant variant = new Variant();
        Object object2 = null;
        object2 = object instanceof DomainInterface ? ((DomainInterface)object).getData() : object;
        if (object2 instanceof Number) {
            if (object2 instanceof Integer) {
                variant.setInt((Integer)object2);
            } else if (object2 instanceof Short) {
                variant.setShort((Short)object2);
            } else if (object2 instanceof Long) {
                variant.setLong((Long)object2);
            } else if (object2 instanceof Float) {
                variant.setFloat(((Float)object2).floatValue());
            } else if (object2 instanceof Double) {
                variant.setDouble((Double)object2);
            } else if (object2 instanceof BigDecimal) {
                variant.setBigDecimal((BigDecimal)object2);
            } else if (object2 instanceof BigInteger) {
                variant.setLong(((Number)object2).longValue());
            } else if (object2 instanceof Byte) {
                variant.setByte((Byte)object2);
            } else {
                variant.setDouble(((Number)object2).doubleValue());
            }
        } else if (object2 instanceof String) {
            variant.setString((String)object2);
        } else if (object2 instanceof Time) {
            variant.setTime((Time)object2);
        } else if (object2 instanceof Timestamp) {
            variant.setTimestamp((Timestamp)object2);
        } else if (object2 instanceof Date) {
            variant.setDate((Date)object2);
        } else {
            variant.setObject(object2);
        }
        return variant;
    }

    public String toString() {
        return new String("Literal Compare( " + this.getOperatorTypeString() + this.mRValue.toString() + ")");
    }

    public static int convertOperType(String string) {
        switch (string.length()) {
            case 7: {
                return 0;
            }
            case 8: {
                return 1;
            }
            case 11: {
                return 2;
            }
            case 15: {
                return 3;
            }
            case 18: {
                return 4;
            }
        }
        return 0;
    }

    public String getOperatorTypeString() {
        String string = "";
        switch (this.mOperType) {
            case 0: {
                string = " = ";
                break;
            }
            case 1: {
                string = " < ";
                break;
            }
            case 2: {
                string = " > ";
                break;
            }
            case 3: {
                string = " <= ";
                break;
            }
            case 4: {
                string = " >= ";
                break;
            }
        }
        return string;
    }
}

