/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import oracle.jbo.AttributeList;
import oracle.jbo.Row;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.PropertyMetadata;
import oracle.jbo.server.AssociationDefImpl;
import oracle.jbo.server.EntityDefImpl;
import oracle.jbo.server.EntityImpl;
import oracle.jbo.server.EntityRowSetIteratorImpl;
import oracle.jbo.server.EntitySetIteratorImpl;
import oracle.jbo.server.QueryCollection;
import oracle.jbo.server.ViewObjectImpl;
import oracle.jbo.server.ViewRowImpl;
import oracle.jbo.server.ViewRowSetImpl;
import oracle.jbo.server.ViewRowSetIteratorImpl;

public class EntityRowSetImpl
extends ViewRowSetImpl
implements Set {
    private byte mEntityRowSetMode = EntityRowSetImpl.getDefaultMode();
    public static final byte ENTITYROWSET_UNINITIALIZED = -1;
    public static final byte ENTITYROWSET_INCONSISTENT = 0;
    public static final byte ENTITYROWSET_NEW_AND_MODIFIED = 1;
    public static byte mDefaultMode = (byte)-1;

    protected EntityRowSetImpl(ViewObjectImpl viewObjectImpl, AssociationDefImpl associationDefImpl, Object[] objectArray) {
        super(viewObjectImpl, null, null);
        this.setAssociationConsistent(this.isAssociationConsistent());
        this.setParamValues(objectArray);
        this.setWhereClauseParams(null);
        this.ensureStorage();
    }

    static byte getDefaultMode() {
        if (mDefaultMode == -1) {
            String string = PropertyMetadata.ENV_ENTITYROWSET_MODE.getProperty();
            String string2 = "???";
            if (string == null) {
                mDefaultMode = 1;
                string2 = "true";
            } else if (string.equals("false")) {
                mDefaultMode = 0;
                string2 = "false";
            } else if (string.equals("true")) {
                mDefaultMode = 1;
                string2 = "true";
            } else {
                if (Diagnostic.isOn()) {
                    Diagnostic.println("jbo.assoc.consistent env value [" + string + "] not recognized");
                }
                mDefaultMode = 1;
                string2 = string + "???";
            }
            if (Diagnostic.isOn()) {
                Diagnostic.println("EntityRowSetImpl's jbo.assoc.consistent = " + string2 + " (" + mDefaultMode + ")");
            }
        }
        return mDefaultMode;
    }

    ViewRowSetIteratorImpl createNewRowSetIterator(String string, boolean bl) {
        return new EntityRowSetIteratorImpl(this, string, bl);
    }

    Row doCreateAndInitRow(AttributeList attributeList) {
        ViewRowImpl viewRowImpl = (ViewRowImpl)super.doCreateAndInitRow(attributeList);
        if (viewRowImpl == null) {
            return null;
        }
        if (viewRowImpl instanceof EntityImpl) {
            return viewRowImpl;
        }
        return viewRowImpl.getEntity(0);
    }

    private EntityDefImpl getEntityDef() {
        return this.getViewObjectImpl().getViewDef().getEntityDef(0);
    }

    public Hashtable getProperties() {
        return this.getEntityDef().getProperties();
    }

    public void setAssociationConsistent(boolean bl) {
        this.setEntityRowSetMode(bl ? (byte)1 : 0);
        super.setAssociationConsistent(bl);
    }

    public boolean isAssociationConsistent() {
        return this.getEntityRowSetMode() == 1;
    }

    byte getEntityRowSetMode() {
        return this.mEntityRowSetMode;
    }

    void setEntityRowSetMode(byte by) {
        if (by == this.mEntityRowSetMode) {
            return;
        }
        switch (by) {
            case 0: 
            case 1: {
                this.mEntityRowSetMode = by;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    Row insertRowAtInternal(int n, Row row, boolean bl, boolean bl2) {
        EntityImpl entityImpl = ((ViewRowImpl)row).getEntity(0);
        QueryCollection queryCollection = this.getQueryCollection();
        Row[] rowArray = queryCollection.getRows(entityImpl);
        if (rowArray == null || rowArray.length == 0) {
            return super.insertRowAtInternal(n, row, bl, bl2);
        }
        if (Diagnostic.isOn()) {
            Diagnostic.println("EntityRowSetImpl: row already in inserted.");
        }
        return null;
    }

    public int size() {
        return this.getRowCount();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(Object object) {
        if (object instanceof EntityImpl) {
            return this.containsEntity((EntityImpl)object);
        }
        return false;
    }

    public Iterator iterator() {
        return new EntitySetIteratorImpl((EntityRowSetIteratorImpl)this.createRowSetIterator(null));
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        Iterator iterator = this.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            objectArray[n] = iterator.next();
            ++n;
        }
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        int n = this.size();
        if (objectArray.length < n) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
        }
        Iterator iterator = this.iterator();
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = iterator.next();
            ++n2;
        }
        if (objectArray.length > n) {
            objectArray[n] = null;
        }
        return objectArray;
    }

    public boolean add(Object object) {
        if (object instanceof EntityImpl) {
            return this.addEntity((EntityImpl)object);
        }
        return false;
    }

    public boolean remove(Object object) {
        if (object instanceof EntityImpl) {
            ((EntityImpl)object).remove();
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(Collection collection) {
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!this.add(iterator.next())) continue;
            bl = true;
        }
        return bl;
    }

    public boolean retainAll(Collection collection) {
        boolean bl = false;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public boolean removeAll(Collection collection) {
        boolean bl = false;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public void clear() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    private boolean addEntity(EntityImpl entityImpl) {
        if (!this.containsEntity(entityImpl)) {
            entityImpl.resurrect();
            int[] nArray = this.getQueryCollection().getViewObjectImpl().getFKeyMap();
            entityImpl.setAttributeValues(nArray, this.getRowFilter(null).getRowInitValues(), true);
            return true;
        }
        return false;
    }

    private boolean containsEntity(EntityImpl entityImpl) {
        Row[] rowArray = this.getQueryCollection().getRows(entityImpl);
        return rowArray != null && rowArray.length != 0;
    }
}

