/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.jbo.JboException;
import oracle.jbo.JboSerializationException;
import oracle.jbo.common.ContextUtil;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JboEnvUtil;
import oracle.jbo.common.JboXMLUtil;
import oracle.jbo.common.PropertyMetadata;
import oracle.jbo.common.WeakKeyHashtable;
import oracle.jbo.pcoll.PCollManager;
import oracle.jbo.pcoll.PCollManagerHelper;
import oracle.jbo.pcoll.PCollPersistable;
import oracle.jbo.pcoll.PCollection;
import oracle.jbo.server.ApplicationModuleImpl;
import oracle.jbo.server.Serializer;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;

class DBSerializer
extends Serializer {
    private static Object mStaticLock = new Object();
    PCollManager mPCollMgr;
    PCollection mPCollRows;
    private static WeakKeyHashtable mTableCreatedMap = null;
    private static boolean mTableCreated = false;

    private /* synthetic */ void $init$() {
        this.mPCollMgr = null;
        this.mPCollRows = null;
    }

    DBSerializer(ApplicationModuleImpl applicationModuleImpl) {
        super(applicationModuleImpl);
        this.$init$();
    }

    private void release() {
        if (this.mPCollRows != null) {
            this.mPCollRows.close();
            this.mPCollRows = null;
        }
        if (this.mPCollMgr != null) {
            this.txn.releaseInternalConnection(this.mPCollMgr.getConnection(), false);
            this.mPCollMgr.releaseConnection();
        }
    }

    void setup(int n) {
        if (this.mPCollMgr == null) {
            long l;
            String string;
            String string2 = this.txn.getPersistManagerClassName();
            this.mPCollMgr = new 1(this.txn, "TXN", string2, true, DBSerializer.getTableCreated());
            String string3 = (String)this.rootAM.getSession().getEnvironment().get(PropertyMetadata.ENV_TXN_TABLE_NAME.pName);
            String string4 = (String)this.rootAM.getSession().getEnvironment().get(PropertyMetadata.ENV_TXN_SEQ_NAME.pName);
            if (!PropertyMetadata.ENV_TXN_TABLE_NAME.pDefault.equals(string3) || !PropertyMetadata.ENV_TXN_SEQ_NAME.pDefault.equals(string4)) {
                this.mPCollMgr.overrideObjectNames(string3, string4);
            }
            if ((string = (String)this.rootAM.getSession().getEnvironment().get(PropertyMetadata.ENV_TXN_SEQ_INC.pName)) != null && (l = new Long(string).longValue()) > 1L) {
                this.mPCollMgr.setSequenceIncrementSize(l);
            }
            this.mPCollMgr.resolveName();
        } else {
            try {
                if (this.mPCollMgr.getConnection() != null) {
                    Statement statement = this.mPCollMgr.getConnection().createStatement();
                    statement.close();
                } else {
                    this.mPCollMgr.resetConnection(this.txn.getInternalConnection(true));
                }
            }
            catch (SQLException sQLException) {
                if (Diagnostic.isOn()) {
                    Diagnostic.println("An invlalid JDBC connection was detected by the persistence manager");
                }
                this.mPCollMgr.resetConnection(this.txn.getInternalConnection(true));
            }
        }
        this.mPCollRows = this.mPCollMgr.createCollection("TXN", 1, 1, n);
        this.mPCollRows.setCommitThreshhold(1);
        this.mPCollRows.enableIdAccess();
        this.mPCollRows.setCollectionOfOne(true);
    }

    int snapCommittedEOs() {
        int n = -1;
        try {
            this.setup(-1);
            AMRow aMRow = new AMRow(this.mPCollMgr, this.mPCollRows);
            this.passivateCommitList(aMRow.xmlDoc);
            this.mPCollRows.addElement(aMRow);
            this.mPCollRows.passivate();
            n = this.mPCollRows.getId();
            DBSerializer.setTableCreated(true);
            Object var4_3 = null;
            this.release();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.release();
            throw throwable;
        }
        return n;
    }

    void replayCommittedEOs(int n) {
        PCollPersistable pCollPersistable = null;
        try {
            this.setup(n);
            this.mPCollRows.activate(-1);
            pCollPersistable = this.mPCollRows.elementWithId(1L);
            DBSerializer.setTableCreated(true);
            Object var5_3 = null;
            this.release();
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.release();
            throw throwable;
        }
        if (pCollPersistable instanceof AMRow) {
            AMRow aMRow = (AMRow)pCollPersistable;
            if (aMRow.xmlDoc != null) {
                this.activateCommitList(aMRow.xmlDoc);
            }
        } else {
            throw new JboSerializationException(false, n, "Database", null);
        }
    }

    void removeCommittedEOs(int n) {
        try {
            this.setup(n);
            this.mPCollRows.removeAllElements();
            DBSerializer.setTableCreated(true);
            Object var3_2 = null;
            this.release();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.release();
            throw throwable;
        }
    }

    int reservePassivationId() {
        int n = -1;
        try {
            this.setup(-1);
            n = this.mPCollRows.getId();
            DBSerializer.setTableCreated(true);
            Object var3_2 = null;
            this.release();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.release();
            throw throwable;
        }
        return n;
    }

    int passivateRootAM(byte[] byArray) {
        return this.passivateRootAM(-1, byArray, 1);
    }

    int passivateRootAM(byte[] byArray, int n) {
        return this.passivateRootAM(-1, byArray, n);
    }

    int passivateRootAM(int n, byte[] byArray) {
        return this.passivateRootAM(n, byArray, 1);
    }

    int passivateRootAM(int n, byte[] byArray, int n2) {
        int n3 = n;
        try {
            this.setup(n);
            AMRow aMRow = new AMRow(this.mPCollMgr, this.mPCollRows);
            this.passivate(aMRow.xmlDoc, byArray, n2);
            this.mPCollRows.addElement(aMRow);
            this.mPCollRows.passivate();
            n3 = this.mPCollRows.getId();
            DBSerializer.setTableCreated(true);
            Object var7_6 = null;
            this.release();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.release();
            throw throwable;
        }
        return n3;
    }

    byte[] activateRootAM(int n, boolean bl) {
        return this.activateRootAM(n, bl, 1);
    }

    byte[] activateRootAM(int n, boolean bl, int n2) {
        byte[] byArray = new byte[]{};
        try {
            this.setup(n);
            this.mPCollRows.activate(-1);
            PCollPersistable pCollPersistable = this.mPCollRows.elementWithId(1L);
            if (pCollPersistable instanceof AMRow) {
                byArray = this.activate(((AMRow)pCollPersistable).xmlDoc, n2);
                if (bl) {
                    this.mPCollRows.removeAllElements();
                }
            } else {
                throw new JboSerializationException(false, n, "Database", null);
            }
            DBSerializer.setTableCreated(true);
            Object var7_6 = null;
            this.release();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.release();
            throw throwable;
        }
        return byArray;
    }

    void removeRootAM(int n) {
        try {
            this.setup(n);
            this.mPCollRows.removeAllElements();
            DBSerializer.setTableCreated(true);
            Object var3_2 = null;
            this.release();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.release();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean getTableCreated() {
        Object object = mStaticLock;
        synchronized (object) {
            if (JboEnvUtil.inOC4J()) {
                Object object2;
                Boolean bl;
                if (mTableCreatedMap == null) {
                    mTableCreatedMap = new WeakKeyHashtable();
                }
                if ((bl = (Boolean)mTableCreatedMap.get(object2 = ContextUtil.getInstance().findCurrentContext())) != null) {
                    boolean bl2 = bl;
                    return bl2;
                }
                boolean bl3 = false;
                return bl3;
            }
            boolean bl = mTableCreated;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setTableCreated(boolean bl) {
        Object object = mStaticLock;
        synchronized (object) {
            if (JboEnvUtil.inOC4J()) {
                if (mTableCreatedMap == null) {
                    mTableCreatedMap = new WeakKeyHashtable();
                }
                Object object2 = ContextUtil.getInstance().findCurrentContext();
                mTableCreatedMap.put(object2, new Boolean(bl));
            } else {
                mTableCreated = bl;
            }
        }
    }

    final class 1
    extends PCollManager {
        public long getPersistentNextNodeId(int n) {
            return -1;
        }

        public /* synthetic */ 1(PCollManagerHelper pCollManagerHelper, String string, String string2, boolean bl, boolean bl2) {
            super(pCollManagerHelper, string, string2, bl, bl2);
        }
    }

    class AMRow
    implements Serializable,
    PCollPersistable {
        static final long serialVersionUID = -1802067551534152697L;
        private long mPersistId;
        XMLDocument xmlDoc;
        private transient long mPCollParentId;
        private transient boolean mHasBeenPersisted;
        private transient boolean mPCollChanged;
        transient PCollManager mPCollMgr;
        transient PCollection mPColls;

        private /* synthetic */ void $init$() {
            this.mPersistId = 1L;
            this.xmlDoc = new XMLDocument();
            this.mPCollParentId = 0L;
            this.mHasBeenPersisted = false;
            this.mPCollChanged = true;
        }

        AMRow() {
            this.$init$();
        }

        AMRow(PCollManager pCollManager, PCollection pCollection) {
            this.$init$();
            this.mPCollMgr = pCollManager;
            this.mPColls = pCollection;
        }

        public boolean canBePersisted() {
            return true;
        }

        public boolean getHasBeenPersisted() {
            return this.mHasBeenPersisted;
        }

        public void setHasBeenPersisted(boolean bl) {
            this.mHasBeenPersisted = bl;
        }

        public boolean getPCollChanged() {
            return this.mPCollChanged;
        }

        public void setPCollChanged(boolean bl) {
        }

        public long getPersistentId() {
            if (this.mPersistId == 0L) {
                this.mPersistId = this.mPCollMgr.getNextObjId(this.mPColls.getId());
            }
            return this.mPersistId;
        }

        public void setPersistentId(long l) {
            this.mPersistId = l;
        }

        public long getPCollParentId() {
            return this.mPCollParentId;
        }

        public void setPCollParentId(long l) {
            this.mPCollParentId = l;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) {
            try {
                StringWriter stringWriter = new StringWriter();
                this.xmlDoc.print(new PrintWriter(stringWriter));
                objectOutputStream.writeLong(this.mPersistId);
                byte[] byArray = stringWriter.toString().getBytes("utf-8");
                objectOutputStream.writeInt(byArray.length);
                objectOutputStream.write(byArray);
                this.mPCollChanged = false;
            }
            catch (IOException iOException) {
                throw new JboSerializationException(true, -1, "DB", iOException);
            }
        }

        private void readObject(ObjectInputStream objectInputStream) {
            try {
                this.mPersistId = objectInputStream.readLong();
                int n = objectInputStream.readInt();
                if (n > 0) {
                    DOMParser dOMParser = JboXMLUtil.createDOMParser(false);
                    byte[] byArray = new byte[n];
                    objectInputStream.readFully(byArray);
                    StringReader stringReader = new StringReader(new String(byArray, "utf-8"));
                    dOMParser.parse((Reader)stringReader);
                    this.xmlDoc = dOMParser.getDocument();
                }
            }
            catch (JboException jboException) {
                throw jboException;
            }
            catch (Exception exception) {
                throw new JboSerializationException(false, 1, "DB", exception);
            }
        }
    }
}

