/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.rules;

import java.beans.MethodDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import oracle.jbo.AttributeList;
import oracle.jbo.JboException;
import oracle.jbo.Row;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JboNameUtil;
import oracle.jbo.rules.JboAbstractValidator;
import oracle.jbo.rules.JboValidatorContext;
import oracle.jbo.rules.JboValidatorInterface;
import oracle.jbo.rules.RulesBeanUtils;

public class JboMethodValidator
extends JboAbstractValidator
implements JboValidatorInterface {
    MethodDescriptor m_method;
    String mMethodName;
    Object mObj;
    Object mLValue;

    public JboMethodValidator() {
        this.mMethodName = "";
        this.setDefaultDescription("01304");
    }

    public JboMethodValidator(String string, Class clazz, Class clazz2) {
        this.mMethodName = string;
        this.setDefaultDescription("01304");
        this.setObjectMethod(clazz, clazz2);
    }

    public String getErrorMsgId() {
        return this.mMsgId != null ? this.mMsgId : (this.mLValue instanceof Row ? "27012" : "27013");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void validate(JboValidatorContext jboValidatorContext) {
        Exception exception;
        block9: {
            this.mLValue = jboValidatorContext.getNewValue();
            this.mObj = jboValidatorContext.getSource();
            boolean bl = false;
            exception = null;
            try {
                block8: {
                    try {
                        bl = this.validateValue(this.mLValue);
                        if (this.mbInverse != bl) break block8;
                        RulesBeanUtils.raiseException(this.getErrorMessageClass(), this.getErrorMsgId(), this.mObj, jboValidatorContext.getSourceType(), jboValidatorContext.getSourceFullName(), jboValidatorContext.getAttributeDef(), this.mLValue, this.getMethodName(), exception);
                    }
                    catch (Exception exception2) {
                        exception = exception2;
                        Object var6_5 = null;
                        if (!(exception instanceof JboException || exception == null && bl)) {
                            RulesBeanUtils.raiseException(this.getErrorMessageClass(), this.getErrorMsgId(), this.mObj, jboValidatorContext.getSourceType(), jboValidatorContext.getSourceFullName(), jboValidatorContext.getAttributeDef(), this.mLValue, this.getMethodName(), exception);
                        }
                        break block9;
                    }
                }
                Object var6_4 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (!(exception instanceof JboException || exception == null && bl)) {
                    RulesBeanUtils.raiseException(this.getErrorMessageClass(), this.getErrorMsgId(), this.mObj, jboValidatorContext.getSourceType(), jboValidatorContext.getSourceFullName(), jboValidatorContext.getAttributeDef(), this.mLValue, this.getMethodName(), exception);
                }
                throw throwable;
            }
            if (!(exception instanceof JboException || exception == null && bl)) {
                RulesBeanUtils.raiseException(this.getErrorMessageClass(), this.getErrorMsgId(), this.mObj, jboValidatorContext.getSourceType(), jboValidatorContext.getSourceFullName(), jboValidatorContext.getAttributeDef(), this.mLValue, this.getMethodName(), exception);
            }
        }
        if (exception != null) {
            throw (JboException)exception;
        }
    }

    public boolean validateValue(Object object) throws JboException {
        if (this.m_method != null) {
            Object[] objectArray = this.isValidatingAttribute() ? new Object[]{object} : new Object[]{};
            try {
                Boolean bl = (Boolean)this.m_method.getMethod().invoke(this.mObj, objectArray);
                boolean bl2 = bl;
                return bl2;
            }
            catch (InvocationTargetException invocationTargetException) {
                if (invocationTargetException.getTargetException() instanceof JboException) {
                    throw (JboException)invocationTargetException.getTargetException();
                }
            }
            catch (Exception exception) {
                Diagnostic.println("MethodValidation:" + exception.getMessage());
            }
        }
        return false;
    }

    public void setMethodName(String string) {
        this.mMethodName = string;
    }

    private boolean isValidatingAttribute() {
        return this.mLValue instanceof AttributeList ^ true;
    }

    private void setObjectMethod(Class clazz, Class clazz2) {
        if (this.m_method == null) {
            try {
                Method method = clazz2 != null ? JboNameUtil.findMethod(clazz, this.mMethodName, new Class[]{clazz2}, null) : JboNameUtil.findMethod(clazz, this.mMethodName, new Class[0], null);
                this.m_method = new MethodDescriptor(method);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public String getMethodName() {
        return this.mMethodName;
    }

    public Method getMethod() {
        if (this.m_method != null) {
            return this.m_method.getMethod();
        }
        return null;
    }

    public String toString() {
        return new String("Method()");
    }
}

