/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.rules;

import oracle.jbo.rules.JboAbstractValidator;
import oracle.jbo.rules.JboValidatorContext;
import oracle.jbo.rules.JboValidatorInterface;

public class JboLengthValidator
extends JboAbstractValidator
implements JboValidatorInterface {
    public static final int EQUALTO = 0;
    public static final int LESSTHAN = 1;
    public static final int GREATERTHAN = 2;
    public static final int LESSTHANEQUALTO = 3;
    public static final int GREATERTHANEQUALTO = 4;
    protected int mOperType;
    public static final int CHARACTER = 0;
    public static final int BYTE = 1;
    protected int mDataType;
    protected Object rhsValue;

    protected void initialize(JboValidatorContext jboValidatorContext) {
        super.initialize(jboValidatorContext);
    }

    public JboLengthValidator() {
        this.mbInverse = false;
        this.setOperType(0);
        this.setDataType(0);
        this.setDefaultDescription("01300");
    }

    public JboLengthValidator(boolean bl, int n, int n2, Object object) {
        this.mbInverse = bl;
        this.setOperType(n);
        this.setDataType(n2);
        this.setRhsValue(object);
        this.setDefaultDescription("01300");
    }

    public boolean validateValue(Object object) {
        if (object == null) {
            return true;
        }
        String string = object.toString();
        int n = -1;
        switch (this.mDataType) {
            case 0: {
                n = string.length();
                break;
            }
            case 1: {
                n = string.getBytes().length;
                break;
            }
        }
        int n2 = Integer.parseInt(this.getRhsValue().toString());
        if (n != -1) {
            switch (this.mOperType) {
                case 0: {
                    return n == n2;
                }
                case 1: {
                    return n < n2;
                }
                case 2: {
                    return n > n2;
                }
                case 3: {
                    return n <= n2;
                }
                case 4: {
                    return n >= n2;
                }
            }
        }
        return false;
    }

    public void setOperType(int n) {
        this.mOperType = n;
    }

    public int getOperType() {
        return this.mOperType;
    }

    public void setDataType(int n) {
        this.mDataType = n;
    }

    public int getDataType() {
        return this.mDataType;
    }

    public void setRhsValue(Object object) {
        this.rhsValue = object;
    }

    public Object getRhsValue() {
        return this.rhsValue;
    }

    public String toString() {
        return new String(this.getDataTypeString() + " Length Compare( " + this.getOperatorTypeString() + this.rhsValue.toString() + ")");
    }

    public static int convertOperType(String string) {
        switch (string.length()) {
            case 7: {
                return 0;
            }
            case 8: {
                return 1;
            }
            case 11: {
                return 2;
            }
            case 15: {
                return 3;
            }
            case 18: {
                return 4;
            }
        }
        return 0;
    }

    public static int convertDataType(String string) {
        switch (string.length()) {
            case 4: {
                return 1;
            }
            case 9: {
                return 0;
            }
        }
        return 0;
    }

    public String getOperatorTypeString() {
        String string = "";
        switch (this.mOperType) {
            case 0: {
                string = " = ";
                break;
            }
            case 1: {
                string = " < ";
                break;
            }
            case 2: {
                string = " > ";
                break;
            }
            case 3: {
                string = " <= ";
                break;
            }
            case 4: {
                string = " >= ";
                break;
            }
        }
        return string;
    }

    private String getDataTypeString() {
        String string = "";
        switch (this.mDataType) {
            case 1: {
                string = " Byte ";
                break;
            }
            case 0: {
                string = " Character ";
                break;
            }
        }
        return string;
    }
}

