/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.pcoll;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import oracle.jbo.JboException;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.StringManager;
import oracle.jbo.pcoll.OraclePersistManager;
import oracle.jbo.pcoll.PCollKeyInfo;
import oracle.jbo.pcoll.PCollManager;
import oracle.jbo.pcoll.PCollection;
import oracle.jbo.pcoll.PersistManager;

public class JTAPersistManager
implements PersistManager {
    private static final String TRANSACTION_MANAGER = "java:comp/pm/TransactionManager";
    private PersistManager mManager = new OraclePersistManager();
    private Transaction mCurrent;
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;

    public void init(int n) {
        try {
            this.suspendCurrentTransaction();
            this.mManager.init(n);
            Object var3_2 = null;
            this.resumeCurrentTransaction();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.resumeCurrentTransaction();
            throw throwable;
        }
    }

    public void close() {
        this.close(0);
    }

    public void close(int n) {
        try {
            this.suspendCurrentTransaction();
            this.mManager.close(n);
            Object var3_2 = null;
            this.resumeCurrentTransaction();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.resumeCurrentTransaction();
            throw throwable;
        }
    }

    public int getMaxTabNameLength() {
        return this.mManager.getMaxTabNameLength();
    }

    public void setPCollManager(PCollManager pCollManager) {
        this.mManager.setPCollManager(pCollManager);
    }

    public void setTableName(String string) {
        this.mManager.setTableName(string);
    }

    public void setCommitThreshhold(int n) {
        this.mManager.setCommitThreshhold(n);
    }

    public void setPersistent(boolean bl) {
        this.mManager.setPersistent(bl);
    }

    public void setTableCreated(boolean bl) {
        this.mManager.setTableCreated(bl);
    }

    public void commit() {
        try {
            this.suspendCurrentTransaction();
            this.mManager.commit();
            Object var2_1 = null;
            this.resumeCurrentTransaction();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.resumeCurrentTransaction();
            throw throwable;
        }
    }

    public long getTableSignature(String string) {
        try {
            this.suspendCurrentTransaction();
            long l = this.mManager.getTableSignature(string);
            Object var5_3 = null;
            this.resumeCurrentTransaction();
            return l;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.resumeCurrentTransaction();
            throw throwable;
        }
    }

    public boolean waitForTableName(String string) {
        try {
            this.suspendCurrentTransaction();
            boolean bl = this.mManager.waitForTableName(string);
            Object var4_3 = null;
            this.resumeCurrentTransaction();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.resumeCurrentTransaction();
            throw throwable;
        }
    }

    public boolean holdTableName(String string, boolean bl) {
        try {
            this.suspendCurrentTransaction();
            boolean bl2 = this.mManager.holdTableName(string, bl);
            Object var5_4 = null;
            this.resumeCurrentTransaction();
            return bl2;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.resumeCurrentTransaction();
            throw throwable;
        }
    }

    public long queryNextCollectionId() {
        try {
            this.suspendCurrentTransaction();
            long l = this.mManager.queryNextCollectionId();
            Object var4_2 = null;
            this.resumeCurrentTransaction();
            return l;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.resumeCurrentTransaction();
            throw throwable;
        }
    }

    public long queryNextObjId(int n) {
        try {
            this.suspendCurrentTransaction();
            long l = this.mManager.queryNextObjId(n);
            Object var5_3 = null;
            this.resumeCurrentTransaction();
            return l;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.resumeCurrentTransaction();
            throw throwable;
        }
    }

    public long queryNextNodeId(int n) {
        try {
            this.suspendCurrentTransaction();
            long l = this.mManager.queryNextNodeId(n);
            Object var5_3 = null;
            this.resumeCurrentTransaction();
            return l;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.resumeCurrentTransaction();
            throw throwable;
        }
    }

    public void insert(long l, long l2, int n, PCollKeyInfo[] pCollKeyInfoArray, byte[] byArray) {
        try {
            this.suspendCurrentTransaction();
            this.mManager.insert(l, l2, n, pCollKeyInfoArray, byArray);
            Object var9_6 = null;
            this.resumeCurrentTransaction();
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            this.resumeCurrentTransaction();
            throw throwable;
        }
    }

    public void update(long l, long l2, int n, PCollKeyInfo[] pCollKeyInfoArray, byte[] byArray) {
        try {
            this.suspendCurrentTransaction();
            this.mManager.update(l, l2, n, pCollKeyInfoArray, byArray);
            Object var9_6 = null;
            this.resumeCurrentTransaction();
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            this.resumeCurrentTransaction();
            throw throwable;
        }
    }

    public void changeParent(long l, long l2, int n) {
        try {
            this.suspendCurrentTransaction();
            this.mManager.changeParent(l, l2, n);
            Object var7_4 = null;
            this.resumeCurrentTransaction();
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            this.resumeCurrentTransaction();
            throw throwable;
        }
    }

    public void delete(long l, int n) {
        try {
            this.suspendCurrentTransaction();
            this.mManager.delete(l, n);
            Object var5_3 = null;
            this.resumeCurrentTransaction();
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.resumeCurrentTransaction();
            throw throwable;
        }
    }

    public void deleteAll(int n) {
        try {
            this.suspendCurrentTransaction();
            this.mManager.deleteAll(n);
            Object var3_2 = null;
            this.resumeCurrentTransaction();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.resumeCurrentTransaction();
            throw throwable;
        }
    }

    public Object[] retrieve(long l, int n, boolean bl, long[] lArray) {
        try {
            this.suspendCurrentTransaction();
            Object[] objectArray = this.mManager.retrieve(l, n, bl, lArray);
            Object var8_6 = null;
            this.resumeCurrentTransaction();
            return objectArray;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.resumeCurrentTransaction();
            throw throwable;
        }
    }

    public long[] retrieveIdsWithKey(int n, Object object, int n2) {
        try {
            this.suspendCurrentTransaction();
            long[] lArray = this.mManager.retrieveIdsWithKey(n, object, n2);
            Object var6_5 = null;
            this.resumeCurrentTransaction();
            return lArray;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.resumeCurrentTransaction();
            throw throwable;
        }
    }

    private void suspendCurrentTransaction() {
        if (this.mCurrent == null) {
            try {
                TransactionManager transactionManager = (TransactionManager)new InitialContext().lookup(TRANSACTION_MANAGER);
                this.mCurrent = transactionManager.suspend();
                if (Diagnostic.isOn()) {
                    Diagnostic.println("PCOLL Suspend Txn. " + (this.mCurrent != null ? "Okay:" + this.mCurrent : "No transaction"));
                }
            }
            catch (NamingException namingException) {
                Class clazz = class$oracle$jbo$CSMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = JTAPersistManager.class$("oracle.jbo.CSMessageBundle");
                }
                String string = StringManager.getString(clazz.getName(), "01310", null, null);
                Class clazz2 = class$oracle$jbo$CSMessageBundle;
                if (clazz2 == null) {
                    clazz2 = class$oracle$jbo$CSMessageBundle = JTAPersistManager.class$("oracle.jbo.CSMessageBundle");
                }
                throw new JboException(clazz2, "27200", (Object[])new String[]{string, TRANSACTION_MANAGER}, new Exception[]{namingException});
            }
            catch (SystemException systemException) {
                Class clazz = class$oracle$jbo$CSMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = JTAPersistManager.class$("oracle.jbo.CSMessageBundle");
                }
                throw new JboException(clazz, "27201", null, new Exception[]{systemException});
            }
        }
    }

    private void resumeCurrentTransaction() {
        if (this.mCurrent != null) {
            try {
                block13: {
                    try {
                        TransactionManager transactionManager = (TransactionManager)new InitialContext().lookup(TRANSACTION_MANAGER);
                        transactionManager.resume(this.mCurrent);
                        if (!Diagnostic.isOn()) break block13;
                        Diagnostic.println("PCOLL Resume Txn. Okay");
                    }
                    catch (NamingException namingException) {
                        Class clazz = class$oracle$jbo$CSMessageBundle;
                        if (clazz == null) {
                            clazz = class$oracle$jbo$CSMessageBundle = JTAPersistManager.class$("oracle.jbo.CSMessageBundle");
                        }
                        String string = StringManager.getString(clazz.getName(), "01310", null, null);
                        Class clazz2 = class$oracle$jbo$CSMessageBundle;
                        if (clazz2 == null) {
                            clazz2 = class$oracle$jbo$CSMessageBundle = JTAPersistManager.class$("oracle.jbo.CSMessageBundle");
                        }
                        throw new JboException(clazz2, "27200", (Object[])new String[]{string, TRANSACTION_MANAGER}, new Exception[]{namingException});
                    }
                    catch (InvalidTransactionException invalidTransactionException) {
                        Class clazz = class$oracle$jbo$CSMessageBundle;
                        if (clazz == null) {
                            clazz = class$oracle$jbo$CSMessageBundle = JTAPersistManager.class$("oracle.jbo.CSMessageBundle");
                        }
                        throw new JboException(clazz, "27202", null, new Exception[]{invalidTransactionException});
                    }
                    catch (SystemException systemException) {
                        Class clazz = class$oracle$jbo$CSMessageBundle;
                        if (clazz == null) {
                            clazz = class$oracle$jbo$CSMessageBundle = JTAPersistManager.class$("oracle.jbo.CSMessageBundle");
                        }
                        throw new JboException(clazz, "27202", null, new Exception[]{systemException});
                    }
                    catch (IllegalStateException illegalStateException) {
                        Class clazz = class$oracle$jbo$CSMessageBundle;
                        if (clazz == null) {
                            clazz = class$oracle$jbo$CSMessageBundle = JTAPersistManager.class$("oracle.jbo.CSMessageBundle");
                        }
                        throw new JboException(clazz, "27202", null, new Exception[]{illegalStateException});
                    }
                }
                Object var8_2 = null;
                this.mCurrent = null;
            }
            catch (Throwable throwable) {
                Object var8_3 = null;
                this.mCurrent = null;
                throw throwable;
            }
        }
    }

    public void notifyPCollEvent(int n, Object object, Object object2) {
        if (PCollection.mEventTrace) {
            PCollection.printPCollEvent(n, object, object2);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

