/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common.ampool;

import java.io.PrintWriter;
import java.util.Date;
import oracle.jbo.common.ampool.ApplicationPoolImpl;
import oracle.jbo.common.ampool.ApplicationPoolListener;
import oracle.jbo.common.ampool.Statistics;
import oracle.jbo.pool.AgeHistogram;
import oracle.jbo.pool.ResourcePoolLogger;
import oracle.jbo.pool.ResourcePoolStatistics;

public final class ApplicationPoolLogger
extends ResourcePoolLogger
implements ApplicationPoolListener {
    private Statistics mStatistics;
    private int mAvgNumOfSessionsReferencingStateAccum;
    private int mAvgCounter;
    private final ApplicationPoolImpl mPool;
    private static /* synthetic */ Class class$oracle$jbo$common$ampool$AMPoolMessageBundle;

    private /* synthetic */ void $init$() {
        this.mStatistics = new Statistics();
        this.mAvgNumOfSessionsReferencingStateAccum = 0;
        this.mAvgCounter = 0;
    }

    public ApplicationPoolLogger(ApplicationPoolImpl applicationPoolImpl) {
        super(applicationPoolImpl);
        this.$init$();
        this.mPool = applicationPoolImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(byte by) {
        Object object = this.mPool.getSyncLock();
        synchronized (object) {
            super.handleEvent(by);
            switch (by) {
                case 4: {
                    ++this.mStatistics.mNumOfStateActivations;
                    break;
                }
                case 5: {
                    ++this.mStatistics.mNumOfStatePassivations;
                    break;
                }
                case 6: {
                    ++this.mStatistics.mNumOfReferencedInstancesRecycled;
                    break;
                }
                case 7: {
                    ++this.mStatistics.mNumOfUnreferencedInstancesRecycled;
                    break;
                }
                case 8: {
                    ++this.mStatistics.mNumOfInstancesReused;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statistics getStatistics() {
        Statistics statistics = null;
        Object object = this.mPool.getSyncLock();
        synchronized (object) {
            super.getResourcePoolStatistics();
            this.calculateAverages(true);
            this.mStatistics.mReferencedApplicationModules = this.mPool.getReferencedResourceCount();
            this.mStatistics.mNumOfSessions = this.mPool.getSessionCount();
            statistics = (Statistics)this.mStatistics.clone();
        }
        this.computeSessionAgeHistogram(statistics);
        this.computeAppModuleAgeHistograms(statistics);
        return statistics;
    }

    public ResourcePoolStatistics getStatisticsHolder() {
        return this.mStatistics;
    }

    public void computeResourceAgeHistogram(ResourcePoolStatistics resourcePoolStatistics) {
    }

    protected void computeSessionAgeHistogram(Statistics statistics) {
        long l = System.currentTimeMillis();
        Date[] dateArray = new Date[]{new Date(l - 60000L), new Date(l - 300000L), new Date(l - 600000L)};
        statistics.mSessionAgeHistogram = new AgeHistogram(dateArray);
        this.mPool.computeSessionAgeHistogram(statistics.mSessionAgeHistogram);
    }

    protected void computeAppModuleAgeHistograms(Statistics statistics) {
        long l = System.currentTimeMillis();
        Date[] dateArray = new Date[]{new Date(l - 60000L), new Date(l - 300000L), new Date(l - 600000L)};
        statistics.mRefInstanceAgeHistogram = new AgeHistogram(dateArray);
        statistics.mUnrefInstanceAgeHistogram = new AgeHistogram(dateArray);
        this.mPool.computeAppModuleAgeHistograms(statistics.mRefInstanceAgeHistogram, statistics.mUnrefInstanceAgeHistogram);
    }

    public void dumpPoolStatistics(PrintWriter printWriter) {
        Statistics statistics = this.getStatistics();
        Class clazz = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
        if (clazz == null) {
            clazz = class$oracle$jbo$common$ampool$AMPoolMessageBundle = ApplicationPoolLogger.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
        }
        this.printHeaderLine("31024", clazz, printWriter);
        Class clazz2 = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
        if (clazz2 == null) {
            clazz2 = class$oracle$jbo$common$ampool$AMPoolMessageBundle = ApplicationPoolLogger.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
        }
        this.printStatisticLine("30100", clazz2, (Object[])null, statistics.mNumOfInstanceCreations, printWriter);
        Class clazz3 = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
        if (clazz3 == null) {
            clazz3 = class$oracle$jbo$common$ampool$AMPoolMessageBundle = ApplicationPoolLogger.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
        }
        this.printStatisticLine("30101", clazz3, (Object[])null, statistics.mNumOfInstanceRemovals, printWriter);
        Class clazz4 = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
        if (clazz4 == null) {
            clazz4 = class$oracle$jbo$common$ampool$AMPoolMessageBundle = ApplicationPoolLogger.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
        }
        this.printHeaderLine("31025", clazz4, printWriter);
        Class clazz5 = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
        if (clazz5 == null) {
            clazz5 = class$oracle$jbo$common$ampool$AMPoolMessageBundle = ApplicationPoolLogger.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
        }
        this.printStatisticLine("30102", clazz5, (Object[])null, statistics.mNumOfStateActivations, printWriter);
        Class clazz6 = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
        if (clazz6 == null) {
            clazz6 = class$oracle$jbo$common$ampool$AMPoolMessageBundle = ApplicationPoolLogger.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
        }
        this.printStatisticLine("30103", clazz6, (Object[])null, statistics.mNumOfStatePassivations, printWriter);
        Class clazz7 = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
        if (clazz7 == null) {
            clazz7 = class$oracle$jbo$common$ampool$AMPoolMessageBundle = ApplicationPoolLogger.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
        }
        this.printHeaderLine("31026", clazz7, printWriter);
        Class clazz8 = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
        if (clazz8 == null) {
            clazz8 = class$oracle$jbo$common$ampool$AMPoolMessageBundle = ApplicationPoolLogger.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
        }
        this.printStatisticLine("30104", clazz8, (Object[])null, statistics.mNumOfCheckouts, printWriter);
        Class clazz9 = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
        if (clazz9 == null) {
            clazz9 = class$oracle$jbo$common$ampool$AMPoolMessageBundle = ApplicationPoolLogger.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
        }
        this.printStatisticLine("30105", clazz9, (Object[])null, statistics.mNumOfCheckins, printWriter);
        Class clazz10 = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
        if (clazz10 == null) {
            clazz10 = class$oracle$jbo$common$ampool$AMPoolMessageBundle = ApplicationPoolLogger.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
        }
        this.printStatisticLine("30106", clazz10, (Object[])null, statistics.mNumOfInstancesReused, printWriter);
        Class clazz11 = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
        if (clazz11 == null) {
            clazz11 = class$oracle$jbo$common$ampool$AMPoolMessageBundle = ApplicationPoolLogger.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
        }
        this.printStatisticLine("30107", clazz11, (Object[])null, statistics.mNumOfReferencedInstancesRecycled, printWriter);
        Class clazz12 = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
        if (clazz12 == null) {
            clazz12 = class$oracle$jbo$common$ampool$AMPoolMessageBundle = ApplicationPoolLogger.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
        }
        this.printStatisticLine("30108", clazz12, (Object[])null, statistics.mNumOfUnreferencedInstancesRecycled, printWriter);
        Class clazz13 = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
        if (clazz13 == null) {
            clazz13 = class$oracle$jbo$common$ampool$AMPoolMessageBundle = ApplicationPoolLogger.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
        }
        this.printStatisticLine("31031", clazz13, (Object[])null, statistics.mNumOfCheckoutFailures, printWriter);
        Class clazz14 = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
        if (clazz14 == null) {
            clazz14 = class$oracle$jbo$common$ampool$AMPoolMessageBundle = ApplicationPoolLogger.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
        }
        this.printHeaderLine("31027", clazz14, printWriter);
        Class clazz15 = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
        if (clazz15 == null) {
            clazz15 = class$oracle$jbo$common$ampool$AMPoolMessageBundle = ApplicationPoolLogger.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
        }
        this.printStatisticLine("30109", clazz15, (Object[])null, statistics.mResourceCount, printWriter);
        Class clazz16 = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
        if (clazz16 == null) {
            clazz16 = class$oracle$jbo$common$ampool$AMPoolMessageBundle = ApplicationPoolLogger.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
        }
        this.printStatisticLine("30110", clazz16, (Object[])null, statistics.mMaxNumOfInstances, printWriter);
        Class clazz17 = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
        if (clazz17 == null) {
            clazz17 = class$oracle$jbo$common$ampool$AMPoolMessageBundle = ApplicationPoolLogger.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
        }
        this.printStatisticLine("30111", clazz17, (Object[])null, statistics.mAvgNumOfInstances, printWriter);
        Class clazz18 = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
        if (clazz18 == null) {
            clazz18 = class$oracle$jbo$common$ampool$AMPoolMessageBundle = ApplicationPoolLogger.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
        }
        this.printStatisticLine("30112", clazz18, (Object[])null, statistics.mAvailableResourceCount, printWriter);
        Class clazz19 = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
        if (clazz19 == null) {
            clazz19 = class$oracle$jbo$common$ampool$AMPoolMessageBundle = ApplicationPoolLogger.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
        }
        this.printStatisticLine("30113", clazz19, (Object[])null, statistics.mAvgNumOfAvailableInstances, printWriter);
        Class clazz20 = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
        if (clazz20 == null) {
            clazz20 = class$oracle$jbo$common$ampool$AMPoolMessageBundle = ApplicationPoolLogger.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
        }
        this.printStatisticLine("30114", clazz20, (Object[])null, statistics.mAvgNumOfUnavailableInstances, printWriter);
        Class clazz21 = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
        if (clazz21 == null) {
            clazz21 = class$oracle$jbo$common$ampool$AMPoolMessageBundle = ApplicationPoolLogger.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
        }
        this.printStatisticLine("30115", clazz21, (Object[])null, statistics.mReferencedApplicationModules, printWriter);
        Class clazz22 = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
        if (clazz22 == null) {
            clazz22 = class$oracle$jbo$common$ampool$AMPoolMessageBundle = ApplicationPoolLogger.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
        }
        this.printHeaderLine("31028", clazz22, printWriter);
        Class clazz23 = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
        if (clazz23 == null) {
            clazz23 = class$oracle$jbo$common$ampool$AMPoolMessageBundle = ApplicationPoolLogger.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
        }
        this.printStatisticLine("30116", clazz23, (Object[])new String[]{"10"}, statistics.mRefInstanceAgeHistogram.mBuckets[3], printWriter);
        Class clazz24 = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
        if (clazz24 == null) {
            clazz24 = class$oracle$jbo$common$ampool$AMPoolMessageBundle = ApplicationPoolLogger.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
        }
        this.printStatisticLine("30116", clazz24, (Object[])new String[]{"5"}, statistics.mRefInstanceAgeHistogram.mBuckets[2], printWriter);
        Class clazz25 = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
        if (clazz25 == null) {
            clazz25 = class$oracle$jbo$common$ampool$AMPoolMessageBundle = ApplicationPoolLogger.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
        }
        this.printStatisticLine("30116", clazz25, (Object[])new String[]{"1"}, statistics.mRefInstanceAgeHistogram.mBuckets[1], printWriter);
        Class clazz26 = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
        if (clazz26 == null) {
            clazz26 = class$oracle$jbo$common$ampool$AMPoolMessageBundle = ApplicationPoolLogger.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
        }
        this.printStatisticLine("30117", clazz26, (Object[])new String[]{"1"}, statistics.mRefInstanceAgeHistogram.mBuckets[0], printWriter);
        Class clazz27 = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
        if (clazz27 == null) {
            clazz27 = class$oracle$jbo$common$ampool$AMPoolMessageBundle = ApplicationPoolLogger.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
        }
        this.printStatisticLine("30118", clazz27, (Object[])new String[]{"10"}, statistics.mUnrefInstanceAgeHistogram.mBuckets[3], printWriter);
        Class clazz28 = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
        if (clazz28 == null) {
            clazz28 = class$oracle$jbo$common$ampool$AMPoolMessageBundle = ApplicationPoolLogger.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
        }
        this.printStatisticLine("30118", clazz28, (Object[])new String[]{"5"}, statistics.mUnrefInstanceAgeHistogram.mBuckets[2], printWriter);
        Class clazz29 = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
        if (clazz29 == null) {
            clazz29 = class$oracle$jbo$common$ampool$AMPoolMessageBundle = ApplicationPoolLogger.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
        }
        this.printStatisticLine("30118", clazz29, (Object[])new String[]{"1"}, statistics.mUnrefInstanceAgeHistogram.mBuckets[1], printWriter);
        Class clazz30 = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
        if (clazz30 == null) {
            clazz30 = class$oracle$jbo$common$ampool$AMPoolMessageBundle = ApplicationPoolLogger.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
        }
        this.printStatisticLine("30119", clazz30, (Object[])new String[]{"1"}, statistics.mUnrefInstanceAgeHistogram.mBuckets[0], printWriter);
        Class clazz31 = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
        if (clazz31 == null) {
            clazz31 = class$oracle$jbo$common$ampool$AMPoolMessageBundle = ApplicationPoolLogger.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
        }
        this.printHeaderLine("31029", clazz31, printWriter);
        Class clazz32 = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
        if (clazz32 == null) {
            clazz32 = class$oracle$jbo$common$ampool$AMPoolMessageBundle = ApplicationPoolLogger.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
        }
        this.printStatisticLine("30120", clazz32, (Object[])null, statistics.mNumOfSessions, printWriter);
        Class clazz33 = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
        if (clazz33 == null) {
            clazz33 = class$oracle$jbo$common$ampool$AMPoolMessageBundle = ApplicationPoolLogger.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
        }
        this.printStatisticLine("30121", clazz33, (Object[])null, statistics.mAvgNumOfSessionsReferencingState, printWriter);
        Class clazz34 = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
        if (clazz34 == null) {
            clazz34 = class$oracle$jbo$common$ampool$AMPoolMessageBundle = ApplicationPoolLogger.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
        }
        this.printHeaderLine("31030", clazz34, printWriter);
        Class clazz35 = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
        if (clazz35 == null) {
            clazz35 = class$oracle$jbo$common$ampool$AMPoolMessageBundle = ApplicationPoolLogger.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
        }
        this.printStatisticLine("30122", clazz35, (Object[])new String[]{"10"}, statistics.mSessionAgeHistogram.mBuckets[3], printWriter);
        Class clazz36 = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
        if (clazz36 == null) {
            clazz36 = class$oracle$jbo$common$ampool$AMPoolMessageBundle = ApplicationPoolLogger.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
        }
        this.printStatisticLine("30122", clazz36, (Object[])new String[]{"5"}, statistics.mSessionAgeHistogram.mBuckets[2], printWriter);
        Class clazz37 = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
        if (clazz37 == null) {
            clazz37 = class$oracle$jbo$common$ampool$AMPoolMessageBundle = ApplicationPoolLogger.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
        }
        this.printStatisticLine("30122", clazz37, (Object[])new String[]{"1"}, statistics.mSessionAgeHistogram.mBuckets[1], printWriter);
        Class clazz38 = class$oracle$jbo$common$ampool$AMPoolMessageBundle;
        if (clazz38 == null) {
            clazz38 = class$oracle$jbo$common$ampool$AMPoolMessageBundle = ApplicationPoolLogger.class$("oracle.jbo.common.ampool.AMPoolMessageBundle");
        }
        this.printStatisticLine("30123", clazz38, (Object[])new String[]{"1"}, statistics.mSessionAgeHistogram.mBuckets[0], printWriter);
    }

    protected void calculateAverages(boolean bl) {
        super.calculateAverages(bl);
        if (bl || (this.mStatistics.mNumOfCheckouts + this.mStatistics.mNumOfCheckins) % (long)100 == 0L) {
            int n = this.mPool.getReferencingSessionCount();
            ++this.mAvgCounter;
            this.mStatistics.mAvgNumOfSessionsReferencingState = (this.mAvgNumOfSessionsReferencingStateAccum += n) / this.mAvgCounter;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

