/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import oracle.jbo.JboException;
import oracle.jbo.common.JboObjectInputStream;
import oracle.jbo.common.JboObjectOutputStream;
import oracle.jbo.common.ObjectMarshaller;
import oracle.jbo.common.PiggybackInputStream;
import oracle.jbo.common.PiggybackObjectOutputStream;
import oracle.jbo.common.SvcMsgRequest;

public class SvcMethodRequest
extends SvcMsgRequest
implements Serializable {
    private Object mTarget;
    private String[] mArgTypeNames;
    private Object[] mArgs;
    private byte[] mSerializedArgs;
    private boolean mCustomSerialized;

    private /* synthetic */ void $init$() {
        this.mSerializedArgs = null;
        this.mCustomSerialized = false;
    }

    public SvcMethodRequest(String string, String[] stringArray, Object[] objectArray) {
        this(null, string, stringArray, objectArray);
    }

    public SvcMethodRequest(Object object, String string, String[] stringArray, Object[] objectArray) {
        super(173, -1, string);
        this.$init$();
        this.mTarget = object;
        this.mArgTypeNames = stringArray;
        this.mArgs = objectArray;
    }

    public String getMethodName() {
        return this.getName();
    }

    public Object getTarget() {
        return this.mTarget;
    }

    public String[] getMethodArgTypeNames() {
        return this.mArgTypeNames;
    }

    public Object[] getMethodArgs() {
        return this.mArgs;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Object[] objectArray = null;
        objectOutputStream.writeObject(this.mTarget);
        objectOutputStream.writeObject(this.mArgTypeNames);
        if (objectOutputStream instanceof PiggybackObjectOutputStream && ((PiggybackObjectOutputStream)objectOutputStream).getMarshaller() != null) {
            this.marshal(((PiggybackObjectOutputStream)objectOutputStream).getMarshaller());
        }
        objectArray = this.mCustomSerialized ? this.mSerializedArgs : (Object[])this.mArgs;
        objectOutputStream.writeBoolean(this.mCustomSerialized);
        objectOutputStream.writeObject(objectArray);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.mTarget = objectInputStream.readObject();
        this.mArgTypeNames = (String[])objectInputStream.readObject();
        this.mCustomSerialized = objectInputStream.readBoolean();
        if (this.mCustomSerialized) {
            if (!(objectInputStream instanceof PiggybackInputStream)) {
                throw new IOException();
            }
            this.mSerializedArgs = (byte[])objectInputStream.readObject();
            this.unMarshal(((PiggybackInputStream)objectInputStream).getMarshaller());
        } else {
            this.mArgs = (Object[])objectInputStream.readObject();
        }
    }

    public void marshal(ObjectMarshaller objectMarshaller) {
        if (this.mSerializedArgs == null && this.mArgs != null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                JboObjectOutputStream jboObjectOutputStream = new JboObjectOutputStream(byteArrayOutputStream, objectMarshaller);
                jboObjectOutputStream.writeObject(this.mArgs);
                jboObjectOutputStream.flush();
                byteArrayOutputStream.flush();
                this.mSerializedArgs = byteArrayOutputStream.toByteArray();
                this.mCustomSerialized = true;
            }
            catch (IOException iOException) {
                throw new JboException(iOException);
            }
        }
    }

    public void unMarshal(ObjectMarshaller objectMarshaller) {
        if (this.mSerializedArgs != null) {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.mSerializedArgs);
                JboObjectInputStream jboObjectInputStream = new JboObjectInputStream(byteArrayInputStream, objectMarshaller);
                this.mArgs = (Object[])jboObjectInputStream.readObject();
                this.mSerializedArgs = null;
            }
            catch (IOException iOException) {
                throw new JboException(iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new JboException(classNotFoundException);
            }
        }
    }
}

