/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import com.sun.java.util.collections.HashMap;
import oracle.jbo.common.Diagnostic;
import sun.io.CharacterEncoding;

public class CharacterEncodingMapping {
    static HashMap mJdkToIanaMap = new HashMap(80);

    private CharacterEncodingMapping() {
    }

    public static String convertIanaToJdk(String string) {
        String string2;
        block0: {
            string2 = CharacterEncoding.aliasName((String)string);
            if (string2 != null || !Diagnostic.isOn()) break block0;
            Diagnostic.println("WARNING: could not translate IANA: '" + string + "'");
        }
        return string2;
    }

    public static String convertJdkToIana(String string) {
        String string2 = (String)mJdkToIanaMap.get((Object)string);
        if (string2 == null) {
            if (Diagnostic.isOn()) {
                Diagnostic.println("WARNING: could not translate JDK: '" + string + "'");
            }
        } else {
            int n = string2.indexOf(42);
            if (n != -1) {
                string2 = string2.substring(0, string2.length() - 1);
                if (Diagnostic.isOn()) {
                    Diagnostic.println("WARNING: IANA name '" + string2 + "' may not be supported by this JDK");
                }
            }
        }
        return string2;
    }

    static {
        mJdkToIanaMap.put((Object)"Cp280", (Object)"CP280");
        mJdkToIanaMap.put((Object)"Cp500", (Object)"CP500");
        mJdkToIanaMap.put((Object)"Cp775", (Object)"CP775");
        mJdkToIanaMap.put((Object)"JIS", (Object)"ISO-2022-JP");
        mJdkToIanaMap.put((Object)"Cp278", (Object)"CP278");
        mJdkToIanaMap.put((Object)"Cp277", (Object)"IBM277");
        mJdkToIanaMap.put((Object)"Cp273", (Object)"CP273");
        mJdkToIanaMap.put((Object)"MS950", (Object)"BIG5");
        mJdkToIanaMap.put((Object)"8859_9", (Object)"ISO-8859-9");
        mJdkToIanaMap.put((Object)"8859_8", (Object)"ISO-8859-8");
        mJdkToIanaMap.put((Object)"Cp437", (Object)"CP437");
        mJdkToIanaMap.put((Object)"8859_7", (Object)"ISO-8859-7");
        mJdkToIanaMap.put((Object)"8859_6", (Object)"ISO-8859-6");
        mJdkToIanaMap.put((Object)"8859_5", (Object)"ISO-8859-5");
        mJdkToIanaMap.put((Object)"ISO2022CN", (Object)"ISO-2022-CN*");
        mJdkToIanaMap.put((Object)"UTF8", (Object)"UTF-8");
        mJdkToIanaMap.put((Object)"8859_4", (Object)"ISO-8859-4");
        mJdkToIanaMap.put((Object)"Big5", (Object)"BIG5");
        mJdkToIanaMap.put((Object)"8859_3", (Object)"ISO-8859-3");
        mJdkToIanaMap.put((Object)"8859_2", (Object)"ISO-8859-2");
        mJdkToIanaMap.put((Object)"8859_1", (Object)"ISO-8859-1");
        mJdkToIanaMap.put((Object)"ISO8859-1", (Object)"ISO-8859-1");
        mJdkToIanaMap.put((Object)"ISO-8859-1", (Object)"ISO-8859-1");
        mJdkToIanaMap.put((Object)"646", (Object)"ISO-8859-1");
        mJdkToIanaMap.put((Object)"EUC_KR", (Object)"EUC-KR");
        mJdkToIanaMap.put((Object)"Cp871", (Object)"CP871");
        mJdkToIanaMap.put((Object)"MS949", (Object)"EUC-KR");
        mJdkToIanaMap.put((Object)"Cp870", (Object)"CP870");
        mJdkToIanaMap.put((Object)"ISO8859_9", (Object)"ISO-8859-9");
        mJdkToIanaMap.put((Object)"KOI8_R", (Object)"KOI8-R");
        mJdkToIanaMap.put((Object)"ISO8859_8", (Object)"ISO-8859-8");
        mJdkToIanaMap.put((Object)"ISO8859_7", (Object)"ISO-8859-7");
        mJdkToIanaMap.put((Object)"ISO8859_6", (Object)"ISO-8859-6");
        mJdkToIanaMap.put((Object)"Cp869", (Object)"CP869");
        mJdkToIanaMap.put((Object)"Cp424", (Object)"CP424");
        mJdkToIanaMap.put((Object)"ISO8859_5", (Object)"ISO-8859-5");
        mJdkToIanaMap.put((Object)"Cp868", (Object)"CP868");
        mJdkToIanaMap.put((Object)"ISO8859_4", (Object)"ISO-8859-4");
        mJdkToIanaMap.put((Object)"ISO8859_3", (Object)"ISO-8859-3");
        mJdkToIanaMap.put((Object)"Cp866", (Object)"CP866");
        mJdkToIanaMap.put((Object)"ASCII", (Object)"US-ASCII");
        mJdkToIanaMap.put((Object)"ISO8859_2", (Object)"ISO8859-2");
        mJdkToIanaMap.put((Object)"Cp865", (Object)"CP865");
        mJdkToIanaMap.put((Object)"Cp420", (Object)"CP420");
        mJdkToIanaMap.put((Object)"ISO8859_1", (Object)"ISO-8859-1");
        mJdkToIanaMap.put((Object)"Cp864", (Object)"CP864");
        mJdkToIanaMap.put((Object)"Cp863", (Object)"CP863");
        mJdkToIanaMap.put((Object)"EUC_JP", (Object)"EUC-JP");
        mJdkToIanaMap.put((Object)"Cp862", (Object)"CP862");
        mJdkToIanaMap.put((Object)"Cp861", (Object)"CP861");
        mJdkToIanaMap.put((Object)"Cp860", (Object)"CP860");
        mJdkToIanaMap.put((Object)"Cp037", (Object)"CP037");
        mJdkToIanaMap.put((Object)"MS932", (Object)"SHIFT_JIS");
        mJdkToIanaMap.put((Object)"Cp918", (Object)"CP918");
        mJdkToIanaMap.put((Object)"MS874", (Object)"WINDOWS-874");
        mJdkToIanaMap.put((Object)"EUC_TW", (Object)"EUC-TW");
        mJdkToIanaMap.put((Object)"Cp857", (Object)"CP857");
        mJdkToIanaMap.put((Object)"Cp855", (Object)"CP855");
        mJdkToIanaMap.put((Object)"Cp852", (Object)"CP852");
        mJdkToIanaMap.put((Object)"EUCJIS", (Object)"EUC-JP");
        mJdkToIanaMap.put((Object)"Cp850", (Object)"CP850");
        mJdkToIanaMap.put((Object)"Cp1258", (Object)"WINDOWS-1258");
        mJdkToIanaMap.put((Object)"Cp1257", (Object)"WINDOWS-1257");
        mJdkToIanaMap.put((Object)"SJIS", (Object)"SHIFT_JIS");
        mJdkToIanaMap.put((Object)"Cp1256", (Object)"WINDOWS-1256");
        mJdkToIanaMap.put((Object)"KSC5601", (Object)"EUC-KR");
        mJdkToIanaMap.put((Object)"Cp1255", (Object)"WINDOWS-1255");
        mJdkToIanaMap.put((Object)"Cp1254", (Object)"WINDOWS-1254");
        mJdkToIanaMap.put((Object)"Cp1253", (Object)"WINDOWS-1253");
        mJdkToIanaMap.put((Object)"Cp1252", (Object)"WINDOWS-1252");
        mJdkToIanaMap.put((Object)"Cp1251", (Object)"WINDOWS-1251");
        mJdkToIanaMap.put((Object)"Cp1250", (Object)"WINDOWS-1250");
        mJdkToIanaMap.put((Object)"Cp297", (Object)"CP297");
        mJdkToIanaMap.put((Object)"ISO2022KR", (Object)"ISO-2022-KR*");
        mJdkToIanaMap.put((Object)"EUC_CN", (Object)"EUC-CN");
        mJdkToIanaMap.put((Object)"GBK", (Object)"GBK*");
        mJdkToIanaMap.put((Object)"Cp1026", (Object)"CP1026");
        mJdkToIanaMap.put((Object)"ISO2022JP", (Object)"ISO-2022-JP");
        mJdkToIanaMap.put((Object)"Cp285", (Object)"CP285");
        mJdkToIanaMap.put((Object)"Cp284", (Object)"CP284");
    }
}

