/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo;

import com.sun.java.util.collections.ArrayList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Locale;
import oracle.jbo.ApplicationModule;
import oracle.jbo.JboWarning;
import oracle.jbo.LocaleContext;
import oracle.jbo.ViewObject;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JBOClass;
import oracle.jbo.common.JboEnvUtil;
import oracle.jbo.common.JboExHelperLocalized;
import oracle.jbo.common.JboExceptionHelper;
import oracle.jbo.common.JboMessage;
import oracle.jbo.common.MetaObjectBase;
import oracle.jbo.common.ObjectTypeHelper;
import oracle.jbo.common.PiggybackClsCheckWrapper;
import oracle.jbo.common.PiggybackObjectOutputStream;
import oracle.jbo.common.PropertyManager;

public class JboException
extends RuntimeException
implements JboMessage,
MetaObjectBase,
Serializable {
    static final long serialVersionUID = -9085642209876674883L;
    JboExceptionHelper mHelper;
    boolean mNeedsEntityToVOMapping;
    protected boolean mHasPeerException;
    private Object mSource;
    private static final String JBO_PRODUCT_CODE = "JBO";
    private static /* synthetic */ Class class$java$sql$SQLException;
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;

    private /* synthetic */ void $init$() {
        this.mHelper = null;
        this.mNeedsEntityToVOMapping = true;
        this.mHasPeerException = false;
    }

    public JboException(String string, String string2, Object[] objectArray) {
        this.$init$();
        this.mHelper = new JboExceptionHelper(this, string, string2, objectArray);
    }

    public JboException(String string) {
        this(string, "", null);
    }

    public JboException(Throwable throwable) {
        Class clazz = class$oracle$jbo$CSMessageBundle;
        if (clazz == null) {
            clazz = class$oracle$jbo$CSMessageBundle = JboException.class$("oracle.jbo.CSMessageBundle");
        }
        this(clazz, "29000", new Object[]{throwable.getClass().getName(), throwable.getMessage()});
        this.addToDetails(throwable);
    }

    public JboException(Class clazz, String string, Object[] objectArray) {
        this.$init$();
        this.mHelper = new JboExHelperLocalized((JboMessage)this, clazz, string, objectArray);
    }

    public JboException(Class clazz, String string, Object[] objectArray, JboException[] jboExceptionArray) {
        this.$init$();
        this.mHelper = new JboExHelperLocalized((JboMessage)this, clazz, string, objectArray);
        this.setDetails(jboExceptionArray);
    }

    public JboException(Class clazz, String string, Object[] objectArray, Exception[] exceptionArray) {
        this.$init$();
        this.mHelper = new JboExHelperLocalized((JboMessage)this, clazz, string, objectArray);
        this.mHasPeerException = true;
        this.setDetails(exceptionArray);
    }

    public final boolean hasPeerExceptions() {
        return this.mHasPeerException;
    }

    public String getMessage() {
        return this.mHelper.getMessage();
    }

    public String getLocalizedMessage(Locale locale) {
        return this.mHelper.getLocalizedMessage(locale);
    }

    public String getBaseMessage() {
        return this.mHelper.getBaseMessage();
    }

    public Class getResourceClass() {
        return this.mHelper.getResourceClass();
    }

    public String getLocalizedBaseMessage(Locale locale) {
        return this.mHelper.getLocalizedBaseMessage(locale);
    }

    public String getResourceName() {
        return this.mHelper.getResourceName();
    }

    public Object[] getErrorParameters() {
        return this.mHelper.getErrorParameters();
    }

    protected void setErrorParameters(Object[] objectArray) {
        this.mHelper.setErrorParameters(objectArray);
    }

    public String getErrorCode() {
        return this.mHelper.getErrorCode();
    }

    public String getProductCode() {
        return JBO_PRODUCT_CODE;
    }

    public Object[] getDetails() {
        return this.mHelper.getDetails();
    }

    public Throwable[] getExceptions() {
        ArrayList arrayList = this.mHelper.getDetailsList();
        return arrayList != null ? (Throwable[])arrayList.toArray((Object[])new Throwable[arrayList.size()]) : null;
    }

    public String getDetailMessage() {
        return this.mHelper.getDetailMessage();
    }

    public void setDetails(Object[] objectArray) {
        if (objectArray != null && !(objectArray instanceof Throwable[])) {
            int n = objectArray.length;
            --n;
            while (n >= 0) {
                if (!(objectArray[n] instanceof Throwable)) {
                    Diagnostic.println("WARNING! Details of an exception should always be instances of java.lang.Throwable.");
                }
                --n;
            }
        }
        if (!PropertyManager.is323Compatible()) {
            this.mHelper.setDetails(objectArray);
        } else if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                this.mHelper.addToDetails(objectArray[n]);
                ++n;
            }
        }
    }

    public void setExceptions(Throwable[] throwableArray) {
        this.mHelper.setDetails(throwableArray);
    }

    public void addToDetails(Object object) {
        if (!(object instanceof Throwable)) {
            Diagnostic.println("WARNING! Details of an exception should always be instances of java.lang.Throwable.");
        }
        this.mHelper.addToDetails(object);
    }

    public void addToExceptions(Throwable throwable) {
        this.mHelper.addToDetails(throwable);
    }

    public boolean isLocalizable() {
        return this.mHelper instanceof JboExHelperLocalized;
    }

    protected JboExceptionHelper getJboExceptionHelper() {
        return this.mHelper;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n;
        Object[] objectArray;
        Method method;
        block16: {
            objectOutputStream.writeBoolean(this.isAppendCodes());
            objectOutputStream.writeBoolean(this.mNeedsEntityToVOMapping);
            objectOutputStream.writeBoolean(this.mHasPeerException);
            Locale locale = null;
            ApplicationModule applicationModule = null;
            method = null;
            if (objectOutputStream instanceof PiggybackObjectOutputStream) {
                locale = ((PiggybackObjectOutputStream)objectOutputStream).getLocale();
                applicationModule = ((PiggybackObjectOutputStream)objectOutputStream).getApplicationModule();
                this.setApplicationModule(applicationModule);
            }
            String string = this.getLocalizedBaseMessage(locale);
            String string2 = this.getErrorCode();
            Object[] objectArray2 = this.getErrorParameters();
            objectArray = this.getDetails();
            objectOutputStream.writeUTF(string);
            objectOutputStream.writeUTF(string2);
            objectOutputStream.writeInt(objectArray2.length);
            n = 0;
            while (n < objectArray2.length) {
                objectOutputStream.writeObject(objectArray2[n]);
                ++n;
            }
            objectOutputStream.writeInt(objectArray.length);
            if (JboEnvUtil.inJServer()) {
                try {
                    Class clazz = JBOClass.forName("oracle.jbo.server.util.SQLExceptionConverter");
                    Class[] classArray = new Class[1];
                    Class clazz2 = class$java$sql$SQLException;
                    if (clazz2 == null) {
                        clazz2 = class$java$sql$SQLException = JboException.class$("java.sql.SQLException");
                    }
                    classArray[0] = clazz2;
                    method = clazz.getMethod("convertOracleExceptionToSQLException", classArray);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (Diagnostic.isOn()) {
                        Diagnostic.printStackTrace(classNotFoundException);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (!Diagnostic.isOn()) break block16;
                    Diagnostic.printStackTrace(noSuchMethodException);
                }
            }
        }
        n = 0;
        while (n < objectArray.length) {
            Object object;
            block17: {
                object = objectArray[n];
                if (method != null && object instanceof SQLException) {
                    try {
                        object = method.invoke(null, object);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        if (Diagnostic.isOn()) {
                            Diagnostic.printStackTrace(invocationTargetException.getTargetException());
                        }
                    }
                    catch (Exception exception) {
                        if (!Diagnostic.isOn()) break block17;
                        Diagnostic.printStackTrace(exception);
                    }
                }
            }
            if (object instanceof JboException || object instanceof JboWarning) {
                objectOutputStream.writeObject(object);
            } else {
                objectOutputStream.writeObject(new PiggybackClsCheckWrapper(object));
            }
            ++n;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        boolean bl = objectInputStream.readBoolean();
        this.mNeedsEntityToVOMapping = objectInputStream.readBoolean();
        this.mHasPeerException = objectInputStream.readBoolean();
        String string = objectInputStream.readUTF();
        String string2 = objectInputStream.readUTF();
        Object[] objectArray = new Object[objectInputStream.readInt()];
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n] = objectInputStream.readObject();
            ++n;
        }
        Object[] objectArray2 = new Object[objectInputStream.readInt()];
        n = 0;
        while (n < objectArray2.length) {
            Object object = objectInputStream.readObject();
            if (object instanceof PiggybackClsCheckWrapper) {
                try {
                    object = ((PiggybackClsCheckWrapper)object).getInnerObject();
                }
                catch (Exception exception) {
                    object = exception;
                }
            }
            objectArray2[n] = object;
            ++n;
        }
        this.mHelper = new JboExceptionHelper(this, string, string2, objectArray);
        this.mHelper.setAppendCodes(bl);
        this.setDetails(objectArray2);
    }

    public static String getTypeNameFromId(int n) {
        return ObjectTypeHelper.getTypeNameFromId(n);
    }

    public void setApplicationModule(ApplicationModule applicationModule) {
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream printStream) {
        this.printStackTrace(new PrintWriter(printStream));
    }

    public void printStackTrace(PrintWriter printWriter) {
        super.printStackTrace(printWriter);
        Object[] objectArray = this.getDetails();
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof Throwable) {
                printWriter.println("## Detail " + n + " ##");
                ((Throwable)objectArray[n]).printStackTrace(printWriter);
            }
            ++n;
        }
        printWriter.flush();
    }

    public final void setNeedsEntityToVOMapping(boolean bl) {
        if (this.mNeedsEntityToVOMapping != bl) {
            this.mNeedsEntityToVOMapping = bl;
        }
    }

    public final boolean needsEntityToVOMapping() {
        return this.mNeedsEntityToVOMapping;
    }

    public void doEntityToVOMapping(ApplicationModule applicationModule, ViewObject[] viewObjectArray) {
        Object[] objectArray = this.getDetails();
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof JboException) {
                ((JboException)objectArray[n]).doEntityToVOMapping(applicationModule, viewObjectArray);
            }
            ++n;
        }
        this.mNeedsEntityToVOMapping = false;
    }

    public boolean isAppendCodes() {
        return this.mHelper.isAppendCodes();
    }

    public void setAppendCodes(boolean bl) {
        this.mHelper.setAppendCodes(bl);
    }

    public void setSource(Object object) {
        this.mSource = object;
    }

    public Object getSource() {
        return this.mSource;
    }

    public boolean containsException(Throwable throwable) {
        ArrayList arrayList = this.mHelper.getDetailsList();
        if (arrayList != null) {
            int n = 0;
            while (n < arrayList.size()) {
                Object object = arrayList.get(n);
                if (object == throwable) {
                    return true;
                }
                if (object instanceof JboException && ((JboException)object).containsException(throwable)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public void setLocaleContext(LocaleContext localeContext) {
        this.mHelper.setLocaleContext(localeContext);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

