/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.GraphicsUtils;

public abstract class ArrayResourceBundle
extends ResourceBundle {
    private static final String nullString = "(null)";
    private static final HashMap iconCache = new HashMap(500);

    public final String[] getStringArray(int n) {
        return (String[])this.getObject(n);
    }

    public final Object getObject(int n) {
        return this.getObjectImpl(n);
    }

    public final String getStringImpl(int n) {
        return this.getObjectImpl(n).toString();
    }

    public final char getCharImpl(int n) {
        Character c = (Character)this.getObjectImpl(n);
        return c.charValue();
    }

    public final Font getFontImpl(int n) {
        return (Font)this.getObjectImpl(n);
    }

    public final KeyStroke getAcceleratorImpl(int n) {
        String string = this.getStringImpl(n);
        if (string != null && string.length() > 0) {
            return KeyStroke.getKeyStroke(string);
        }
        return null;
    }

    public final Integer getIntegerImpl(int n) {
        String string = this.getStringImpl(n);
        if (string.length() == 1 && Character.isLetter(string.charAt(0))) {
            return new Integer(string.charAt(0));
        }
        return Integer.valueOf(string);
    }

    public final char getMnemonicImpl(int n) {
        int n2;
        String string = this.getStringImpl(n);
        int n3 = n2 = string != null ? string.length() : 0;
        if (n2 == 1) {
            return string.charAt(0);
        }
        return (char)StringUtils.getMnemonicKeyCode((String)string);
    }

    public final Icon getIconImpl(int n) {
        return this.getImageIconImpl(n, true);
    }

    public final Icon getUncachedIconImpl(int n) {
        return this.getImageIconImpl(n, false);
    }

    public final Image getImageImpl(int n) {
        ImageIcon imageIcon = this.getImageIconImpl(n, true);
        return imageIcon != null ? imageIcon.getImage() : null;
    }

    public final Image getUncachedImageImpl(int n) {
        ImageIcon imageIcon = this.getImageIconImpl(n, false);
        return imageIcon != null ? imageIcon.getImage() : null;
    }

    public final Object getObjectImpl(int n) {
        Object[] objectArray = this.getContents();
        if (n < objectArray.length) {
            return objectArray[n];
        }
        if (this.parent == null) {
            throw new MissingResourceException("Can't find resource", this.getClass().getName(), String.valueOf(n));
        }
        if (this.parent instanceof ArrayResourceBundle) {
            return ((ArrayResourceBundle)this.parent).getObjectImpl(n);
        }
        return this.parent.getObject(String.valueOf(n));
    }

    public final String formatImpl(int n, Object[] objectArray) {
        int n2;
        int n3 = n2 = objectArray == null ? 0 : objectArray.length;
        if (n2 == 0) {
            return this.getStringImpl(n);
        }
        int n4 = 0;
        while (n4 < n2) {
            if (objectArray[n4] == null) {
                objectArray[n4] = nullString;
            }
            ++n4;
        }
        String string = this.formatImplNoCheck(n, objectArray);
        int n5 = 0;
        while (n5 < n2) {
            if (objectArray[n5] == nullString) {
                objectArray[n5] = null;
            }
            ++n5;
        }
        return string;
    }

    public final String formatImpl(int n, Object object) {
        return this.formatImpl(n, new Object[]{object});
    }

    public final String formatImpl(int n, Object object, Object object2) {
        return this.formatImpl(n, new Object[]{object, object2});
    }

    public final String formatImpl(int n, Object object, Object object2, Object object3) {
        return this.formatImpl(n, new Object[]{object, object2, object3});
    }

    private String formatImplNoCheck(int n, Object[] objectArray) {
        String string = this.getStringImpl(n);
        return MessageFormat.format(string, objectArray);
    }

    protected final ImageIcon getImageIconImpl(int n, boolean bl) {
        Image image;
        String string = this.getStringImpl(n);
        if (string == null || string.length() == 0) {
            return null;
        }
        Class<?> clazz = this.getClass();
        String string2 = clazz.getName();
        IconKey iconKey = new IconKey(string2, n);
        HashMap hashMap = iconCache;
        synchronized (hashMap) {
            block9: {
                try {
                    Object v = iconCache.get(iconKey);
                    if (v == null) break block9;
                    ImageIcon imageIcon = (ImageIcon)v;
                    Object var11_10 = null;
                    return imageIcon;
                }
                catch (Throwable throwable) {
                    Object var11_12 = null;
                    throw throwable;
                }
            }
            Object var11_11 = null;
            {
            }
        }
        URL uRL = clazz.getResource(string);
        ImageIcon imageIcon = null;
        if (uRL != null && (image = Toolkit.getDefaultToolkit().createImage(uRL)) != null) {
            imageIcon = GraphicsUtils.createImageIcon((Image)image);
            if (bl) {
                HashMap hashMap2 = iconCache;
                synchronized (hashMap2) {
                    try {
                        iconCache.put(iconKey, imageIcon);
                        Object var17_18 = null;
                    }
                    catch (Throwable throwable) {
                        Object var17_19 = null;
                        throw throwable;
                    }
                }
            }
        }
        return imageIcon;
    }

    protected abstract Object[] getContents();

    public final Enumeration getKeys() {
        Object[] objectArray = this.getContents();
        List<Object> list = Arrays.asList(objectArray);
        return Collections.enumeration(list);
    }

    protected final Object handleGetObject(String string) {
        return this.getObject(Integer.parseInt(string));
    }
}

