/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.security.credentialstore.spi;

import java.io.Serializable;
import java.util.Hashtable;
import javax.naming.Context;
import oracle.adf.share.ADFContext;
import oracle.adf.share.security.ADFSecurityRuntimeException;
import oracle.adf.share.security.SecurityEnv;
import oracle.adf.share.security.credentialstore.Credential;
import oracle.adf.share.security.credentialstore.spi.CredentialStorage;
import oracle.adf.share.security.resource.ADFSecurityMessageBundle;

public abstract class GenericCredentialStore
implements CredentialStorage {
    private static String _applicationUser = null;
    private boolean isApplicationUserSupported;
    private Context _secCtx;

    private /* synthetic */ void $init$() {
        this.isApplicationUserSupported = true;
        this._secCtx = null;
    }

    public abstract void initialize(Hashtable var1);

    public abstract void storeCredential(Credential var1, String var2);

    public abstract Credential fetchCredential(String var1);

    public abstract Serializable fetchSerializableCredential(String var1);

    public Serializable fetchSerializableCredentialForCurrentUser(String string) {
        throw new ADFSecurityRuntimeException(ADFSecurityMessageBundle.getString("80108"));
    }

    public abstract void removeCredential(String var1);

    public String getApplicationUserName() {
        if (_applicationUser == null && this.isApplicationUserSupported) {
            try {
                _applicationUser = System.getProperty("oracle.adf.security.credentialstore.default.user");
                if (_applicationUser == null) {
                    String string = this.getConfigCredentialStoreUser();
                    _applicationUser = string != null && string.length() > 0 ? string : SecurityEnv.CREDENTIAL_STORE_USER_DEFAULT;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return _applicationUser;
    }

    String getConfigCredentialStoreUser() {
        String string = null;
        try {
            string = (String)this.getSecurityContext().getEnvironment().get("oracle.adf.security.credentialstore.default.user");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    Context getSecurityContext() {
        if (this._secCtx == null) {
            try {
                this._secCtx = ADFContext.getCurrent().getSecurityContext();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this._secCtx;
    }

    public GenericCredentialStore() {
        this.$init$();
    }
}

