/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.security.authentication;

import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import javax.security.auth.Subject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import oracle.adf.share.ADFContext;
import oracle.adf.share.security.ADFSecurityUtil;
import oracle.adf.share.security.SecurityContext;
import oracle.adf.share.security.authentication.ADFRolePrincipal;
import oracle.adf.share.security.authentication.ADFUserPrincipal;

public class AuthenticationFilter
implements Filter {
    private FilterConfig _filterConfig;
    private static final String PARAM_KEY_SERVLET_NAME = "auth_servlet";
    private String DEFAULT_SERVLET_NAME;
    private String _authServletName;

    private /* synthetic */ void $init$() {
        this.DEFAULT_SERVLET_NAME = "adfAuthentication";
        this._authServletName = null;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this._filterConfig = filterConfig;
        this._authServletName = this._filterConfig.getInitParameter(PARAM_KEY_SERVLET_NAME);
        if (this._authServletName == null) {
            this._authServletName = this.DEFAULT_SERVLET_NAME;
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (servletRequest instanceof HttpServletRequest) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
            this.handleAuthentication(httpServletRequest, httpServletResponse, filterChain);
        }
    }

    private void handleAuthentication(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        HttpSession httpSession = httpServletRequest.getSession();
        Principal principal = httpServletRequest.getUserPrincipal();
        if (principal == null) {
            SecurityContext securityContext = ADFContext.getCurrent().getSecurityContext();
            if (securityContext.isAnyoneEnabled()) {
                this.addADFRoleToSubject();
            }
            boolean bl = false;
            try {
                String string = (String)securityContext.getEnvironment().get("jaas.permissioncheck");
                if (string != null && string.equals("true")) {
                    bl = true;
                }
                if (!bl && !(bl = securityContext.isAuthorizationEnabled())) {
                    string = (String)securityContext.getEnvironment().get("oracle.adf.security.authentication.require");
                    bl = string == null || !string.equals("false");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bl) {
                String string = this._authServletName;
                boolean bl2 = true;
                if (bl2) {
                    httpSession.setAttribute("success_url", (Object)httpServletRequest.getRequestURI());
                    String string2 = httpServletResponse.encodeRedirectURL(httpServletRequest.getContextPath() + "/" + string);
                    httpServletResponse.sendRedirect(string2);
                }
            }
        }
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    public void destroy() {
    }

    public void addADFRoleToSubject() {
        AccessControlContext accessControlContext = AccessController.getContext();
        Subject subject = Subject.getSubject(accessControlContext);
        if (subject != null && !ADFSecurityUtil.hasAnyoneRole(subject)) {
            ADFUserPrincipal aDFUserPrincipal = new ADFUserPrincipal("anonymous");
            subject.getPrincipals().add(aDFUserPrincipal);
            ADFRolePrincipal aDFRolePrincipal = new ADFRolePrincipal("anyone");
            aDFRolePrincipal.addUserGrantee(aDFUserPrincipal);
            subject.getPrincipals().add(aDFRolePrincipal);
        }
    }

    public AuthenticationFilter() {
        this.$init$();
    }
}

