/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.perf.analysis;

import java.io.PrintStream;
import oracle.adf.share.perf.analysis.Analyzer;
import oracle.adf.share.perf.analysis.SensorResult;

class StateResult
extends SensorResult {
    StateResult(int n) {
        this.mNameIndex = n;
    }

    void print(PrintStream printStream, boolean bl, String string) {
        String string2 = (String)Analyzer.sSensorNames.get(this.mNameIndex);
        if (Analyzer.sFormatXml) {
            int n = string2.lastIndexOf(47);
            String string3 = string2.substring(n + 1);
            String string4 = string2.substring(0, n);
            printStream.print("State: (");
            if (bl) {
                printStream.print(" gap=" + StateResult.prependSpace(SensorResult.sDblFmt.format((double)this.mGap / (double)this.mHit), 6) + " |");
            }
            printStream.print(" hit=" + StateResult.prependSpace(SensorResult.sIntFmt.format(this.mHit), 6));
            printStream.print(" | state=" + Analyzer.htmlEncode(this.mValue));
            printStream.print(" )");
            printStream.println(" " + string3 + " [" + string4 + "]");
        } else {
            printStream.println(string + "State:" + string2 + " [id=" + this.mNameIndex + "]");
            printStream.print(string + "(");
            if (bl) {
                printStream.print(" gap=" + StateResult.prependSpace(SensorResult.sDblFmt.format((double)this.mGap / (double)this.mHit), 6) + " |");
            }
            printStream.print(" hit=" + StateResult.prependSpace(SensorResult.sIntFmt.format(this.mHit), 6));
            printStream.print(" | state=" + this.mValue);
            if (Analyzer.sDebug) {
                printStream.print(" | ts=" + StateResult.prependSpace(SensorResult.sIntFmt.format(this.mTimeStamp), 6));
            }
            printStream.println(" )");
            printStream.println("");
        }
    }
}

