/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.jndi;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import oracle.adf.share.jndi.ContextImpl;
import oracle.adf.share.jndi.xml.ReferenceType;
import oracle.adf.share.jndi.xml.References;

class NameClassEnumerator
implements NamingEnumeration {
    protected Iterator mRefIterator;
    protected ContextImpl mCtx;

    NameClassEnumerator(ContextImpl contextImpl) {
        this.mCtx = contextImpl;
    }

    public boolean hasMoreElements() {
        try {
            boolean bl = this.hasMore();
            return bl;
        }
        catch (NamingException namingException) {
            boolean bl = false;
            return bl;
        }
    }

    public boolean hasMore() throws NamingException {
        this.ensureIterator();
        return this.mRefIterator.hasNext();
    }

    public Object next() throws NamingException {
        ReferenceType referenceType = this.nextRefType();
        if (referenceType != null) {
            return new NameClassPair(referenceType.getName(), referenceType.getClassName());
        }
        return null;
    }

    public Object nextElement() {
        try {
            Object object = this.next();
            return object;
        }
        catch (NamingException namingException) {
            throw new NoSuchElementException(namingException.toString());
        }
    }

    public void close() {
        this.mRefIterator = null;
    }

    void ensureIterator() {
        if (this.mRefIterator == null) {
            References references = this.mCtx.getReferenceStoreHelper().getReferences();
            this.mRefIterator = references.getReference().iterator();
        }
    }

    ReferenceType nextRefType() {
        this.ensureIterator();
        return (ReferenceType)this.mRefIterator.next();
    }

    ContextImpl getOwningContext() {
        return this.mCtx;
    }
}

