/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.jbotester.load;

import com.sun.java.util.collections.ArrayList;
import java.util.TimerTask;
import oracle.jbo.common.ampool.ApplicationPool;
import oracle.jbo.common.ampool.SessionCookie;
import oracle.jbo.jbotester.load.Controller;
import oracle.jbo.jbotester.load.StateChangeListener;
import oracle.jbo.jbotester.load.StateChangedEvent;
import oracle.jbo.jbotester.load.Task;
import oracle.jbo.jbotester.load.TaskThreadPool;
import oracle.jbo.jbotester.load.TaskThreadPoolManager;

public class Session {
    private SessionCookie mSessionCookie;
    private Task mTask;
    private int mIterationCounter;
    private final String mApplicationId;
    private final String mSessionId;
    private final Controller mController;
    private final ArrayList mSessionStateListeners;
    private Object mLock;
    public static final int STATE_NEW = 0;
    public static final int STATE_INITIALIZED = 1;
    public static final int STATE_SCHEDULED = 2;
    public static final int STATE_RUNNING = 3;
    public static final int STATE_CLOSED = 4;
    public static final int STATE_DESTROYED = 5;
    private static final String[] STATE_DESCRIPTIONS = new String[]{"STATE_NEW", "STATE INITIALIZED", "STATE_SCHEDULED", "STATE_RUNNING", "STATE_CLOSED", "STATE_DESTROYED"};
    private int mState;

    private /* synthetic */ void $init$() {
        this.mSessionStateListeners = new ArrayList();
        this.mLock = new Object();
        this.mState = 0;
    }

    Session(Controller controller, String string, String string2) {
        this.$init$();
        this.mController = controller;
        this.addSessionStateListener(this.mController);
        this.mApplicationId = string;
        this.mSessionId = string2;
        ApplicationPool applicationPool = this.mController.getApplicationPool(false);
        this.mSessionCookie = applicationPool.createSessionCookie(string, string2, null);
        this.mIterationCounter = this.mController.getNumOfIterations();
        this.transitionState(1);
        this.transitionState(2);
    }

    public String getApplicationId() {
        return this.mApplicationId;
    }

    public String getSessionId() {
        return this.mSessionId;
    }

    SessionCookie getSessionCookie() {
        return this.mSessionCookie;
    }

    void addSessionStateListener(StateChangeListener stateChangeListener) {
        this.mSessionStateListeners.add((Object)stateChangeListener);
    }

    void removeSessionStateListener(StateChangeListener stateChangeListener) {
        this.mSessionStateListeners.remove((Object)stateChangeListener);
    }

    void fireSessionStateChanged(StateChangedEvent stateChangedEvent) {
        int n = 0;
        while (n < this.mSessionStateListeners.size()) {
            ((StateChangeListener)this.mSessionStateListeners.get(n)).stateChanged(stateChangedEvent);
            ++n;
        }
    }

    private int getState() {
        return this.mState;
    }

    void transitionState(int n) {
        this.transitionState(n, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void transitionState(int n, long l) {
        int n2 = -1;
        Object object = this.mLock;
        synchronized (object) {
            n2 = this.getState();
            switch (n) {
                case 1: {
                    if (n2 == 0) break;
                    return;
                }
                case 2: {
                    if (n2 != 4 && n2 != 5) break;
                    return;
                }
                case 3: {
                    if (n2 == 2) break;
                    return;
                }
                case 4: {
                    if (n2 != 5) break;
                    return;
                }
                case 5: {
                    if (n2 == 4) break;
                    return;
                }
            }
            this.mState = n;
        }
        if (this.mController.isDebug()) {
            StringBuffer stringBuffer = new StringBuffer("Transitioned session ");
            stringBuffer.append(this.getSessionId());
            stringBuffer.append(" from state ");
            stringBuffer.append(STATE_DESCRIPTIONS[n2]);
            stringBuffer.append(" to state ");
            stringBuffer.append(STATE_DESCRIPTIONS[n]);
            System.out.println(stringBuffer.toString());
        }
        StateChangedEvent stateChangedEvent = new StateChangedEvent(this, n2, n);
        stateChangedEvent.setStateChangeInterval(l);
        this.fireSessionStateChanged(stateChangedEvent);
        switch (n) {
            case 2: {
                this.schedule(n2 == 1 ? 0 : this.mController.getThinkTime());
                break;
            }
            case 3: {
                this.runTask();
                break;
            }
            case 4: {
                this.destroy();
                break;
            }
            case 5: {
                this.mSessionStateListeners.clear();
            }
        }
    }

    private void schedule(long l) {
        int n = this.mController.schedule(new 1(), l);
        if (n != 0) {
            this.transitionState(4);
        }
    }

    private void runTask() {
        if (this.mIterationCounter != -1 && this.mIterationCounter - 1 < 0) {
            this.transitionState(4);
        } else {
            if (this.mIterationCounter != -1) {
                --this.mIterationCounter;
            }
            TaskThreadPool taskThreadPool = (TaskThreadPool)((Object)TaskThreadPoolManager.getInstance().getResourcePool("x"));
            if (this.mTask == null) {
                try {
                    String string = this.mController.getTaskClassName();
                    Class<?> clazz = Class.forName(string);
                    this.mTask = (Task)clazz.newInstance();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw new RuntimeException(exception.getMessage());
                }
                this.mTask.initialize(this);
            }
            taskThreadPool.execute(this.mTask);
        }
    }

    private void destroy() {
        ApplicationPool applicationPool = this.mController.getApplicationPool(false);
        applicationPool.removeSessionCookie(this.mSessionCookie);
        this.mSessionCookie = null;
        this.transitionState(5);
    }

    public final class 1
    extends TimerTask {
        public void run() {
            Session.this.transitionState(3);
        }
    }
}

