/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.jbotester.load;

import com.sun.java.util.collections.ArrayList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import oracle.jbo.common.ampool.ApplicationPool;
import oracle.jbo.jbotester.PoolParameterPanel;
import oracle.jbo.jbotester.load.ApplicationPoolViewPanel;
import oracle.jbo.jbotester.load.ConnectionPoolViewPanel;
import oracle.jbo.jbotester.load.Controller;
import oracle.jbo.jbotester.load.SimpleDateFormatter;
import oracle.jbo.jbotester.load.SimulationParametersPanel;
import oracle.jbo.jbotester.load.StateChangeListener;
import oracle.jbo.jbotester.load.StateChangedEvent;
import oracle.jbo.jbotester.load.Statistics;
import oracle.jbo.jbotester.load.TimeSeriesGraph;
import oracle.jbo.jbotester.load.TimeSeriesModel;
import oracle.jbo.pool.ResourcePool;
import oracle.jbo.pool.ResourcePoolManager;
import oracle.jbo.pool.ResourcePoolStatistics;
import oracle.jbo.server.ConnectionPoolManager;
import oracle.jbo.server.ConnectionPoolManagerFactory;

public class MainFrame
extends JFrame
implements ActionListener,
StateChangeListener {
    private Controller mController;
    private static long REFRESH_RATE = 500L;
    SimpleDateFormatter mDateFormatter;
    private JLabel mNumOfSessionsText;
    private JLabel mNumOfIterationsText;
    private JLabel mAvgDurationText;
    private JLabel mMessageAreaLabel;
    private JLabel mElapsedTimeLabel;
    private JButton mRunButton;
    private JButton mStopButton;
    private JButton mResetButton;
    private JMenuItem mMenuViewAMPool;
    private JMenuItem mMenuViewConnPool;
    private JMenuItem mMenuEditSimulation;
    private JMenuItem mMenuEditPool;
    private ApplicationPoolViewPanel mApplicationPoolViewPanel;
    private ConnectionPoolViewPanel mConnectionPoolViewPanel;
    private SimulationParametersPanel mSimulationParametersPanel;
    private static String SIMULATION_SUM_COMMAND = "SIMULATION_SUM_COMMAND";
    private static String AM_POOL_SUM_COMMAND = "AM_POOL_SUM_COMMAND";
    private static String CONN_POOL_SUM_COMMAND = "CONN_POOL_SUM_COMMAND";
    private Timer mTimer;
    private TimeSeriesGraph mHistoryGraph;
    private TimeSeriesModel mResponseHistoryModel;
    private TimeSeriesModel mAMPoolSizeHistoryModel;
    private TimeSeriesModel mConnPoolSizeHistoryModel;
    private boolean mUpdateRunStatistics;
    private boolean mUpdateUI;

    private /* synthetic */ void $init$() {
        this.mDateFormatter = new SimpleDateFormatter("HH:mm:ss");
        this.mNumOfSessionsText = new JLabel("0");
        this.mNumOfIterationsText = new JLabel("0");
        this.mAvgDurationText = new JLabel("0");
        this.mMessageAreaLabel = new JLabel(" ");
        this.mElapsedTimeLabel = new JLabel("00:00:00");
        this.mRunButton = new JButton("Run");
        this.mStopButton = new JButton("Stop");
        this.mResetButton = new JButton("Reset");
        this.mMenuViewAMPool = new JMenuItem();
        this.mMenuViewConnPool = new JMenuItem();
        this.mMenuEditSimulation = new JMenuItem();
        this.mMenuEditPool = new JMenuItem();
        this.mApplicationPoolViewPanel = null;
        this.mConnectionPoolViewPanel = null;
        this.mSimulationParametersPanel = null;
        this.mTimer = new Timer();
        this.mHistoryGraph = new TimeSeriesGraph();
        this.mResponseHistoryModel = new TimeSeriesModel();
        this.mAMPoolSizeHistoryModel = new TimeSeriesModel();
        this.mConnPoolSizeHistoryModel = new TimeSeriesModel();
        this.mUpdateRunStatistics = false;
        this.mUpdateUI = false;
    }

    public MainFrame() {
        super("BC4J Load Simulator");
        this.$init$();
        this.init();
    }

    void init() {
        this.mController = new Controller("mypackage1.Mypackage1Module", "Mypackage1ModuleLocal");
        this.mController.addControllerStateListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.getContentPane().setLayout(gridBagLayout);
        this.setSize(new Dimension(450, 400));
        this.addWindowListener(new 17());
        this.mHistoryGraph.setModel(this.mResponseHistoryModel, "Average Response Time History");
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints(this.mHistoryGraph, gridBagConstraints);
        this.getContentPane().add(this.mHistoryGraph);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 5, 2, 0);
        JPanel jPanel = this.buildDisplayOptionsPanel();
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.getContentPane().add(jPanel);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel = new JPanel();
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.getContentPane().add(jPanel);
        gridBagConstraints.anchor = 16;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        jPanel = this.buildButtonsBar();
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.getContentPane().add(jPanel);
        gridBagConstraints.anchor = 16;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel = this.buildStatusBar();
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.getContentPane().add(jPanel);
        this.buildMenu();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        this.setVisible(true);
        this.invalidate();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (SIMULATION_SUM_COMMAND.equals(string)) {
            this.mHistoryGraph.setModel(this.mResponseHistoryModel, "Average Response Time History");
        } else if (AM_POOL_SUM_COMMAND.equals(string)) {
            this.mHistoryGraph.setModel(this.mAMPoolSizeHistoryModel, "ApplicationPool Size History");
        } else if (CONN_POOL_SUM_COMMAND.equals(string)) {
            this.mHistoryGraph.setModel(this.mConnPoolSizeHistoryModel, "ConnectionPool Size History");
        }
    }

    public void stateChanged(StateChangedEvent stateChangedEvent) {
        String string;
        switch (stateChangedEvent.getNewState()) {
            case 5: {
                this.setUpdateUI(false);
                this.mRunButton.setEnabled(true);
                this.mResetButton.setEnabled(true);
                this.mStopButton.setEnabled(false);
                string = "Finished";
                break;
            }
            case 0: 
            case 1: {
                string = "Ready";
                break;
            }
            case 2: {
                this.setUpdateUI(true);
                this.mStopButton.setEnabled(true);
                string = "Ramping Up...";
                this.mController.schedule(new 16(), REFRESH_RATE);
                break;
            }
            case 3: {
                this.setUpdateRunStatistics(true);
                string = "Running...";
                break;
            }
            case 4: {
                this.setUpdateRunStatistics(false);
                this.mStopButton.setEnabled(false);
                string = "Ramping Down...";
                break;
            }
            case 6: {
                this.setUpdateRunStatistics(false);
                this.mStopButton.setEnabled(false);
                string = "Cancelled...";
                break;
            }
            default: {
                string = "Ready";
            }
        }
        SwingUtilities.invokeLater(new 15(this, string));
    }

    private void setUpdateRunStatistics(boolean bl) {
        this.mUpdateRunStatistics = bl;
    }

    private void setUpdateUI(boolean bl) {
        this.mUpdateUI = bl;
    }

    private void buildMenu() {
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu();
        jMenu.setText("File");
        JMenuItem jMenuItem = new JMenuItem();
        jMenuItem.setText("Exit");
        jMenuItem.addActionListener(new 14());
        jMenu.add(jMenuItem);
        JMenu jMenu2 = new JMenu();
        jMenu2.setText("Edit");
        this.mMenuEditSimulation.setText("Simulation Parameters...");
        this.mMenuEditSimulation.addActionListener(new 13());
        jMenu2.add(this.mMenuEditSimulation);
        this.mMenuEditPool.setText("Pool Parameters...");
        this.mMenuEditPool.addActionListener(new 12());
        jMenu2.add(this.mMenuEditPool);
        JMenu jMenu3 = new JMenu();
        jMenu3.setText("View");
        this.mMenuViewAMPool.setText("ApplicationPool Statistics...");
        this.mMenuViewAMPool.addActionListener(new 11());
        jMenu3.add(this.mMenuViewAMPool);
        this.mMenuViewConnPool.setText("ConnectionPool Statistics...");
        this.mMenuViewConnPool.addActionListener(new 10());
        jMenu3.add(this.mMenuViewConnPool);
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        jMenuBar.add(jMenu3);
    }

    private JPanel buildDisplayOptionsPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setBorder(BorderFactory.createTitledBorder("Display Options"));
        ButtonGroup buttonGroup = new ButtonGroup();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        JRadioButton jRadioButton = new JRadioButton("Simulation Summary", true);
        jRadioButton.setActionCommand(SIMULATION_SUM_COMMAND);
        jRadioButton.addActionListener(this);
        buttonGroup.add(jRadioButton);
        jPanel.add((Component)jRadioButton, gridBagConstraints);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jRadioButton = new JRadioButton("ApplicationPool Summary", false);
        jRadioButton.setActionCommand(AM_POOL_SUM_COMMAND);
        jRadioButton.addActionListener(this);
        buttonGroup.add(jRadioButton);
        jPanel.add((Component)jRadioButton, gridBagConstraints);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jRadioButton = new JRadioButton("ConnectionPool Summary", false);
        jRadioButton.setActionCommand(CONN_POOL_SUM_COMMAND);
        jRadioButton.addActionListener(this);
        buttonGroup.add(jRadioButton);
        jPanel.add((Component)jRadioButton, gridBagConstraints);
        return jPanel;
    }

    private JPanel buildButtonsBar() {
        int n = 0;
        ArrayList arrayList = new ArrayList();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 0));
        arrayList.add((Object)this.mResetButton);
        n = Math.max(n, this.mResetButton.getMinimumSize().width);
        this.mResetButton.setEnabled(true);
        this.mResetButton.addActionListener(new 9());
        arrayList.add((Object)this.mStopButton);
        n = Math.max(n, this.mStopButton.getMinimumSize().width);
        this.mStopButton.setEnabled(false);
        this.mStopButton.addActionListener(new 8());
        arrayList.add((Object)this.mRunButton);
        n = Math.max(n, this.mRunButton.getMinimumSize().width);
        this.mRunButton.setEnabled(true);
        this.mRunButton.addActionListener(new 7());
        Dimension dimension = new Dimension(n, this.mRunButton.getMinimumSize().height);
        Dimension dimension2 = new Dimension(8, 0);
        int n2 = 0;
        while (n2 < arrayList.size()) {
            JButton jButton = (JButton)arrayList.get(n2);
            jButton.setPreferredSize(dimension);
            if (n2 == 0) {
                jPanel.add(Box.createHorizontalGlue());
                jPanel.add(jButton);
                jPanel.add(Box.createRigidArea(dimension2));
            } else {
                jPanel.add(jButton);
                jPanel.add(Box.createRigidArea(dimension2));
            }
            ++n2;
        }
        return jPanel;
    }

    private JPanel buildStatusBar() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(gridBagLayout);
        Dimension dimension = jPanel.getPreferredSize();
        dimension.setSize(dimension.getWidth(), 25.0);
        jPanel.setPreferredSize(dimension);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.mMessageAreaLabel.setFont(new Font("SansSerif", 0, 11));
        this.mMessageAreaLabel.setBorder(BorderFactory.createBevelBorder(1));
        dimension = this.mMessageAreaLabel.getPreferredSize();
        dimension.setSize(dimension.getWidth() + 150.0, dimension.getHeight());
        this.mMessageAreaLabel.setPreferredSize(dimension);
        this.mMessageAreaLabel.setText("Ready");
        jPanel.add((Component)this.mMessageAreaLabel, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.mElapsedTimeLabel.setFont(new Font("SansSerif", 0, 11));
        this.mElapsedTimeLabel.setBorder(BorderFactory.createBevelBorder(1));
        jPanel.add((Component)this.mElapsedTimeLabel, gridBagConstraints);
        return jPanel;
    }

    void run() {
        this.reset();
        this.mRunButton.setEnabled(false);
        this.mResetButton.setEnabled(false);
        6 var1_1 = new 6();
        var1_1.start();
    }

    void reset() {
        this.mController.reset();
        this.resetPanelUI();
    }

    void stop() {
        this.mStopButton.setEnabled(false);
        this.mController.stop();
    }

    private void resetPanelUI() {
        this.mNumOfSessionsText.setText("0");
        this.mNumOfIterationsText.setText("0");
        this.mAvgDurationText.setText("0");
        if (this.mApplicationPoolViewPanel != null) {
            this.mApplicationPoolViewPanel.resetPanelUI();
        }
        if (this.mConnectionPoolViewPanel != null) {
            this.mConnectionPoolViewPanel.resetPanelUI();
        }
        if (this.mSimulationParametersPanel != null) {
            this.mSimulationParametersPanel.resetPanelUI();
        }
        this.mElapsedTimeLabel.setText("00:00:00");
        this.mResponseHistoryModel.reset();
        this.mAMPoolSizeHistoryModel.reset();
        this.mConnPoolSizeHistoryModel.reset();
        this.mHistoryGraph.reset();
    }

    private void update() {
        if (this.mUpdateUI) {
            this.updatePanelUI();
            if (this.mUpdateRunStatistics && this.mController.getLogger() != null) {
                Statistics statistics = this.mController.getLogger().getStatistics();
                this.mNumOfSessionsText.setText(new Float(statistics.mNumOfSessions).toString());
                this.mNumOfIterationsText.setText(new Float(statistics.mNumOfIterations).toString());
                float f = (float)Math.round(statistics.mAvgResponseTime * 10.0f) / 10.0f;
                this.mAvgDurationText.setText(new Float(f).toString());
                this.mResponseHistoryModel.addDataPoint(statistics.mAvgResponseTime);
            }
            this.mTimer.schedule((TimerTask)new 5(), REFRESH_RATE);
        }
    }

    private void updatePanelUI() {
        ApplicationPool applicationPool;
        if (this.mApplicationPoolViewPanel != null) {
            this.mApplicationPoolViewPanel.updatePanelUI();
        }
        if (this.mConnectionPoolViewPanel != null) {
            this.mConnectionPoolViewPanel.updatePanelUI();
        }
        ResourcePoolStatistics resourcePoolStatistics = null;
        ConnectionPoolManager connectionPoolManager = null;
        if (ConnectionPoolManagerFactory.isInitialized()) {
            connectionPoolManager = ConnectionPoolManagerFactory.getConnectionPoolManager();
        }
        if (connectionPoolManager instanceof ResourcePoolManager) {
            Enumeration enumeration = ((ResourcePoolManager)connectionPoolManager).getResourcePools();
            while (enumeration.hasMoreElements()) {
                ResourcePool resourcePool = (ResourcePool)enumeration.nextElement();
                if (resourcePoolStatistics == null) {
                    resourcePoolStatistics = resourcePool.getResourcePoolStatistics();
                    continue;
                }
                resourcePoolStatistics.add(resourcePool.getResourcePoolStatistics());
            }
            this.mConnPoolSizeHistoryModel.addDataPoint(resourcePoolStatistics.mResourceCount);
        }
        if ((applicationPool = this.mController.getApplicationPool(false)) != null) {
            oracle.jbo.common.ampool.Statistics statistics = applicationPool.getStatistics();
            this.mAMPoolSizeHistoryModel.addDataPoint(statistics.mResourceCount);
        }
        this.mElapsedTimeLabel.setText(this.mDateFormatter.format(this.mController.getElapsedRunningTime()));
    }

    void fileExit_ActionPerformed(ActionEvent actionEvent) {
        System.exit(0);
    }

    void editSimulation_ActionPerformed(ActionEvent actionEvent) {
        this.mMenuEditSimulation.setEnabled(false);
        JFrame jFrame = new JFrame("Simulation Parameters...");
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jFrame.getContentPane().setLayout(gridBagLayout);
        jFrame.setSize(new Dimension(450, 220));
        jFrame.addWindowListener(new 4());
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mSimulationParametersPanel = new SimulationParametersPanel(this.mController);
        gridBagLayout.setConstraints(this.mSimulationParametersPanel, gridBagConstraints);
        jFrame.getContentPane().add(this.mSimulationParametersPanel);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        jFrame.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        jFrame.setVisible(true);
    }

    void editPool_ActionPerformed(ActionEvent actionEvent) {
        this.mMenuEditPool.setEnabled(false);
        JFrame jFrame = new JFrame("Pool Parameters");
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jFrame.getContentPane().setLayout(gridBagLayout);
        jFrame.setSize(new Dimension(450, 450));
        jFrame.addWindowListener(new 3());
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        PoolParameterPanel poolParameterPanel = new PoolParameterPanel((Frame)this, this.mController);
        gridBagLayout.setConstraints(poolParameterPanel, gridBagConstraints);
        jFrame.getContentPane().add(poolParameterPanel);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        jFrame.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        jFrame.setVisible(true);
    }

    void viewAMPool_ActionPerformed(ActionEvent actionEvent) {
        this.mMenuViewAMPool.setEnabled(false);
        JFrame jFrame = new JFrame("ApplicationPool Statistics");
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jFrame.getContentPane().setLayout(gridBagLayout);
        jFrame.setSize(new Dimension(450, 700));
        jFrame.addWindowListener(new 2());
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mApplicationPoolViewPanel = new ApplicationPoolViewPanel(this.mController);
        gridBagLayout.setConstraints(this.mApplicationPoolViewPanel, gridBagConstraints);
        jFrame.getContentPane().add(this.mApplicationPoolViewPanel);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        jFrame.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        jFrame.setVisible(true);
    }

    void viewConnPool_ActionPerformed(ActionEvent actionEvent) {
        this.mMenuViewConnPool.setEnabled(false);
        JFrame jFrame = new JFrame("ConnectionPool Statistics");
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jFrame.getContentPane().setLayout(gridBagLayout);
        jFrame.setSize(new Dimension(450, 320));
        jFrame.addWindowListener(new 1());
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mConnectionPoolViewPanel = new ConnectionPoolViewPanel(this.mController);
        gridBagLayout.setConstraints(this.mConnectionPoolViewPanel, gridBagConstraints);
        jFrame.getContentPane().add(this.mConnectionPoolViewPanel);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        jFrame.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        new MainFrame();
    }

    public final class 17
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            System.exit(0);
        }
    }

    public final class 16
    extends TimerTask {
        public void run() {
            SwingUtilities.invokeLater(new 1());
        }

        public final class 1
        implements Runnable {
            public void run() {
                MainFrame.this.update();
            }
        }
    }

    public final class 15
    implements Runnable {
        private final /* synthetic */ String v$messageAreaLabelText;
        final /* synthetic */ MainFrame this$0;

        public void run() {
            this.this$0.mMessageAreaLabel.setText(this.v$messageAreaLabelText);
        }

        public /* synthetic */ 15(MainFrame mainFrame, String string) {
            this.v$messageAreaLabelText = string;
            this.this$0 = mainFrame;
        }
    }

    public final class 14
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.fileExit_ActionPerformed(actionEvent);
        }
    }

    public final class 13
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.editSimulation_ActionPerformed(actionEvent);
        }
    }

    public final class 12
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.editPool_ActionPerformed(actionEvent);
        }
    }

    public final class 11
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.viewAMPool_ActionPerformed(actionEvent);
        }
    }

    public final class 10
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.viewConnPool_ActionPerformed(actionEvent);
        }
    }

    public final class 9
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.reset();
        }
    }

    public final class 8
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.stop();
        }
    }

    public final class 7
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.run();
        }
    }

    public final class 6
    extends Thread {
        public void run() {
            MainFrame.this.mController.start();
        }
    }

    public final class 5
    extends TimerTask {
        public void run() {
            SwingUtilities.invokeLater(new 1());
        }

        public final class 1
        implements Runnable {
            public void run() {
                MainFrame.this.update();
            }
        }
    }

    public final class 4
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            MainFrame.this.mSimulationParametersPanel = null;
            MainFrame.this.mMenuEditSimulation.setEnabled(true);
        }
    }

    public final class 3
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            MainFrame.this.mMenuEditPool.setEnabled(true);
        }
    }

    public final class 2
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            ApplicationPoolViewPanel applicationPoolViewPanel = MainFrame.this.mApplicationPoolViewPanel;
            MainFrame.this.mApplicationPoolViewPanel = null;
            applicationPoolViewPanel.close();
            MainFrame.this.mMenuViewAMPool.setEnabled(true);
        }
    }

    public final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            ConnectionPoolViewPanel connectionPoolViewPanel = MainFrame.this.mConnectionPoolViewPanel;
            MainFrame.this.mConnectionPoolViewPanel = null;
            connectionPoolViewPanel.close();
            MainFrame.this.mMenuViewConnPool.setEnabled(true);
        }
    }
}

