/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.jbotester.load;

import java.io.PrintWriter;
import oracle.jbo.jbotester.load.StateChangeListener;
import oracle.jbo.jbotester.load.StateChangedEvent;
import oracle.jbo.jbotester.load.Statistics;

public class Logger
implements Cloneable,
StateChangeListener {
    private final Object mLock;
    private Statistics mStatistics;
    private float mStepTotalDuration;
    private float mStepNumOfIterations;

    private /* synthetic */ void $init$() {
        this.mLock = new Object();
        this.mStatistics = new Statistics();
        this.mStepTotalDuration = 0.0f;
        this.mStepNumOfIterations = 0.0f;
    }

    public Logger() {
        this.$init$();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Statistics getStatistics() {
        Statistics statistics = null;
        Object object = this.mLock;
        synchronized (object) {
            this.computeAverages();
            statistics = (Statistics)this.mStatistics.clone();
        }
        return statistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChanged(StateChangedEvent stateChangedEvent) {
        switch (stateChangedEvent.getNewState()) {
            case 2: {
                if (stateChangedEvent.getOldState() != 3) break;
                Object object = this.mLock;
                synchronized (object) {
                    float f = stateChangedEvent.getStateChangeInterval();
                    this.mStatistics.mMaxResponseTime = Math.max(this.mStatistics.mMaxResponseTime, f);
                    this.mStatistics.mMinResponseTime = Math.min(this.mStatistics.mMinResponseTime, f);
                    this.mStepTotalDuration += f;
                    this.mStepNumOfIterations += 1.0f;
                    if (this.mStepNumOfIterations % 1000.0f == 0.0f) {
                        this.computeAverages();
                    }
                    break;
                }
            }
            case 1: {
                Object object = this.mLock;
                synchronized (object) {
                    this.mStatistics.mNumOfSessions += 1.0f;
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeAverages() {
        Object object = this.mLock;
        synchronized (object) {
            this.mStepTotalDuration += this.mStatistics.mAvgResponseTime * this.mStatistics.mNumOfIterations;
            this.mStatistics.mNumOfIterations += this.mStepNumOfIterations;
            if (this.mStatistics.mNumOfIterations > 0.0f) {
                this.mStatistics.mAvgResponseTime = this.mStepTotalDuration / this.mStatistics.mNumOfIterations;
            }
            this.mStepTotalDuration = 0.0f;
            this.mStepNumOfIterations = 0.0f;
        }
    }

    public void dumpStatistics(PrintWriter printWriter) {
        Statistics statistics = this.getStatistics();
        printWriter.println("Printing statistics...");
        printWriter.println("Average task completion time(ms):  " + statistics.mAvgResponseTime);
        printWriter.println("Total number of sessions started:  " + statistics.mNumOfSessions);
        printWriter.println("Total number of tasks completed:  " + statistics.mNumOfIterations);
    }
}

