/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.jbotester.load;

import com.sun.java.util.collections.ArrayList;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Timer;
import java.util.TimerTask;
import oracle.jbo.common.JboNameUtil;
import oracle.jbo.common.ampool.ApplicationPool;
import oracle.jbo.common.ampool.PoolMgr;
import oracle.jbo.jbotester.load.Logger;
import oracle.jbo.jbotester.load.Session;
import oracle.jbo.jbotester.load.StateChangeListener;
import oracle.jbo.jbotester.load.StateChangedEvent;
import oracle.jbo.jbotester.load.TaskThreadPool;
import oracle.jbo.jbotester.load.TaskThreadPoolManager;
import oracle.jbo.pool.ResourcePoolManager;
import oracle.jbo.server.ConnectionPoolManager;
import oracle.jbo.server.ConnectionPoolManagerFactory;

public class Controller
implements StateChangeListener {
    private Timer mTimer;
    private static final char NUM_OF_SESSIONS_FLAG = 'N';
    private static final char NUM_OF_ITERATIONS_FLAG = 'I';
    private static final char THINK_TIME_FLAG = 'L';
    private static final char DURATION_FLAG = 'D';
    private static final char TASK_CLASS_NAME_FLAG = 'T';
    private static final char PRINT_HELP_FLAG = '?';
    public static final int NUM_OF_SESSIONS_DEF = 5;
    public static final int NUM_OF_ITERATIONS_DEF = 5;
    public static final int THINK_TIME_DEF = 1000;
    public static final int DURATION_DEF = 60000;
    public static final String TASK_CLASS_NAME_DEF = "oracle.jbo.jbotester.load.DefaultTask";
    public static final int STATE_NEW = 0;
    public static final int STATE_INITIALIZED = 1;
    public static final int STATE_RAMPING_UP = 2;
    public static final int STATE_RUNNING = 3;
    public static final int STATE_RAMPING_DOWN = 4;
    public static final int STATE_COMPLETED = 5;
    public static final int STATE_CANCELLED = 6;
    private static final String[] STATE_DESCRIPTIONS = new String[]{"STATE_NEW", "STATE_INITIALIZED", "STATE_RAMPING_UP", "STATE_RUNNING", "STATE_RAMPING_DOWN", "STATE_COMPLETED", "STATE_CANCELLED"};
    private final String mApplicationPoolName;
    private final String mApplicationModuleDefName;
    private final String mConfigurationName;
    private final boolean mDebug;
    private final Object mLock;
    private Logger mLogger;
    private long mStartTime;
    private ArrayList mControllerStateListeners;
    private int mState;
    private int mNumOfSessions;
    private int mNumOfIterations;
    private int mThinkTime;
    private int mDuration;
    private String mTaskClassName;
    private int mNumOfInitializedSessions;

    private /* synthetic */ void $init$() {
        this.mDebug = false;
        this.mLock = new Object();
        this.mLogger = null;
        this.mStartTime = -1;
        this.mControllerStateListeners = new ArrayList(0);
        this.mState = 0;
        this.mNumOfSessions = 5;
        this.mNumOfIterations = 5;
        this.mThinkTime = 1000;
        this.mDuration = 60000;
        this.mTaskClassName = TASK_CLASS_NAME_DEF;
        this.mNumOfInitializedSessions = 0;
    }

    Controller(String string, String string2) {
        this.$init$();
        this.mApplicationModuleDefName = string;
        this.mConfigurationName = string2;
        String string3 = JboNameUtil.getContainerPartOfName((String)this.mApplicationModuleDefName);
        this.mApplicationPoolName = string3 + '.' + this.mConfigurationName;
        this.transitionState(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void transitionState(int n) {
        int n2 = -1;
        Object object = this.mLock;
        synchronized (object) {
            n2 = this.getState();
            switch (n) {
                case 1: {
                    if (n2 == 0 || n2 == 5) break;
                    return;
                }
                case 2: {
                    if (n2 == 1) break;
                    return;
                }
                case 3: {
                    if (n2 == 2) break;
                    return;
                }
                case 6: {
                    if (n2 == 2 || n2 == 3) break;
                    return;
                }
                case 4: {
                    if (n2 == 3) break;
                    return;
                }
                case 5: {
                    if (n2 == 4 || n2 == 6) break;
                    return;
                }
            }
            this.mState = n;
        }
        if (this.isDebug()) {
            StringBuffer stringBuffer = new StringBuffer("Transitioned controller from state ");
            stringBuffer.append(STATE_DESCRIPTIONS[n2]);
            stringBuffer.append(" to state ");
            stringBuffer.append(STATE_DESCRIPTIONS[n]);
            System.out.println(stringBuffer.toString());
        }
        this.fireControllerStateChanged(new StateChangedEvent(this, n2, n));
        switch (n) {
            case 1: {
                this.initialize();
                break;
            }
            case 2: {
                this.rampUp();
                break;
            }
            case 3: {
                this.run();
                break;
            }
            case 4: 
            case 6: {
                this.rampDown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getState() {
        Object object = this.mLock;
        synchronized (object) {
            int n = this.mState;
            return n;
        }
    }

    private void initialize() {
        if (this.mTimer != null) {
            this.mTimer.cancel();
            this.mTimer = null;
        }
        this.mTimer = new Timer();
    }

    public void setNumOfSessions(int n) {
        this.mNumOfSessions = n;
    }

    public int getNumOfSessions() {
        return this.mNumOfSessions;
    }

    public void setNumOfIterations(int n) {
        this.mNumOfIterations = n;
    }

    public int getNumOfIterations() {
        return this.mNumOfIterations;
    }

    public void setThinkTime(int n) {
        this.mThinkTime = n;
    }

    public int getThinkTime() {
        return this.mThinkTime;
    }

    public void setDuration(int n) {
        this.mDuration = n;
    }

    public int getDuration() {
        return this.mDuration;
    }

    public String getTaskClassName() {
        return this.mTaskClassName;
    }

    public void setTaskClassName(String string) {
        this.mTaskClassName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int schedule(TimerTask timerTask, long l) {
        int n = 0;
        Object object = this.mLock;
        synchronized (object) {
            int n2 = this.getState();
            if (n2 == 2 || n2 == 3) {
                this.mTimer.schedule(timerTask, l);
            } else {
                n = 1;
            }
        }
        return n;
    }

    public void start() {
        if (this.getState() == 5) {
            this.transitionState(1);
        }
        this.transitionState(2);
    }

    private void run() {
        int n = 0;
        while (n < this.mDuration && this.getState() == 3) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            n += 1000;
        }
        this.transitionState(4);
    }

    void stop() {
        this.transitionState(6);
    }

    public void resetParameters() {
        this.mNumOfSessions = 5;
        this.mNumOfIterations = 5;
        this.mThinkTime = 1000;
        this.mDuration = 60000;
        this.mTaskClassName = TASK_CLASS_NAME_DEF;
    }

    public void reset() {
        ConnectionPoolManager connectionPoolManager;
        if (this.getState() != 5 || this.getState() != 1) {
            return;
        }
        this.mLogger = null;
        if (this.mApplicationPoolName != null && PoolMgr.getInstance().isPoolCreated(this.mApplicationPoolName)) {
            PoolMgr.getInstance().removeResourcePool((Object)this.mApplicationPoolName);
        }
        if (ConnectionPoolManagerFactory.isInitialized() && (connectionPoolManager = ConnectionPoolManagerFactory.getConnectionPoolManager()) instanceof ResourcePoolManager) {
            ResourcePoolManager resourcePoolManager = (ResourcePoolManager)connectionPoolManager;
            Enumeration enumeration = resourcePoolManager.getResourcePoolKeys();
            while (enumeration.hasMoreElements()) {
                resourcePoolManager.removeResourcePool(enumeration.nextElement());
            }
        }
        this.transitionState(1);
    }

    public ApplicationPool getApplicationPool(boolean bl) {
        ApplicationPool applicationPool = null;
        applicationPool = bl ? PoolMgr.getInstance().findPool(this.mApplicationPoolName, JboNameUtil.getContainerPartOfName((String)this.mApplicationModuleDefName), this.mConfigurationName, null) : (ApplicationPool)PoolMgr.getInstance().getResourcePool((Object)this.mApplicationPoolName);
        return applicationPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rampUp() {
        this.mStartTime = System.currentTimeMillis();
        this.mLogger = new Logger();
        this.getApplicationPool(true);
        TaskThreadPool taskThreadPool = (TaskThreadPool)((Object)TaskThreadPoolManager.getInstance().getResourcePool("x"));
        taskThreadPool.open();
        Session session = null;
        int n = 0;
        while (n < this.mNumOfSessions) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.getState() != 2) {
                    return;
                }
                session = new Session(this, new Integer(n).toString(), new Integer(n).toString());
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++n;
        }
        this.transitionState(3);
    }

    private void rampDown() {
        while (this.mNumOfInitializedSessions > 0) {
            try {
                Thread.sleep(100);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.mTimer.cancel();
        TaskThreadPool taskThreadPool = (TaskThreadPool)((Object)TaskThreadPoolManager.getInstance().getResourcePool("x"));
        taskThreadPool.close();
        if (this.isDebug()) {
            System.out.println("Dumping thread pool statistics...");
            taskThreadPool.dumpPoolStatistics(new PrintWriter(System.out, true));
        }
        this.mLogger.dumpStatistics(new PrintWriter(System.out, true));
        this.transitionState(5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addControllerStateListener(StateChangeListener stateChangeListener) {
        ArrayList arrayList = this.mControllerStateListeners;
        synchronized (arrayList) {
            this.mControllerStateListeners.add((Object)stateChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeControllerStateListener(StateChangeListener stateChangeListener) {
        ArrayList arrayList = this.mControllerStateListeners;
        synchronized (arrayList) {
            this.mControllerStateListeners.remove((Object)stateChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireControllerStateChanged(StateChangedEvent stateChangedEvent) {
        ArrayList arrayList = null;
        ArrayList arrayList2 = this.mControllerStateListeners;
        synchronized (arrayList2) {
            arrayList = (ArrayList)this.mControllerStateListeners.clone();
        }
        int n = 0;
        while (n < arrayList.size()) {
            ((StateChangeListener)arrayList.get(n)).stateChanged(stateChangedEvent);
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChanged(StateChangedEvent stateChangedEvent) {
        switch (stateChangedEvent.getNewState()) {
            case 5: {
                Object object = this.mLock;
                synchronized (object) {
                    --this.mNumOfInitializedSessions;
                }
                Object object2 = this.mLock;
                synchronized (object2) {
                    int n = this.getState();
                    if (n != 4 && n != 6) {
                        Session session = new Session(this, ((Session)stateChangedEvent.getSource()).getApplicationId(), ((Session)stateChangedEvent.getSource()).getSessionId());
                    }
                    break;
                }
            }
            case 1: {
                Object object = this.mLock;
                synchronized (object) {
                    ++this.mNumOfInitializedSessions;
                    break;
                }
            }
        }
        if (this.getState() == 3) {
            this.mLogger.stateChanged(stateChangedEvent);
        }
    }

    long getElapsedRunningTime() {
        long l = 0L;
        if (this.mState == 2 || this.mState == 3 || this.mState == 4 || this.mState == 6) {
            l = System.currentTimeMillis() - this.mStartTime;
        }
        return l;
    }

    Logger getLogger() {
        return this.mLogger;
    }

    public Timer getTimer() {
        return this.mTimer;
    }

    boolean isDebug() {
        return false;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            Controller.printUsage();
            System.exit(0);
        }
        Controller controller = new Controller(stringArray[stringArray.length - 2], stringArray[stringArray.length - 1]);
        int n = 0;
        while (n < stringArray.length - 2) {
            if (!stringArray[n].startsWith("-") && !stringArray[n].startsWith("/") || stringArray[n].length() != 2) {
                Controller.printUsage();
                System.exit(0);
            }
            char c = Character.toUpperCase(stringArray[n].charAt(1));
            ++n;
            switch (c) {
                case 'N': {
                    controller.setNumOfSessions(Integer.parseInt(stringArray[n]));
                    break;
                }
                case 'I': {
                    controller.setNumOfIterations(Integer.parseInt(stringArray[n]));
                    break;
                }
                case 'L': {
                    controller.setThinkTime(Integer.parseInt(stringArray[n]));
                    break;
                }
                case 'D': {
                    controller.setDuration(Integer.parseInt(stringArray[n]));
                    break;
                }
                case 'T': {
                    controller.setTaskClassName(stringArray[n]);
                    break;
                }
                default: {
                    Controller.printUsage();
                    System.exit(0);
                }
            }
            ++n;
        }
        controller.start();
    }

    public static void printUsage() {
        System.out.println("Usage:");
        System.out.println("java oracle.jbo.jbotester.load.LoadController [parameters] <ApplicationDefName> <ConfigName>");
        System.out.println("[parameters]:");
        System.out.println("[-N <num of sessions>] -- The number of concurrent sessions");
        System.out.println("[-I <num of iterations>] -- The number of iterations for each session");
        System.out.println("[-L <think time (ms)>] -- The think time between iterations");
        System.out.println("[-D <test duration (ms)>] -- The duration of the simulation");
        System.out.println("[-T <task class name>] -- The name of the Task class that should be execute for each iteration");
    }
}

