/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.jbotester.load;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Enumeration;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.jbo.jbotester.load.Controller;
import oracle.jbo.jbotester.load.UIHelper;
import oracle.jbo.pool.ResourcePool;
import oracle.jbo.pool.ResourcePoolManager;
import oracle.jbo.pool.ResourcePoolStatistics;
import oracle.jbo.server.ConnectionPoolManager;
import oracle.jbo.server.ConnectionPoolManagerFactory;

public class ConnectionPoolViewPanel
extends JPanel {
    private JLabel mNumOfConnCreationsLabel;
    private JLabel mNumOfConnRemovalsLabel;
    private JLabel mNumOfConnCheckoutsLabel;
    private JLabel mNumOfConnCheckinsLabel;
    private JLabel mNumOfConnsLabel;
    private JLabel mMaxNumOfConnsLabel;
    private JLabel mAvgNumOfConnsLabel;
    private JLabel mNumOfAvailConnsLabel;
    private JLabel mNumOfConns10Label;
    private JLabel mNumOfConns5Label;
    private JLabel mNumOfConns1Label;
    private JLabel mNumOfConns0Label;

    private /* synthetic */ void $init$() {
        this.mNumOfConnCreationsLabel = new JLabel("0");
        this.mNumOfConnRemovalsLabel = new JLabel("0");
        this.mNumOfConnCheckoutsLabel = new JLabel("0");
        this.mNumOfConnCheckinsLabel = new JLabel("0");
        this.mNumOfConnsLabel = new JLabel("0");
        this.mMaxNumOfConnsLabel = new JLabel("0");
        this.mAvgNumOfConnsLabel = new JLabel("0");
        this.mNumOfAvailConnsLabel = new JLabel("0");
        this.mNumOfConns10Label = new JLabel("0");
        this.mNumOfConns5Label = new JLabel("0");
        this.mNumOfConns1Label = new JLabel("0");
        this.mNumOfConns0Label = new JLabel("0");
    }

    public ConnectionPoolViewPanel(Controller controller) {
        this.$init$();
        this.init();
    }

    void init() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.setAlignmentY(0.0f);
        JLabel jLabel = new JLabel("Connection lifetime statistics");
        UIHelper.buildPoolHeaderRow(this, gridBagConstraints, gridBagLayout, jLabel);
        jLabel = new JLabel("Number of Connection creations:");
        UIHelper.buildPoolRow(this, gridBagConstraints, gridBagLayout, jLabel, this.mNumOfConnCreationsLabel);
        jLabel = new JLabel("Number of Connection removals:");
        UIHelper.buildPoolRow(this, gridBagConstraints, gridBagLayout, jLabel, this.mNumOfConnRemovalsLabel);
        jLabel = new JLabel("ConnectionPool use statistics");
        UIHelper.buildPoolHeaderRow(this, gridBagConstraints, gridBagLayout, jLabel);
        jLabel = new JLabel("Number of Connection uses:");
        UIHelper.buildPoolRow(this, gridBagConstraints, gridBagLayout, jLabel, this.mNumOfConnCheckoutsLabel);
        jLabel = new JLabel("Number of Connection releases:");
        UIHelper.buildPoolRow(this, gridBagConstraints, gridBagLayout, jLabel, this.mNumOfConnCheckinsLabel);
        jLabel = new JLabel("Connection statistics");
        UIHelper.buildPoolHeaderRow(this, gridBagConstraints, gridBagLayout, jLabel);
        jLabel = new JLabel("Number of Connections in the pool:");
        UIHelper.buildPoolRow(this, gridBagConstraints, gridBagLayout, jLabel, this.mNumOfConnsLabel);
        jLabel = new JLabel("Maximum number of Connections in the pool:");
        UIHelper.buildPoolRow(this, gridBagConstraints, gridBagLayout, jLabel, this.mMaxNumOfConnsLabel);
        jLabel = new JLabel("Average number of Connections in the pool:");
        UIHelper.buildPoolRow(this, gridBagConstraints, gridBagLayout, jLabel, this.mAvgNumOfConnsLabel);
        jLabel = new JLabel("Number of available Connections in the pool:");
        UIHelper.buildPoolRow(this, gridBagConstraints, gridBagLayout, jLabel, this.mNumOfAvailConnsLabel);
        jLabel = new JLabel("Connection age statistics");
        UIHelper.buildPoolHeaderRow(this, gridBagConstraints, gridBagLayout, jLabel);
        jLabel = new JLabel("Number of Connections unused for >10 min:");
        UIHelper.buildPoolRow(this, gridBagConstraints, gridBagLayout, jLabel, this.mNumOfConns10Label);
        jLabel = new JLabel("Number of Connections unused for >5 min:");
        UIHelper.buildPoolRow(this, gridBagConstraints, gridBagLayout, jLabel, this.mNumOfConns5Label);
        jLabel = new JLabel("Number of Connections unused for >1 min:");
        UIHelper.buildPoolRow(this, gridBagConstraints, gridBagLayout, jLabel, this.mNumOfConns1Label);
        jLabel = new JLabel("Number of Connections used during last 1 min:");
        UIHelper.buildPoolRow(this, gridBagConstraints, gridBagLayout, jLabel, this.mNumOfConns0Label);
    }

    void resetPanelUI() {
        this.mNumOfConnCreationsLabel.setText("0");
        this.mNumOfConnRemovalsLabel.setText("0");
        this.mNumOfConnCheckoutsLabel.setText("0");
        this.mNumOfConnCheckinsLabel.setText("0");
        this.mNumOfConnsLabel.setText("0");
        this.mMaxNumOfConnsLabel.setText("0");
        this.mAvgNumOfConnsLabel.setText("0");
        this.mNumOfAvailConnsLabel.setText("0");
        this.mNumOfConns10Label.setText("0");
        this.mNumOfConns5Label.setText("0");
        this.mNumOfConns1Label.setText("0");
        this.mNumOfConns0Label.setText("0");
    }

    void updatePanelUI() {
        ResourcePoolStatistics resourcePoolStatistics = null;
        ConnectionPoolManager connectionPoolManager = null;
        if (ConnectionPoolManagerFactory.isInitialized()) {
            connectionPoolManager = ConnectionPoolManagerFactory.getConnectionPoolManager();
        }
        if (connectionPoolManager instanceof ResourcePoolManager) {
            Enumeration enumeration = ((ResourcePoolManager)connectionPoolManager).getResourcePools();
            while (enumeration.hasMoreElements()) {
                ResourcePool resourcePool = (ResourcePool)enumeration.nextElement();
                if (resourcePoolStatistics == null) {
                    resourcePoolStatistics = resourcePool.getResourcePoolStatistics();
                    continue;
                }
                resourcePoolStatistics.add(resourcePool.getResourcePoolStatistics());
            }
            this.mNumOfConnCreationsLabel.setText(new Long(resourcePoolStatistics.mNumOfInstanceCreations).toString());
            this.mNumOfConnRemovalsLabel.setText(new Long(resourcePoolStatistics.mNumOfInstanceRemovals).toString());
            this.mNumOfConnCheckoutsLabel.setText(new Long(resourcePoolStatistics.mNumOfCheckouts).toString());
            this.mNumOfConnCheckinsLabel.setText(new Long(resourcePoolStatistics.mNumOfCheckins).toString());
            this.mNumOfConnsLabel.setText(new Integer(resourcePoolStatistics.mResourceCount).toString());
            this.mMaxNumOfConnsLabel.setText(new Long(resourcePoolStatistics.mMaxNumOfInstances).toString());
            this.mAvgNumOfConnsLabel.setText(new Long(resourcePoolStatistics.mAvgNumOfInstances).toString());
            this.mNumOfAvailConnsLabel.setText(new Integer(resourcePoolStatistics.mAvailableResourceCount).toString());
            this.mNumOfConns10Label.setText(new Integer(resourcePoolStatistics.mResourceAgeHistogram.mBuckets[3]).toString());
            this.mNumOfConns5Label.setText(new Integer(resourcePoolStatistics.mResourceAgeHistogram.mBuckets[2]).toString());
            this.mNumOfConns1Label.setText(new Integer(resourcePoolStatistics.mResourceAgeHistogram.mBuckets[1]).toString());
            this.mNumOfConns0Label.setText(new Integer(resourcePoolStatistics.mResourceAgeHistogram.mBuckets[0]).toString());
        }
    }

    void close() {
    }
}

