/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.jbotester;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.jbo.AttributeHints;
import oracle.jbo.LocaleContext;
import oracle.jbo.Variable;
import oracle.jbo.VariableValueManager;
import oracle.jbo.ViewObject;
import oracle.jbo.domain.NullValue;
import oracle.jbo.format.Formatter;
import oracle.jbo.jbotester.ErrorHandler;
import oracle.jbo.jbotester.GenericDialog;
import oracle.jbo.jbotester.JboTesterUtil;
import oracle.jbo.jbotester.MainFrame;
import oracle.jbo.jbotester.Res;

public class VariableDialog
extends GenericDialog {
    private JPanel detailPanel;
    private GridBagConstraints gbc;
    private HashMap mTmpVarValues;
    private JTextField mVarDefaultField;
    private VariableValueManager mVariableManager;
    private JList mVarList;
    private String mVarName;
    private JTextField mVarNameField;
    private JTextField mVarTypeField;
    private JTextField mVarValueField;
    private ViewObject mViewObject;
    private LocaleContext mLocale;
    private boolean canClose;
    private int minLength;

    private /* synthetic */ void $init$() {
        this.mTmpVarValues = new HashMap(4);
        this.mVarDefaultField = new JTextField();
        this.mVariableManager = null;
        this.mVarName = null;
        this.mVarNameField = new JTextField();
        this.mVarTypeField = new JTextField();
        this.mVarValueField = new JTextField();
        this.mViewObject = null;
        this.mLocale = null;
        this.canClose = true;
        this.minLength = 23;
    }

    public VariableDialog(MainFrame mainFrame, ViewObject viewObject) {
        super((Frame)mainFrame, Res.getString(270), new JPanel(), 2);
        this.$init$();
        this.mViewObject = viewObject;
        this.mLocale = viewObject.getRowSet().getApplicationModule().getSession().getLocaleContext();
        this.mVariableManager = this.mViewObject.getVariableManager();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            ErrorHandler.displayError(this.parent, exception);
        }
        this.setHelpLocation("f1_bcbbindvariables_html");
    }

    protected void cancel() {
        this.canClose = true;
    }

    public void close() {
        if (this.canClose) {
            super.close();
        }
    }

    protected void save() {
        this.canClose = true;
        this.updateTmpVarValue();
        Iterator iterator = this.mTmpVarValues.keySet().iterator();
        try {
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Variable variable = this.mVariableManager.findVariable(string);
                if (variable == null || variable.getUpdateableFlag() == 0) continue;
                Object v = this.mTmpVarValues.get(string);
                this.mViewObject.setNamedWhereClauseParam(string, v);
                this.mVariableManager.setVariableValue(string, v);
            }
            this.mViewObject.executeQuery();
        }
        catch (Throwable throwable) {
            this.canClose = false;
            ErrorHandler.displayError(this.parent, throwable);
        }
    }

    private JPanel buildDetailPanel() {
        this.detailPanel = new JPanel(new GridBagLayout());
        this.detailPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), Res.getString(272)));
        this.gbc = new GridBagConstraints();
        this.gbc.gridy = 0;
        this.gbc.anchor = 13;
        this.gbc.insets = new Insets(0, 0, 5, 5);
        this.gbc.fill = 2;
        this.gbc.weightx = 1.0;
        this.createField(this.mVarNameField, 273);
        this.createField(this.mVarTypeField, 274);
        this.createField(this.mVarDefaultField, 275);
        this.createField(this.mVarValueField, 276);
        this.mVarValueField.setEditable(true);
        this.mVarValueField.setFocusable(true);
        VariableDialog variableDialog = this;
        this.mVarValueField.addActionListener(new 3(this, variableDialog));
        this.mVarValueField.addFocusListener(new 2());
        return this.detailPanel;
    }

    private JPanel buildMasterPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(Res.getString(271));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 16;
        jPanel.add((Component)jLabel, gridBagConstraints);
        Variable[] variableArray = this.mVariableManager.getVariablesOfKind("where");
        BindVariable[] bindVariableArray = new BindVariable[variableArray.length];
        int n = 0;
        while (n < bindVariableArray.length) {
            bindVariableArray[n] = new BindVariable(variableArray[n], this.mLocale);
            ++n;
        }
        this.mVarList = new JList<BindVariable>(bindVariableArray);
        this.mVarList.setSelectionMode(0);
        this.mVarList.addListSelectionListener(new 1());
        JScrollPane jScrollPane = new JScrollPane(this.mVarList);
        jScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        return jPanel;
    }

    private void createField(JTextField jTextField, int n) {
        jTextField.setEditable(false);
        jTextField.setFocusable(false);
        int n2 = jTextField.getFont().getSize();
        jTextField.setPreferredSize(new Dimension(this.minLength * n2 * 2 / 3, n2 * 2));
        this.gbc.gridx = 0;
        this.gbc.weightx = 0.0;
        JLabel jLabel = JboTesterUtil.createLabel(n, jTextField);
        this.detailPanel.add((Component)jLabel, this.gbc);
        this.gbc.gridx = 1;
        this.gbc.weightx = 1.0;
        this.detailPanel.add((Component)jTextField, this.gbc);
        ++this.gbc.gridy;
    }

    private void determineMinLength() {
        Variable[] variableArray = this.mVariableManager.getVariables();
        int n = 0;
        while (n < variableArray.length) {
            Object object;
            Variable variable = variableArray[n];
            this.minLength = Math.max(variable.getName().length(), this.minLength);
            if (variable.getJavaType() != null) {
                this.minLength = Math.max(variable.getJavaType().getName().length(), this.minLength);
            }
            if (variable.getDefaultValue() != null) {
                this.minLength = Math.max(variable.getDefaultValue().toString().length(), this.minLength);
            }
            if ((object = this.mVariableManager.getVariableValue(variable)) != null) {
                this.minLength = Math.max(object.toString().length(), this.minLength);
            }
            ++n;
        }
    }

    private Object getVariableValue(String string) {
        Object object = this.mTmpVarValues.get(string);
        if (object == null) {
            object = this.mVariableManager.getVariableValue(string);
        }
        if (object == null) {
            object = this.mVariableManager.findVariable(string).getDefaultValue();
        }
        return object;
    }

    private void jbInit() throws Exception {
        this.determineMinLength();
        this.mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mainPanel.add((Component)this.buildMasterPanel(), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 0.0;
        this.mainPanel.add((Component)this.buildDetailPanel(), gridBagConstraints);
        this.mVarList.setSelectedIndex(0);
    }

    private void updateDetailPanel(BindVariable bindVariable) {
        String string = bindVariable.getName();
        this.updateTmpVarValue();
        this.mVarName = string;
        Variable variable = this.mVariableManager.findVariable(string);
        this.mVarNameField.setText(variable.getName());
        Class clazz = variable.getJavaType();
        this.mVarTypeField.setText(clazz == null ? "" : clazz.getName());
        Object object = variable.getDefaultValue();
        this.setText(variable, this.mVarDefaultField, object);
        Object object2 = this.getVariableValue(string);
        this.setText(variable, this.mVarValueField, object2);
        AttributeHints attributeHints = variable.getUIHelper();
        this.mVarValueField.setToolTipText(attributeHints == null ? "" : attributeHints.getTooltip(this.mLocale));
        this.mVarValueField.setEditable(variable.getUpdateableFlag() != 0);
    }

    private void setText(Variable variable, JTextField jTextField, Object object) {
        Formatter formatter;
        AttributeHints attributeHints;
        if (object != null && (attributeHints = variable.getUIHelper()) != null && (formatter = attributeHints.getFormatter(this.mLocale)) != null) {
            try {
                String string = formatter.getDefaultFormatString();
                object = formatter.format(string, object);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        jTextField.setText(object == null ? "" : object.toString());
    }

    private String getText(Variable variable, JTextField jTextField) {
        Formatter formatter;
        AttributeHints attributeHints;
        String string = jTextField.getText();
        if (string != null && (attributeHints = variable.getUIHelper()) != null && (formatter = attributeHints.getFormatter(this.mLocale)) != null) {
            try {
                string = formatter.parseObject(string).toString();
            }
            catch (ParseException parseException) {
                string = jTextField.getText();
            }
        }
        return string;
    }

    private void updateTmpVarValue() {
        if (this.mVarName != null) {
            Variable variable = this.mVariableManager.findVariable(this.mVarName);
            String string = this.getText(variable, this.mVarValueField);
            if (string == null) {
                string = new NullValue();
            }
            this.mTmpVarValues.put(this.mVarName, string);
        }
    }

    private class BindVariable {
        private Variable variable;
        private String label;

        public BindVariable(Variable variable, LocaleContext localeContext) {
            this.variable = variable;
            AttributeHints attributeHints = variable.getUIHelper();
            if (attributeHints == null || (this.label = attributeHints.getLabel(localeContext)) == null) {
                this.label = variable.getName();
            }
        }

        public String getName() {
            return this.variable.getName();
        }

        public String toString() {
            return this.label;
        }
    }

    public final class 3
    implements ActionListener {
        private final /* synthetic */ VariableDialog v$dialog;
        final /* synthetic */ VariableDialog this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            this.this$0.updateTmpVarValue();
            this.v$dialog.actionPerformed(new ActionEvent(actionEvent.getSource(), actionEvent.getID(), "ok"));
        }

        public /* synthetic */ 3(VariableDialog variableDialog, VariableDialog variableDialog2) {
            this.v$dialog = variableDialog2;
            this.this$0 = variableDialog;
        }
    }

    public final class 2
    extends FocusAdapter {
        public void focusLost(FocusEvent focusEvent) {
            if (VariableDialog.this.mVarName != null) {
                Variable variable = VariableDialog.this.mVariableManager.findVariable(VariableDialog.this.mVarName);
                VariableDialog.this.setText(variable, VariableDialog.this.mVarValueField, VariableDialog.this.mVarValueField.getText());
            }
        }
    }

    public final class 1
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting() && ((JList)listSelectionEvent.getSource()).getSelectedIndices().length == 1) {
                VariableDialog.this.updateDetailPanel((BindVariable)((JList)listSelectionEvent.getSource()).getSelectedValue());
            }
        }
    }
}

